package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.MaintargetEntity;
import com.ejianc.business.busniessplan.bean.MaintargetdetailEntity;
import com.ejianc.business.busniessplan.service.IMaintargetService;
import com.ejianc.business.change.bean.ChangeMaintargetEntity;
import com.ejianc.business.change.bean.ChangemaintargetdetailEntity;
import com.ejianc.business.change.service.IChangeMaintargetService;
import com.ejianc.business.record.bean.RecordMaintargetEntity;
import com.ejianc.business.record.bean.RecordmaintargetdetailEntity;
import com.ejianc.business.record.service.IRecordMaintargetService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changeMaintarget") 
public class ChangeMaintargetBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Maintarget = "zjkj-Maintarget";//项目主要目标
	private static final String Maintarget_CHANGE = "zjkj-MaintargetChange";//项目主要目标变更
	private static final String Maintarget_RECORD = "zjkj-MaintargetRecord";//项目主要目标变更记录

	//单据类型
	private static final String Maintarget_BILLTYPE_CODE = "BT202202000012";//项目主要目标
	private static final String Maintarget_CHANGE_BILLTYPE_CODE = "BT202202000054";//项目主要目标变更
	private static final String Maintarget_RECORD_BILLTYPE_CODE = "BT202202000055";//项目主要目标变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangeMaintargetService changeMaintargetService;
	@Autowired
	private IMaintargetService maintargetService;
	@Autowired
	private IRecordMaintargetService recordMaintargetService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前单据信息、变更信息
		ChangeMaintargetEntity changeEntity = changeMaintargetService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getMaintargetId());
		MaintargetEntity maintargetEntity = maintargetService.selectById(changeEntity.getMaintargetId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordMaintargetEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("maintarget_id", maintargetEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordMaintargetService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordMaintargetEntity recordMaintargetEntity = BeanMapper.map(maintargetEntity, RecordMaintargetEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordMaintargetEntity);
		recordMaintargetEntity.setBillState(null);
		recordMaintargetEntity.setMaintargetId(maintargetEntity.getId());
		recordMaintargetEntity.setMaintargetCode(maintargetEntity.getBillCode()+"-"+(count+1));
		recordMaintargetEntity.setId(recordId);
		recordMaintargetEntity.setBillCode(maintargetEntity.getBillCode());
		recordMaintargetEntity.setChangeReason(changeEntity.getChangeReason());
		recordMaintargetEntity.setEffectTime(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<MaintargetdetailEntity> maintargetdetailEntity = maintargetEntity.getMaintargetdetailEntities();
		if(maintargetdetailEntity!=null&&maintargetdetailEntity.size()>0){
			List<RecordmaintargetdetailEntity> recordmaintargetdetailEntity = new ArrayList<>();
			for(MaintargetdetailEntity entity : maintargetdetailEntity){
				RecordmaintargetdetailEntity reEntity = BeanMapper.map(entity, RecordmaintargetdetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setMid(recordId);
				recordmaintargetdetailEntity.add(reEntity);
				entity.setRowState("del");
			}
			recordMaintargetEntity.setMaintargetdetailEntities(recordmaintargetdetailEntity);
		}
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Maintarget_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Maintarget_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(maintargetEntity.getId().toString(), sourceBillType, Maintarget , recordId.toString(), targetBillType, Maintarget_RECORD);
		recordMaintargetService.saveOrUpdate(recordMaintargetEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + maintargetEntity.getCreateUserCode());
		//3、修改当前单据状态
		MaintargetEntity newMaintargetEntity = BeanMapper.map(changeEntity, MaintargetEntity.class);
		newMaintargetEntity.setChangeState("3");//状态改为已变更
		newMaintargetEntity.setChangeId(null);
		newMaintargetEntity.setBillState(maintargetEntity.getBillState());
		newMaintargetEntity.setId(maintargetEntity.getId());
		newMaintargetEntity.setCreateTime(maintargetEntity.getCreateTime());
		newMaintargetEntity.setCreateUserCode(maintargetEntity.getCreateUserCode());
		newMaintargetEntity.setTenantId(maintargetEntity.getTenantId());
		newMaintargetEntity.setVersion(maintargetEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangemaintargetdetailEntity> changemaintargetdetailList = changeEntity.getMaintargetdetailEntities();
		if(changemaintargetdetailList!=null&&changemaintargetdetailList.size()>0){
			List<MaintargetdetailEntity> newMaintargetdetailList = BeanMapper.mapList(changemaintargetdetailList, MaintargetdetailEntity.class);
			newMaintargetdetailList.addAll(maintargetdetailEntity);
			newMaintargetEntity.setMaintargetdetailEntities(newMaintargetdetailList);
		}
		logger.info("---------保存--------");
		maintargetService.saveOrUpdate(newMaintargetEntity, false);

		sourceBillType = Maintarget_CHANGE_BILLTYPE_CODE;
		targetBillType = Maintarget_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Maintarget_CHANGE, maintargetEntity.getId().toString(), targetBillType, Maintarget);
		recordMaintargetService.saveOrUpdate(recordMaintargetEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
