package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.CompanyReviewEntity;
import com.ejianc.business.busniessplan.service.ICompanyReviewService;
import com.ejianc.business.change.bean.ChangecompanyreviewEntity;
import com.ejianc.business.change.service.IChangecompanyreviewService;
import com.ejianc.business.record.bean.RecordcompanyreviewEntity;
import com.ejianc.business.record.service.IRecordcompanyreviewService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;

@Service("changecompanyreview") 
public class ChangecompanyreviewBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Companyreview = "zjkj-companyreview";//公司评审
	private static final String Companyreview_CHANGE = "zjkj-companyreviewChange";//公司评审变更
	private static final String Companyreview_RECORD = "zjkj-companyreviewRecord";//公司评审变更记录

	//单据类型
	private static final String Companyreview_BILLTYPE_CODE = "BT202202000019";//公司评审
	private static final String Companyreview_CHANGE_BILLTYPE_CODE = "BT202202000056";//公司评审变更
	private static final String Companyreview_RECORD_BILLTYPE_CODE = "BT202202000061";//公司评审变更记录


	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangecompanyreviewService changecompanyreviewService;
	@Autowired
	private ICompanyReviewService companyReviewService;
	@Autowired
	private IRecordcompanyreviewService recordcompanyreviewService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前单据信息、变更信息
		ChangecompanyreviewEntity changeEntity = changecompanyreviewService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getCompanyReviewId());
		CompanyReviewEntity companyReviewEntity = companyReviewService.selectById(changeEntity.getCompanyReviewId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordcompanyreviewEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("company_review_id", companyReviewEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordcompanyreviewService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordcompanyreviewEntity recordQuotaanalysisEntity = BeanMapper.map(companyReviewEntity, RecordcompanyreviewEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordQuotaanalysisEntity);
		recordQuotaanalysisEntity.setBillState(null);
		recordQuotaanalysisEntity.setCompanyReviewId(companyReviewEntity.getId());
		recordQuotaanalysisEntity.setCompanyReviewCode(companyReviewEntity.getBillCode()+"-"+(count+1));
		recordQuotaanalysisEntity.setId(recordId);
		recordQuotaanalysisEntity.setBillCode(companyReviewEntity.getBillCode());
		recordQuotaanalysisEntity.setChangeReason(changeEntity.getChangeReason());
		recordQuotaanalysisEntity.setEffectTime(new Date());
		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Companyreview_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Companyreview_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(companyReviewEntity.getId().toString(), sourceBillType, Companyreview , recordId.toString(), targetBillType, Companyreview_RECORD);
		recordcompanyreviewService.saveOrUpdate(recordQuotaanalysisEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + companyReviewEntity.getCreateUserCode());
		//3、修改当前单据状态
		CompanyReviewEntity newCompanyReviewEntity = BeanMapper.map(changeEntity, CompanyReviewEntity.class);
		newCompanyReviewEntity.setChangeState("3");//状态改为已变更
		newCompanyReviewEntity.setChangeId(null);
		newCompanyReviewEntity.setBillState(companyReviewEntity.getBillState());
		newCompanyReviewEntity.setId(companyReviewEntity.getId());
		newCompanyReviewEntity.setCreateTime(companyReviewEntity.getCreateTime());
		newCompanyReviewEntity.setCreateUserCode(companyReviewEntity.getCreateUserCode());
		newCompanyReviewEntity.setTenantId(companyReviewEntity.getTenantId());
		newCompanyReviewEntity.setVersion(companyReviewEntity.getVersion());

		logger.info("---------保存--------");
		companyReviewService.saveOrUpdate(newCompanyReviewEntity, false);

		sourceBillType = Companyreview_CHANGE_BILLTYPE_CODE;
		targetBillType = Companyreview_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Companyreview_CHANGE, companyReviewEntity.getId().toString(), targetBillType, Companyreview);
		recordcompanyreviewService.saveOrUpdate(recordQuotaanalysisEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
