/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.busniessplan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.busniessplan.bean.PlanprojectEntity;
import com.ejianc.business.busniessplan.bean.PlanprojectdetailEntity;
import com.ejianc.business.busniessplan.service.IPlanprojectService;
import com.ejianc.business.busniessplan.vo.PlanprojectVO;
import com.ejianc.business.busniessplan.vo.PlanprojectdetailVO;
import com.ejianc.business.change.bean.ChangePlanprojectEntity;
import com.ejianc.business.change.service.IChangePlanprojectService;
import com.ejianc.business.record.service.IRecordPlanprojectService;
import com.ejianc.business.record.vo.RecordPlanprojectVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"planproject"})
public class PlanprojectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IChangePlanprojectService changePlanprojectService;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "businessplan_planproject";
    @Autowired
    private IPlanprojectService service;
    @Autowired
    private IRecordPlanprojectService recordPlanprojectService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanprojectVO> saveOrUpdate(@RequestBody PlanprojectVO saveorUpdateVO) {
        List<PlanprojectdetailEntity> planprojectdetailEntityList;
        PlanprojectEntity entity = (PlanprojectEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), PlanprojectEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveorUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setChangeState("1");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        queryWrapper.eq((Object)"dr", (Object)"0");
        List pro = this.service.list((Wrapper)queryWrapper);
        if (entity.getId() == null || entity.getId() == 0L) {
            if (pro.size() > 0) {
                throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u9879\u76ee\u5546\u52a1\u7b56\u5212\u7acb\u9879\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa!");
            }
        } else if (pro.size() > 0) {
            for (int i = 0; i < pro.size(); ++i) {
                if (entity.getId().equals(((PlanprojectEntity)((Object)pro.get(i))).getId())) continue;
                throw new BusinessException("\u8be5\u9879\u76ee\u5df2\u7ecf\u521b\u5efa\u4e00\u4e2a\u9879\u76ee\u5546\u52a1\u7b56\u5212\u7acb\u9879\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa!!");
            }
        }
        if (CollectionUtils.isNotEmpty(planprojectdetailEntityList = entity.getPlanprojectdetailEntities())) {
            long count = planprojectdetailEntityList.stream().filter(s -> s.getRowState() == null || !s.getRowState().equals("del")).count();
            entity.setLineNum((int)count);
        }
        this.service.saveOrUpdate((Object)entity, false);
        PlanprojectVO vo = (PlanprojectVO)((Object)BeanMapper.map((Object)((Object)entity), PlanprojectVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PlanprojectEntity checkBillCodeUniq(PlanprojectEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            return entity;
        } else {
            QueryWrapper queryWrapperBillCode = new QueryWrapper();
            queryWrapperBillCode.eq((Object)"bill_code", (Object)entity.getBillCode());
            queryWrapperBillCode.eq((Object)"dr", (Object)"0");
            List proBillCode = this.service.list((Wrapper)queryWrapperBillCode);
            if (proBillCode == null || proBillCode.size() <= 0) return entity;
            for (int i = 0; i < proBillCode.size(); ++i) {
                PlanprojectEntity planprojectEntityCode = (PlanprojectEntity)((Object)proBillCode.get(i));
                if (planprojectEntityCode.getId().equals(entity.getId())) continue;
                throw new BusinessException("\u5355\u636e\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165!");
            }
        }
        return entity;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanprojectVO> queryDetail(Long id) {
        PlanprojectEntity entity = (PlanprojectEntity)((Object)this.service.selectById(id));
        PlanprojectVO vo = (PlanprojectVO)((Object)BeanMapper.map((Object)((Object)entity), PlanprojectVO.class));
        if (!"1".equals(vo.getChangeState())) {
            List records;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"dr", (Object)0);
            queryWrapper.eq((Object)"planproject_id", (Object)vo.getId());
            if (vo.getProjectCategory() != null && vo.getProjectCategory() != "") {
                queryWrapper.eq((Object)"project_category", (Object)vo.getProjectCategory());
            }
            if ((records = this.recordPlanprojectService.list((Wrapper)queryWrapper)) != null && records.size() > 0) {
                List recordPlanprojectVOS = BeanMapper.mapList((Iterable)records, RecordPlanprojectVO.class);
                List changeIds = recordPlanprojectVOS.stream().map(RecordPlanprojectVO::getChangeId).collect(Collectors.toList());
                LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
                lambdaQueryWrapper.in(BaseEntity::getId, changeIds);
                List planprojectEntityList = this.changePlanprojectService.list((Wrapper)lambdaQueryWrapper);
                Map map = planprojectEntityList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
                for (RecordPlanprojectVO recordPlanprojectVO : recordPlanprojectVOS) {
                    if (!map.containsKey(recordPlanprojectVO.getChangeId())) continue;
                    ChangePlanprojectEntity changePlanprojectEntity = (ChangePlanprojectEntity)((Object)map.get(recordPlanprojectVO.getChangeId()));
                    recordPlanprojectVO.setChangeCode(recordPlanprojectVO.getPlanprojectCode());
                }
                vo.setRecordPlanprojectList(recordPlanprojectVOS);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanprojectVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlanprojectVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("agentName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlanprojectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("agentName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List planprojectVOList = BeanMapper.mapList((Iterable)list, PlanprojectVO.class);
        for (int i = 0; i < planprojectVOList.size(); ++i) {
            PlanprojectVO planprojectVO = (PlanprojectVO)((Object)planprojectVOList.get(i));
            planprojectVO.setSort(String.valueOf(i + 1));
            if (planprojectVO.getCreateTime() != null) {
                planprojectVO.setCreateTimeShow(DateUtils.dateSimple2(planprojectVO.getCreateTime()));
            }
            String billStateStr = planprojectVO.getBillState().toString();
            String changeState = planprojectVO.getChangeState();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {
                    billStateStr = "\u81ea\u7531\u6001";
                } else if ("1".equals(billStateStr)) {
                    billStateStr = "\u5df2\u63d0\u4ea4";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u4e2d";
                } else if ("3".equals(billStateStr)) {
                    billStateStr = "\u5ba1\u6279\u901a\u8fc7";
                } else if ("4".equals(billStateStr)) {
                    billStateStr = "\u9a73\u56de";
                }
                planprojectVO.setBillStateStr(billStateStr);
            }
            if (changeState == null) continue;
            if ("1".equals(changeState)) {
                changeState = "\u672a\u53d8\u66f4";
            } else if ("2".equals(changeState)) {
                changeState = "\u53d8\u66f4\u4e2d";
            } else if ("3".equals(changeState)) {
                changeState = "\u5df2\u53d8\u66f4";
            }
            planprojectVO.setChangeState(changeState);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", planprojectVOList);
        ExcelExport.getInstance().export("PlanprojectMain-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPlanprojectData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PlanprojectVO>> refPlanprojectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlanprojectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public static List<PlanprojectdetailVO> createTreeData(List<PlanprojectdetailVO> list) {
        ArrayList<PlanprojectdetailVO> resp = new ArrayList<PlanprojectdetailVO>();
        ArrayList<String> rootItems = new ArrayList<String>();
        HashMap<String, PlanprojectdetailVO> listMap = new HashMap<String, PlanprojectdetailVO>();
        for (PlanprojectdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }
        for (int i = 0; i < list.size(); ++i) {
            PlanprojectdetailVO item;
            item = list.get(i);
            String parentId = item.getTpid() != null ? item.getTpid().toString() : "";
            PlanprojectdetailVO parent = (PlanprojectdetailVO)((Object)listMap.get(parentId));
            if (parent != null) {
                List<PlanprojectdetailVO> child = parent.getChildren();
                if (child != null) {
                    child.add(item);
                    continue;
                }
                ArrayList<PlanprojectdetailVO> children = new ArrayList<PlanprojectdetailVO>();
                children.add(item);
                parent.setChildren(children);
                continue;
            }
            rootItems.add(item.getTid());
        }
        for (String rootId : rootItems) {
            resp.add((PlanprojectdetailVO)((Object)listMap.get(rootId)));
        }
        return resp;
    }

    @RequestMapping(value={"/queryDetailList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanprojectVO> queryDetailList(@RequestBody String porjectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_id", (Object)porjectId);
        List records = this.service.list((Wrapper)queryWrapper);
        PlanprojectVO vo = new PlanprojectVO();
        for (PlanprojectEntity entity : records) {
            PlanprojectEntity list = (PlanprojectEntity)((Object)this.service.selectById(entity.getId()));
            vo = (PlanprojectVO)((Object)BeanMapper.map((Object)((Object)list), PlanprojectVO.class));
        }
        List<PlanprojectdetailVO> planprojectdetailVO = vo.getPlanprojectdetailEntities();
        List<PlanprojectdetailVO> resPlanprojectdetailVO = PlanprojectController.createTreeData(planprojectdetailVO);
        vo.setPlanprojectdetailEntities(resPlanprojectdetailVO);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }
}

