/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.change.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.change.bean.ChangeFundsplanningEntity;
import com.ejianc.business.change.bean.ChangeFundsplanningdetailEntity;
import com.ejianc.business.change.service.IChangeFundsplanningService;
import com.ejianc.business.change.service.IChangeFundsplanningdetailService;
import com.ejianc.business.change.vo.ChangeFundsplanningVO;
import com.ejianc.business.change.vo.ChangeFundsplanningdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"changeFundsplanningExport"})
public class ExcelChangeFundsplanningController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IChangeFundsplanningdetailService changeFundsplanningdetailService;
    @Autowired
    private IChangeFundsplanningService service;

    @RequestMapping(value={"/downloadFundsplanning"})
    @ResponseBody
    public void downloadFundsplanning(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"fundsplanning-import.xlsx", (String)"\u5546\u52a1\u7b56\u5212\u4e66\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportFundsplanning"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportFundsplanning(HttpServletRequest request, HttpServletResponse response, String id, String projectId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ChangeFundsplanningdetailVO> successList = new ArrayList<ChangeFundsplanningdetailVO>();
        ArrayList<ChangeFundsplanningdetailVO> errorList = new ArrayList<ChangeFundsplanningdetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0 && result != null && result.size() > 0) {
            List<ChangeFundsplanningdetailEntity> pastDetailVOList;
            Long billId = null;
            Long billProjectId = null;
            billId = id != null && !"null".equals(id) ? Long.valueOf(Long.parseLong(id)) : null;
            if (projectId != null) {
                billProjectId = Long.parseLong(projectId);
            }
            ChangeFundsplanningEntity pastVO = this.pastData(billId, billProjectId);
            HashMap<String, ChangeFundsplanningdetailEntity> pastDetailMap = new HashMap<String, ChangeFundsplanningdetailEntity>();
            if (pastVO != null && (pastDetailVOList = pastVO.getFundsplanningdetailEntities()) != null && pastDetailVOList.size() > 0) {
                for (int i = 0; i < pastDetailVOList.size(); ++i) {
                    ChangeFundsplanningdetailEntity pastDetailVO = pastDetailVOList.get(i);
                    pastDetailMap.put(pastDetailVO.getCollectbranchTime1(), pastDetailVO);
                }
            }
            for (int i = 2; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                ChangeFundsplanningdetailVO fundsplanningdetailVO = new ChangeFundsplanningdetailVO();
                fundsplanningdetailVO.setId(IdWorker.getId());
                fundsplanningdetailVO.setSort((String)datas.get(0));
                fundsplanningdetailVO.setCollectbranchTime1(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                fundsplanningdetailVO.setImagenode(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                fundsplanningdetailVO.setPlancomplete(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new BigDecimal((String)datas.get(3)) : null);
                fundsplanningdetailVO.setCivilengineering(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? new BigDecimal((String)datas.get(4)) : new BigDecimal(0));
                fundsplanningdetailVO.setInstallation(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : new BigDecimal(0));
                fundsplanningdetailVO.setOther(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? new BigDecimal((String)datas.get(6)) : new BigDecimal(0));
                if (pastDetailMap.get(fundsplanningdetailVO.getCollectbranchTime1()) != null) continue;
                if (fundsplanningdetailVO.getCioAmount() == null || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(7)))) {
                    BigDecimal cioAmountB = new BigDecimal(0);
                    if (fundsplanningdetailVO.getOther() != null) {
                        cioAmountB = cioAmountB.add(fundsplanningdetailVO.getOther());
                    }
                    if (fundsplanningdetailVO.getCivilengineering() != null) {
                        cioAmountB = cioAmountB.add(fundsplanningdetailVO.getCivilengineering());
                    }
                    if (fundsplanningdetailVO.getInstallation() != null) {
                        cioAmountB = cioAmountB.add(fundsplanningdetailVO.getInstallation());
                    }
                    fundsplanningdetailVO.setCioAmount(cioAmountB);
                } else {
                    fundsplanningdetailVO.setCioAmount(new BigDecimal((String)datas.get(7)));
                }
                fundsplanningdetailVO.setLabourservices(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : new BigDecimal(0));
                fundsplanningdetailVO.setMaterial(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : new BigDecimal(0));
                fundsplanningdetailVO.setProfessional(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : new BigDecimal(0));
                fundsplanningdetailVO.setOthercost(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? new BigDecimal((String)datas.get(12)) : new BigDecimal(0));
                fundsplanningdetailVO.setAnswer(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(15))) ? (String)datas.get(15) : null);
                fundsplanningdetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(16))) ? (String)datas.get(16) : null);
                fundsplanningdetailVO.setSalary(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? new BigDecimal((String)datas.get(11)) : new BigDecimal(0));
                if (fundsplanningdetailVO.getCurrent() == null || StringUtils.isBlank((CharSequence)((CharSequence)datas.get(13)))) {
                    BigDecimal currentDec = fundsplanningdetailVO.getLabourservices().add(fundsplanningdetailVO.getMaterial()).add(fundsplanningdetailVO.getProfessional()).add(fundsplanningdetailVO.getOthercost()).add(fundsplanningdetailVO.getSalary());
                    fundsplanningdetailVO.setCurrent(fundsplanningdetailVO.getCioAmount().subtract(currentDec));
                } else {
                    fundsplanningdetailVO.setCurrent(new BigDecimal((String)datas.get(13)));
                }
                if (StringUtils.isEmpty((CharSequence)((CharSequence)datas.get(0)))) {
                    fundsplanningdetailVO.setErrorMsg("\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(fundsplanningdetailVO);
                    continue;
                }
                successList.add(fundsplanningdetailVO);
            }
        }
        if (successList.size() > 0) {
            ChangeFundsplanningdetailVO lastVO = null;
            for (int i = 0; i < successList.size(); ++i) {
                ChangeFundsplanningdetailVO detailVO = (ChangeFundsplanningdetailVO)((Object)successList.get(i));
                if (lastVO == null) {
                    detailVO.setCumulative(detailVO.getCurrent());
                } else {
                    BigDecimal lastCumulative = lastVO.getCumulative();
                    detailVO.setCumulative(lastCumulative.add(detailVO.getCurrent()));
                }
                lastVO = detailVO;
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    public ChangeFundsplanningEntity pastData(Long id, Long projectId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            ChangeFundsplanningEntity currentEntity = (ChangeFundsplanningEntity)((Object)this.service.selectById(id));
            currentDate = currentEntity.getCreateTime();
        }
        return this.getPastData(projectId, currentDate);
    }

    private ChangeFundsplanningEntity getPastData(Long projectId, Date currentDate) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.lt((Object)"create_time", (Object)currentDate);
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.last("limit 1");
        List fundsplanningEntityList = this.service.list((Wrapper)queryWrapper);
        ChangeFundsplanningEntity resEntity = null;
        if (fundsplanningEntityList == null || fundsplanningEntityList.size() == 0) {
            return null;
        }
        resEntity = (ChangeFundsplanningEntity)((Object)fundsplanningEntityList.get(0));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"mid", (Object)resEntity.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List fundsplanningdetailEntityList = this.changeFundsplanningdetailService.list((Wrapper)wrapper);
        if (fundsplanningdetailEntityList != null && fundsplanningdetailEntityList.size() > 0) {
            for (ChangeFundsplanningdetailEntity detail : fundsplanningdetailEntityList) {
                detail.setPastFlag(1);
            }
            resEntity.setFundsplanningdetailEntities(fundsplanningdetailEntityList);
        }
        return resEntity;
    }

    @RequestMapping(value={"/excelExportFundsplanningFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportFundsplanningFromDatabase(@RequestBody ChangeFundsplanningVO fundsVo, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)fundsVo.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.changeFundsplanningdetailService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("fundsplanning-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportFundsplanningFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportFundsplanningFromPage(@RequestBody List<ChangeFundsplanningdetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ChangeFundsplanningdetailVO maintargetdetailVO = list.get(i);
                maintargetdetailVO.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List<ChangeFundsplanningdetailVO>> beans = new HashMap<String, List<ChangeFundsplanningdetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("fundsplanning-export.xlsx", beans, response);
    }
}

