package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.FundrecoveryplanEntity;
import com.ejianc.business.busniessplan.bean.OrgstructureEntity;
import com.ejianc.business.busniessplan.service.IOrgstructureService;
import com.ejianc.business.busniessplan.vo.FundrecoveryplanVO;
import com.ejianc.business.busniessplan.vo.OrgstructureVO;
import com.ejianc.business.change.bean.ChangeFundrecoveryplanEntity;
import com.ejianc.business.change.bean.ChangeOrgstructureEntity;
import com.ejianc.business.change.mapper.ChangeOrgstructureMapper;
import com.ejianc.business.change.service.IChangeOrgstructureService;
import com.ejianc.business.change.vo.ChangeOrgstructureVO;
import com.ejianc.business.record.bean.RecordFundrecoveryplanEntity;
import com.ejianc.business.record.bean.RecordOrgstructureEntity;
import com.ejianc.business.record.bean.RecordOrgstructuredetailEntity;
import com.ejianc.business.record.service.IRecordOrgstructureService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;
import java.util.stream.Collectors;


/**
 * 项目商务组织架构变更
 * 
 * @author generator
 * 
 */
@Service("changeOrgstructureService")
public class ChangeOrgstructureServiceImpl extends BaseServiceImpl<ChangeOrgstructureMapper, ChangeOrgstructureEntity> implements IChangeOrgstructureService {
    @Autowired
    private IOrgstructureService orgstructureService;
    @Autowired
    private IRecordOrgstructureService recordOrgstructureService;
    @Override
    public CommonResponse<ChangeOrgstructureVO> saveChange(ChangeOrgstructureVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeOrgstructureEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangeOrgstructureEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeOrgstructureEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeOrgstructureEntity> queryWrapper = new QueryWrapper<ChangeOrgstructureEntity>();
        queryWrapper.eq("original_id", saveOrUpdateVO.getOriginalId());
        queryWrapper.eq("dr", 0);
        queryWrapper.notIn("bill_state", 1, 3);
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeOrgstructureEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangeOrgstructureVO vo = BeanMapper.map(entity, ChangeOrgstructureVO.class);
        vo.setChangeOrgstructuredetailEntities(saveOrUpdateVO.getChangeOrgstructuredetailEntities());
        vo.setRecordOrgstructureList(saveOrUpdateVO.getRecordOrgstructureList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            OrgstructureEntity quotaanalysisEntity = orgstructureService.selectById(vo.getOriginalId());
            quotaanalysisEntity.setChangeState("2");//状态改为变更中
            quotaanalysisEntity.setChangeId(vo.getId());
            orgstructureService.saveOrUpdate(quotaanalysisEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> deleteOrgStructure(List<OrgstructureVO> vos) {
        for(OrgstructureVO vo : vos){
            ChangeOrgstructureEntity entity = this.getById(vo.getId());
            OrgstructureEntity orgstructureEntity = orgstructureService.selectById(entity.getOriginalId());
            QueryWrapper<RecordOrgstructureEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", orgstructureEntity.getId());
            List<RecordOrgstructureEntity> records = recordOrgstructureService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                orgstructureEntity.setChangeState("3");//状态改为已变更
            }else{
                orgstructureEntity.setChangeState("1");//状态改为未变更
            }
            orgstructureEntity.setChangeId(null);
            orgstructureService.saveOrUpdate(orgstructureEntity, false);
        }
        this.removeByIds(vos.stream().map(OrgstructureVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
}
