package com.ejianc.business.change.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.change.bean.ChangePlanprojectdetailEntity;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 项目商务工作计划变更
 * 
 * @author generator
 * 
 */
 @TableName("ejc_change_businessplan_projectworkplan")
public class ChangeProjectworkplanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="original_id")
    private Long originalId; // 原始单据id
    @TableField(value="effect_date")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date effectDate; // 生效时间
    @TableField(value="change_reason")
    private String changeReason; // 变更原因
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="code")
    private String code; // 编号
    @TableField(exist=false)
    @SubEntity(serviceName="changeProjectworkplandetailService",pidName = "mid")
    private List<com.ejianc.business.change.bean.ChangeProjectworkplandetailEntity> projectworkplandetailEntities = new ArrayList<>(); //项目商务工作计划子表

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public List<com.ejianc.business.change.bean.ChangeProjectworkplandetailEntity> getProjectworkplandetailEntities() {
        return projectworkplandetailEntities;
    }

    public void setProjectworkplandetailEntities(List<com.ejianc.business.change.bean.ChangeProjectworkplandetailEntity> projectworkplandetailEntities) {
        this.projectworkplandetailEntities = projectworkplandetailEntities;
    }

    public Long getOriginalId() {
        return originalId;
    }

    public void setOriginalId(Long originalId) {
        this.originalId = originalId;
    }
    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    
}
