package com.ejianc.business.change.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.vo.MaintargetdetailVO;
import com.ejianc.business.change.bean.ChangemaintargetdetailEntity;
import com.ejianc.business.change.service.IChangemaintargetdetailService;
import com.ejianc.business.change.vo.ChangemaintargetdetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 项目主要目标导入导出
 */
@Controller
@RequestMapping("changeMaintargetExport")
public class ExcelChangeMaintargetController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IChangemaintargetdetailService changemaintargetdetailService;

    /**
     * 导入模板下载
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadMaintarget")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "maintarget-import.xlsx", "商务策划书导入模板");
    }

    /**
     * excel导入
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportMaintarget", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<ChangemaintargetdetailVO> successList = new ArrayList<>();
        List<ChangemaintargetdetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                String[] innateSort = new String[]{
                        "1", "2", "3", "4", "4.1", "4.2", "4.3",
                        "5", "5.1", "5.2", "5.3", "5.4", "5.5", "6",
                        "6.1", "6.2", "7", "8", "9", "10"
                };

                List<String> sortList = Arrays.asList(innateSort);
                String[] innateName = new String[]{
                        "向公司上缴利润", "预留风险金", "项目计划实现利润", "结算确权目标", "中间确权率", "中间计量确认率",
                        "中间阶段结算目标", "成本管理目标", "自行完成合同造价", "标准成本（含税）", "责任成本（含税）", "项目计划成本（含税)",
                        "成本计划降低额", "分供方结算目标", "供方结算目标", "分包结算目标", "工程款回收目标", "质量目标",
                        "现场管理目标", "安全和环境目标"
                };

                for(int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    String sort = datas.get(0);
                    ChangemaintargetdetailVO maintargetdetailVO = new ChangemaintargetdetailVO();
                    maintargetdetailVO.setId(IdWorker.getId());//id
                    String projectName = datas.get(1);
                    maintargetdetailVO.setSort(StringUtils.isNotBlank(sort) ? sort : null); // 序号
                    maintargetdetailVO.setProjectName(StringUtils.isNotBlank(projectName)?projectName:null);//项目名称
                    maintargetdetailVO.setTarget(StringUtils.isNotBlank(datas.get(2))?datas.get(2):null); // 目标
                    maintargetdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(3))?datas.get(3):null); // 备注

                    if(StringUtils.isEmpty(sort)) {
                        maintargetdetailVO.setErrorMsg("序号不能为空！");
                        errorList.add(maintargetdetailVO);
                        continue;
                    }
                    if(StringUtils.isEmpty(projectName)) {
                        maintargetdetailVO.setErrorMsg("项目不能为空！");
                        errorList.add(maintargetdetailVO);
                        continue;
                    }

                    if(i < innateSort.length + 1){//原序号部分
                        if(!sortList.contains(sort)){//校验序号
                            maintargetdetailVO.setErrorMsg("序号与模板不一致");
                            errorList.add(maintargetdetailVO);
                            continue;
                        }
                        if(!sortList.contains(sort)){//校验名称
                            maintargetdetailVO.setErrorMsg("项目与模板不一致");
                            errorList.add(maintargetdetailVO);
                            continue;
                        }
                    }else {//新增部分
                        if(sortList.contains(sort)){//序号不允许重复
                            maintargetdetailVO.setErrorMsg("序号不允许重复");
                            errorList.add(maintargetdetailVO);
                            continue;
                        }
                    }

                    successList.add(maintargetdetailVO);
                }
            }
        }

        //设置tid和tpid
        List<ChangemaintargetdetailVO> resList = setTidAndTpid(successList);

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * 设置tid和tpid
     *
     * @param originalList
     * @return
     */
    private List<ChangemaintargetdetailVO> setTidAndTpid(List<ChangemaintargetdetailVO> originalList) {
        List<ChangemaintargetdetailVO> treeList = new ArrayList<>();
        String currentTime = String.valueOf(System.currentTimeMillis());
        if (originalList != null && originalList.size() > 0) {
            for (int i = 0; i < originalList.size(); i++) {
                ChangemaintargetdetailVO maintargetdetailVO = originalList.get(i);
                String sort = maintargetdetailVO.getSort();
                String[] arr = sort.split("\\.");

                maintargetdetailVO.setId(IdWorker.getId());
                maintargetdetailVO.setTid(currentTime + "_" + sort);
                if (arr.length == 1) {
                    maintargetdetailVO.setTpid("");
                } else if (arr.length > 1) {
                    maintargetdetailVO.setTpid(currentTime + "_" + sort.substring(0, sort.length() - 2));
                }
                treeList.add(maintargetdetailVO);
            }
        }
        return createTreeData(treeList);
    }

    /**
     * 构建树
     *
     * @param list
     * @return
     */
    public static List<ChangemaintargetdetailVO> createTreeData(List<ChangemaintargetdetailVO> list) {
        List<ChangemaintargetdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, ChangemaintargetdetailVO> listMap = new HashMap<>();
        for (ChangemaintargetdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            ChangemaintargetdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            ChangemaintargetdetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<ChangemaintargetdetailVO> child = (List<ChangemaintargetdetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<ChangemaintargetdetailVO> children = new ArrayList<ChangemaintargetdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaintargetFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody ChangemaintargetdetailVO maintargetVO, HttpServletResponse response) {
        QueryWrapper<ChangemaintargetdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", maintargetVO.getId());
        queryWrapper.eq("dr", 0);
        List<ChangemaintargetdetailEntity> list = changemaintargetdetailService.list(queryWrapper);
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("maintarget-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMaintargetFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<ChangemaintargetdetailVO> list, HttpServletResponse response) {
        List<ChangemaintargetdetailVO> concatList = new ArrayList<>();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                ChangemaintargetdetailVO maintargetdetailVO = list.get(i);
                maintargetdetailVO.setSort(String.valueOf(i + 1));
                concatList.add(maintargetdetailVO);
            }
        }

        //children拍平
        List<ChangemaintargetdetailVO> allList = handleList(list, concatList);
        //按序号排序
        Collections.sort(allList, new Comparator<ChangemaintargetdetailVO>() {
            @Override
            public int compare(ChangemaintargetdetailVO o1, ChangemaintargetdetailVO o2) {
                return o1.getTid().compareTo(o2.getTid());
            }
        });

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", allList);
        ExcelExport.getInstance().export("maintarget-export.xlsx", beans, response);
    }

    /**
     * 导出页面数据处理children
     *
     * @param list
     */
    private List<ChangemaintargetdetailVO> handleList(List<ChangemaintargetdetailVO> list, List<ChangemaintargetdetailVO> concatList) {
        if (list == null || list.size() == 0) {
            return concatList;
        }

        for (int i = 0; i < list.size(); i++) {
            ChangemaintargetdetailVO maintargetdetailVO = list.get(i);
            List<ChangemaintargetdetailVO> children = maintargetdetailVO.getChildren();
            if (children != null && children.size() > 0) {
                concatList.addAll(children);
                handleList(children, concatList);
            }
        }

        return concatList;
    }
}
