package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.CompanyReviewEntity;
import com.ejianc.business.busniessplan.bean.CountersignatureEntity;
import com.ejianc.business.busniessplan.service.ICountersignatureService;
import com.ejianc.business.busniessplan.vo.CompanyReviewVO;
import com.ejianc.business.busniessplan.vo.CountersignatureVO;
import com.ejianc.business.change.bean.ChangecompanyreviewEntity;
import com.ejianc.business.change.bean.ChangecountersignatureEntity;
import com.ejianc.business.change.mapper.ChangecountersignatureMapper;
import com.ejianc.business.change.service.IChangecountersignatureService;
import com.ejianc.business.change.vo.ChangecountersignatureVO;
import com.ejianc.business.record.bean.RecordcompanyreviewEntity;
import com.ejianc.business.record.bean.RecordcountersignatureEntity;
import com.ejianc.business.record.service.IRecordcountersignatureService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;
import java.util.stream.Collectors;


/**
 * 商务会签变更
 * 
 * @author generator
 * 
 */
@Service("changecountersignatureService")
public class ChangecountersignatureServiceImpl extends BaseServiceImpl<ChangecountersignatureMapper, ChangecountersignatureEntity> implements IChangecountersignatureService {

    @Autowired
    private ICountersignatureService countersignatureService;
    @Autowired
    private IRecordcountersignatureService recordcountersignatureService;
    @Override
    public CommonResponse<ChangecountersignatureVO> saveChange(ChangecountersignatureVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangecountersignatureEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangecountersignatureEntity entity = BeanMapper.map(saveOrUpdateVO, ChangecountersignatureEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangecountersignatureEntity> queryWrapper = new QueryWrapper<ChangecountersignatureEntity>();
        queryWrapper.eq("countersignature_id", saveOrUpdateVO.getCountersignatureId());
        queryWrapper.eq("dr", 0);
        queryWrapper.notIn("bill_state", 1, 3);
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangecountersignatureEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangecountersignatureVO vo = BeanMapper.map(entity, ChangecountersignatureVO.class);
        vo.setRecordcountersignatureList(saveOrUpdateVO.getRecordcountersignatureList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            CountersignatureEntity countersignatureEntity = countersignatureService.selectById(vo.getCountersignatureId());
            countersignatureEntity.setChangeState("2");//状态改为变更中
            countersignatureEntity.setChangeId(vo.getId());
            countersignatureService.saveOrUpdate(countersignatureEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> deleteCounterSignature(List<CountersignatureVO> vos) {
        for(CountersignatureVO vo : vos){
            ChangecountersignatureEntity entity = this.getById(vo.getId());
            CountersignatureEntity countersignatureEntity = countersignatureService.selectById(entity.getCountersignatureId());
            QueryWrapper<RecordcountersignatureEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("countersignature_id", countersignatureEntity.getId());
            List<RecordcountersignatureEntity> records = recordcountersignatureService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                countersignatureEntity.setChangeState("3");//状态改为已变更
            }else{
                countersignatureEntity.setChangeState("1");//状态改为未变更
            }
            countersignatureEntity.setChangeId(null);
            countersignatureService.saveOrUpdate(countersignatureEntity, false);
        }
        this.removeByIds(vos.stream().map(CountersignatureVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
}
