package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.FundsplanningEntity;
import com.ejianc.business.busniessplan.service.IFundsplanningService;
import com.ejianc.business.busniessplan.vo.FundsplanningVO;
import com.ejianc.business.change.bean.ChangeFundsplanningEntity;
import com.ejianc.business.change.controller.ChangeFundsplanningController;
import com.ejianc.business.change.mapper.ChangeFundsplanningMapper;
import com.ejianc.business.change.service.IChangeFundsplanningService;
import com.ejianc.business.change.vo.ChangeFundsplanningVO;
import com.ejianc.business.change.vo.ChangePlanprojectVO;
import com.ejianc.business.record.bean.RecordFundsplanningEntity;
import com.ejianc.business.record.service.IRecordFundsplanningService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;
import java.util.stream.Collectors;


/**
 * 项目资金管理策划变更表
 * 
 * @author generator
 * 
 */
@Service("changeFundsplanningService")
public class ChangeFundsplanningServiceImpl extends BaseServiceImpl<ChangeFundsplanningMapper, ChangeFundsplanningEntity> implements IChangeFundsplanningService {
    @Autowired
    private IFundsplanningService fundsplanningService;
    @Autowired
    private IRecordFundsplanningService recordFundsplanningService;
    @Autowired
    private ChangeFundsplanningController changeFundsplanningController;
    @Override
    public CommonResponse<ChangeFundsplanningVO> saveChange(ChangeFundsplanningVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeFundsplanningEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangeFundsplanningEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeFundsplanningEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeFundsplanningEntity> queryWrapper = new QueryWrapper<ChangeFundsplanningEntity>();
        queryWrapper.eq("fundsplanning_id", saveOrUpdateVO.getFundsplanningId());
        queryWrapper.eq("dr", 0);
        queryWrapper.notIn("bill_state", 1, 3);
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeFundsplanningEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangeFundsplanningVO vo = BeanMapper.map(entity, ChangeFundsplanningVO.class);

        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            FundsplanningEntity fundsplanningEntity = fundsplanningService.selectById(vo.getFundsplanningId());
            fundsplanningEntity.setChangeState("2");//状态改为变更中
            fundsplanningEntity.setChangeId(vo.getId());
            fundsplanningService.saveOrUpdate(fundsplanningEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @Override
    public CommonResponse<String> delete(List<ChangeFundsplanningVO> vos) {
        for(ChangeFundsplanningVO vo : vos){
            ChangeFundsplanningEntity entity = this.getById(vo.getId());
            FundsplanningEntity fundsplanningEntity = fundsplanningService.selectById(entity.getFundsplanningId());
            QueryWrapper<RecordFundsplanningEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("fundsplanning_id", entity.getFundsplanningId());
            List<RecordFundsplanningEntity> records = recordFundsplanningService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                fundsplanningEntity.setChangeState("3");//状态改为已变更
            }else{
                fundsplanningEntity.setChangeState("1");//状态改为未变更
            }
            fundsplanningEntity.setChangeId(null);
            fundsplanningService.saveOrUpdate(fundsplanningEntity, false);
        }
        this.removeByIds(vos.stream().map(ChangeFundsplanningVO::getId).collect(Collectors.toList()),true);

        return CommonResponse.success("删除成功！");
    }
}
