package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.OrgstructureEntity;
import com.ejianc.business.busniessplan.bean.ProjoverviewEntity;
import com.ejianc.business.busniessplan.service.IProjoverviewService;
import com.ejianc.business.busniessplan.vo.OrgstructureVO;
import com.ejianc.business.busniessplan.vo.ProjectcontractVO;
import com.ejianc.business.busniessplan.vo.ProjectdetailVO;
import com.ejianc.business.busniessplan.vo.ProjoverviewVO;
import com.ejianc.business.change.bean.ChangeOrgstructureEntity;
import com.ejianc.business.change.bean.ChangeProjoverviewEntity;
import com.ejianc.business.change.mapper.ChangeProjoverviewMapper;
import com.ejianc.business.change.service.IChangeProjoverviewService;
import com.ejianc.business.change.vo.ChangeProjoverviewVO;
import com.ejianc.business.record.bean.RecordOrgstructureEntity;
import com.ejianc.business.record.bean.RecordProjoverviewEntity;
import com.ejianc.business.record.service.IRecordProjoverviewService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.util.List;
import java.util.stream.Collectors;


/**
 * 工程概述变更
 * 
 * @author generator
 * 
 */
@Service("changeProjoverviewService")
public class ChangeProjoverviewServiceImpl extends BaseServiceImpl<ChangeProjoverviewMapper, ChangeProjoverviewEntity> implements IChangeProjoverviewService {
    @Autowired
    private IProjoverviewService projoverviewService;
    @Autowired
    private IRecordProjoverviewService recordProjoverviewService;
    @Override
    public CommonResponse<ChangeProjoverviewVO> saveChange(ChangeProjoverviewVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeProjoverviewEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
         //处理合同额表格数据
        ChangeProjoverviewEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeProjoverviewEntity.class);
        if(saveOrUpdateVO.getProjectcontractList() != null && saveOrUpdateVO.getProjectcontractList().size() > 0){
            for( ProjectcontractVO projoverviewVO : saveOrUpdateVO.getProjectcontractList()){
                entity.setContractAmount(projoverviewVO.getContractAmount());
                entity.setSelfConstructionContractAmount(projoverviewVO.getSelfConstructionContractAmount());
                entity.setBelong(projoverviewVO.getBelong());
            }
        }
        //处理工程标价表格数据
        if(saveOrUpdateVO.getProjectdetailList() != null && saveOrUpdateVO.getProjectdetailList().size() > 0){
            for(ProjectdetailVO projectdetailVO : saveOrUpdateVO.getProjectdetailList()){
                entity.setProjectBidWinPrice(projectdetailVO.getProjectBidWinPrice());
                entity.setCivilEngineering(projectdetailVO.getCivilEngineering());
                entity.setFix(projectdetailVO.getFix());
                entity.setWaterSupplyDrainage(projectdetailVO.getWaterSupplyDrainage());
                entity.setStrongCurrent(projectdetailVO.getStrongCurrent());
                entity.setHeateVentilation(projectdetailVO.getHeateVentilation());
                entity.setFixOther(projectdetailVO.getFixOther());
                entity.setDecorate(projectdetailVO.getDecorate());
                entity.setOther(projectdetailVO.getOther());
            }
        }
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeProjoverviewEntity> queryWrapper = new QueryWrapper<ChangeProjoverviewEntity>();
        queryWrapper.eq("original_id", saveOrUpdateVO.getOriginalId());
        queryWrapper.eq("dr", 0);
        queryWrapper.notIn("bill_state", 1, 3);
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeProjoverviewEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //处理子表数据
        //限额设计指标分析子表
        this.saveOrUpdate(entity, false);

        ChangeProjoverviewVO vo = BeanMapper.map(entity, ChangeProjoverviewVO.class);
        vo.setProjectdetailList(saveOrUpdateVO.getProjectdetailList());
        vo.setProjectcontractList(saveOrUpdateVO.getProjectcontractList());
        vo.setRecordProjoverviewList(saveOrUpdateVO.getRecordProjoverviewList());
        if(!exitBill){
            //查询当前合同信息，将状态改为变更中
            ProjoverviewEntity projoverviewEntity = projoverviewService.selectById(vo.getOriginalId());
            projoverviewEntity.setChangeState("2");//状态改为变更中
            projoverviewEntity.setChangeId(vo.getId());
            projoverviewService.saveOrUpdate(projoverviewEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> deleteProjoverview(List<ProjoverviewVO> vos) {
        for(ProjoverviewVO vo : vos){
            ChangeProjoverviewEntity entity = this.getById(vo.getId());
            ProjoverviewEntity projoverviewEntity= projoverviewService.selectById(entity.getOriginalId());
            QueryWrapper<RecordProjoverviewEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("original_id", projoverviewEntity.getId());
            List<RecordProjoverviewEntity> records = recordProjoverviewService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                projoverviewEntity.setChangeState("3");//状态改为已变更
            }else{
                projoverviewEntity.setChangeState("1");//状态改为未变更
            }
            projoverviewEntity.setChangeId(null);
            projoverviewService.saveOrUpdate(projoverviewEntity, false);
        }
        this.removeByIds(vos.stream().map(ProjoverviewVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
}
