package com.ejianc.business.busniessplan.excel;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.PlanprojectdetailEntity;
import com.ejianc.business.busniessplan.service.IPlanprojectdetailService;
import com.ejianc.business.busniessplan.vo.PlanprojectVO;
import com.ejianc.business.busniessplan.vo.PlanprojectdetailVO;
import com.ejianc.business.utils.DateUtils;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.*;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

/**
 * 项目商务策划立项导入导出
 */
@Controller
@RequestMapping("planprojectExport")
public class ExcelPlanprojectController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPlanprojectdetailService planprojectdetailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadPlanproject")
    @ResponseBody
    public void downloadTotalPrice(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "planproject-import.xlsx", "项目商务策划立项清单导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportPlanproject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportTotalPric(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PlanprojectdetailVO> successList = new ArrayList<>();
        List<PlanprojectdetailVO> errorList = new ArrayList<>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                List<String> planTypeList = new ArrayList<>();
                planTypeList.add("1.1 合同条件优化");
                planTypeList.add("1.2 签证索赔");
                planTypeList.add("1.3 设计优化、设计变更");
                planTypeList.add("1.4 总包管理策划");
                planTypeList.add("1.5 认质认价与采购效益");
                planTypeList.add("1.6 其他");
                planTypeList.add("2.1 设计优化、设计变更");
                planTypeList.add("2.2 施工组织及方案优化");
                planTypeList.add("2.3 钢筋翻样、钢筋管控量差");
                planTypeList.add("2.4 其他");

                List<String> planStatusList = new ArrayList<>();
                planStatusList.add("计划");
                planStatusList.add("实施中");
                planStatusList.add("已完成");
                List<String> planCategoryList = new ArrayList<>();
                planCategoryList.add("开源");
                planCategoryList.add("节流");

                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PlanprojectdetailVO planprojectdetailVO = new PlanprojectdetailVO();
                    planprojectdetailVO.setId(IdWorker.getId());//id
//                    String sort = datas.get(0);

                    //planprojectdetailVO.setInitiateReason(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 立项理由及依据
                    planprojectdetailVO.setPlanType(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 策划类型
                    planprojectdetailVO.setPlanContent(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); //策划内容
                    planprojectdetailVO.setTargetAmount(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null); // 策划目标（万元）
                    planprojectdetailVO.setTakenMeasures(StringUtils.isNotBlank(datas.get(6)) ? datas.get(6) : null); // 拟采取的措施
                    planprojectdetailVO.setPersonLiable(StringUtils.isNotBlank(datas.get(7)) ? datas.get(7) : null); // 责任人
                    String arr = datas.get(8);

                    if (DateUtils.grepDate(arr)) {
                        planprojectdetailVO.setProposedImplementationTime(StringUtils.isNotBlank(datas.get(8)) ? DateUtils.Date(datas.get(8)) : null); // 拟实施时间
                    } else {
                        planprojectdetailVO.setErrorMsg("日期格式不正确");
                        errorList.add(planprojectdetailVO);
                        continue;
                    }

//                   if(sort==null || sort == ""){
//                       planprojectdetailVO.setErrorMsg("序号不能为空");
//                        errorList.add(planprojectdetailVO);
//                        continue;
//                    }else{
//                       planprojectdetailVO.setSort(datas.get(0));
//                   }
                    if(datas.get(0) == null || StringUtils.isBlank(datas.get(0))){
                        planprojectdetailVO.setErrorMsg("策划专项名称不能为空");
                        errorList.add(planprojectdetailVO);
                        continue;
                    }else{
                        planprojectdetailVO.setCategoryAndName(datas.get(0));
                    }

                    planprojectdetailVO.setPlanCategory(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 策划类别
                    if(StringUtils.isBlank(datas.get(1))){
                        planprojectdetailVO.setPlanStatus(null);
                    }else{
                        String planStatus = datas.get(1);
                        if (planCategoryList.contains(planStatus)){
                            planprojectdetailVO.setPlanStatus(datas.get(1));
                        }else{
                            planprojectdetailVO.setErrorMsg("策划类别不对,只能是 开源,节流");
                            errorList.add(planprojectdetailVO);
                            continue;
                        }
                    }

                    planprojectdetailVO.setPlanType(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 策划类型
                    if(StringUtils.isBlank(datas.get(2))){
                        planprojectdetailVO.setPlanType(null);
                    }else{
                        String planType = datas.get(2);
                        if (planTypeList.contains(planType)){
                            planprojectdetailVO.setPlanType(datas.get(2));
                        }else{
                            planprojectdetailVO.setErrorMsg("策划类型有误");
                            errorList.add(planprojectdetailVO);
                            continue;
                        }
                    }

                    if(StringUtils.isBlank(datas.get(4))){
                        planprojectdetailVO.setPlanStatus(null);
                    }else{
                        String planStatus = datas.get(4);
                        if (planStatusList.contains(planStatus)){
                            planprojectdetailVO.setPlanStatus(datas.get(4));
                        }else{
                            planprojectdetailVO.setErrorMsg("策划状态只能是 :'计划,实施中,已完成!'");
                            errorList.add(planprojectdetailVO);
                            continue;
                        }
                    }

                    successList.add(planprojectdetailVO);
                }
            }
        }

        //设置tid和tpid
//        List<PlanprojectdetailVO> resList = setTidAndTpid(successList);
        List<PlanprojectdetailVO> resList = successList;

        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", resList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());

        PlanprojectVO resVo = new PlanprojectVO();
        json.put("total", getTotalAmount(resList, resVo));

        return CommonResponse.success(json);
    }

    private PlanprojectVO getTotalAmount(List<PlanprojectdetailVO> vos, PlanprojectVO resVo) {
        BigDecimal costEstimateTotal = new BigDecimal(0);
        BigDecimal reportAmountTotal = new BigDecimal(0);
        BigDecimal targetAmountTotal = new BigDecimal(0);
        BigDecimal completeAmountTotal = new BigDecimal(0);
        BigDecimal estimateProfitsTotal = new BigDecimal(0);

        for (PlanprojectdetailVO vo : vos) {
            if (vo.getCostEstimate() != null) {
                costEstimateTotal = costEstimateTotal.add(vo.getCostEstimate());
            }
            if (vo.getReportAmount() != null) {
                reportAmountTotal = reportAmountTotal.add(vo.getReportAmount());
            }
            if (vo.getTargetAmount() != null) {
                targetAmountTotal = targetAmountTotal.add(vo.getTargetAmount());
            }
            if (vo.getCompleteAmount() != null) {
                completeAmountTotal = completeAmountTotal.add(vo.getCompleteAmount());
            }
            if (vo.getEstimateProfits() != null) {
                estimateProfitsTotal = estimateProfitsTotal.add(vo.getEstimateProfits());
            }
        }

        resVo.setCostEstimateTotal(costEstimateTotal);
        resVo.setReportAmountTotal(reportAmountTotal);
        resVo.setTargetAmountTotal(targetAmountTotal);
        resVo.setCompleteAmountTotal(completeAmountTotal);
        resVo.setEstimateProfitsTotal(estimateProfitsTotal);
        return resVo;
    }

    /**
     * 设置tid和tpid
     * @param originalList
     * @return
     */
//    private List<PlanprojectdetailVO> setTidAndTpid(List<PlanprojectdetailVO> originalList) {
//        List<PlanprojectdetailVO> treeList = new ArrayList<>();
//        String currentTime = String.valueOf(System.currentTimeMillis());
//        if (originalList != null && originalList.size() > 0) {
//            for (int i = 0; i < originalList.size(); i++) {
//                PlanprojectdetailVO planprojectdetailVO = originalList.get(i);
//                String sort = planprojectdetailVO.getSort();
//                if(sort==null || sort == ""){
//                    continue;
//                }
//                String[] arr = sort.split("\\.");
//
//                if (arr.length == 1) {
//                    planprojectdetailVO.setTid(currentTime + "_" + sort);
//                    planprojectdetailVO.setTpid("");
//                    treeList.add(planprojectdetailVO);
//                } else if (arr.length > 1) {
//                    planprojectdetailVO.setTid(currentTime + "_" + sort);
//                    planprojectdetailVO.setTpid(currentTime + "_" + sort.substring(0, sort.length() - 2));
//                    treeList.add(planprojectdetailVO);
//                }
//            }
//        }
//        return createTreeData(treeList);
//    }

    /**
     * 构建树
     * @param list
     * @return
     */
    public static List<PlanprojectdetailVO> createTreeData(List<PlanprojectdetailVO> list) {
        List<PlanprojectdetailVO> resp = new ArrayList<>();
        List<String> rootItems = new ArrayList<String>();

        //循环list，放入listMap重
        Map<String, PlanprojectdetailVO> listMap = new HashMap<>();
        for (PlanprojectdetailVO item : list) {
            listMap.put(item.getTid().toString(), item);
        }

        for (int i = 0; i < list.size(); i++) {
            PlanprojectdetailVO item = list.get(i);
            String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
            PlanprojectdetailVO parent = listMap.get(parentId);
            if (parent != null) {
                List<PlanprojectdetailVO> child = (List<PlanprojectdetailVO>) parent.getChildren();
                if (child != null) {
                    child.add(item);
                } else {
                    List<PlanprojectdetailVO> children = new ArrayList<PlanprojectdetailVO>();
                    children.add(item);
                    parent.setChildren(children);
                }
            } else {
                rootItems.add(item.getTid());
            }
        }

        for (String rootId : rootItems) {
            resp.add(listMap.get(rootId));
        }

        return resp;
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportPlanprojectFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromDatabase(@RequestBody PlanprojectVO planprojectVO, HttpServletResponse response) {
        QueryWrapper<PlanprojectdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", planprojectVO.getId());
        queryWrapper.eq("dr", 0);
        List<PlanprojectdetailEntity> list = planprojectdetailService.list(queryWrapper);
        List<PlanprojectdetailVO> resList = BeanMapper.mapList(list, PlanprojectdetailVO.class);

        //构建树
        resList = createTreeData(resList);

        List<PlanprojectdetailVO> records = new ArrayList<>();
        for(PlanprojectdetailVO vo : resList){
            records.add(vo);
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                this.splitList(vo.getChildren(),records);
            }
        }

        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", handleSpecialField(records));
        ExcelExport.getInstance().export("planproject-export.xlsx", beans, response);
    }

    /**
     * 处理特殊字段 如：日期
     *
     * @param resList
     * @return
     */
    private List<PlanprojectdetailVO> handleSpecialField(List<PlanprojectdetailVO> resList) {
        //处理日期字段
        for (int i = 0; i < resList.size(); i++) {
            PlanprojectdetailVO planprojectdetailVO = resList.get(i);
            if (planprojectdetailVO.getCompleteTime() != null) {
                planprojectdetailVO.setCompleteTimeShow(DateUtils.dateSimple(planprojectdetailVO.getCompleteTime()));
            }
            if (planprojectdetailVO.getInitiateDate() != null) {
                planprojectdetailVO.setInitiateDateShow(DateUtils.dateSimple(planprojectdetailVO.getInitiateDate()));
            }
            if (planprojectdetailVO.getProposedCompleteTime() != null) {
                planprojectdetailVO.setProposedCompleteTimeShow(DateUtils.dateSimple(planprojectdetailVO.getProposedCompleteTime()));
            }
            if (planprojectdetailVO.getFinalCompleteTime() != null) {
                planprojectdetailVO.setFinalCompleteTimeShow(DateUtils.dateSimple(planprojectdetailVO.getFinalCompleteTime()));
            }
            if (planprojectdetailVO.getProposedImplementationTime() != null) {
                planprojectdetailVO.setProposedImplementationTimeShow(DateUtils.dateSimple(planprojectdetailVO.getProposedImplementationTime()));
            }
        }

        return resList;
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportPlanprojectFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportbusinessplanningeffectFromPage(@RequestBody List<PlanprojectdetailVO> list, HttpServletResponse response) {
        Map<String, Object> beans = new HashMap<String, Object>();
        List<PlanprojectdetailVO> records = new ArrayList<>();

        for(PlanprojectdetailVO vo : list){
            records.add(vo);
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                this.splitList(vo.getChildren(),records);
            }
        }

        beans.put("records", handleSpecialField(records));
        ExcelExport.getInstance().export("planproject-export.xlsx", beans, response);
    }

    /**
     * 导出遍历加上所有子表
     * @param list
     * @param records
     */
    private void splitList(List<PlanprojectdetailVO> list,List<PlanprojectdetailVO> records) {
        for(PlanprojectdetailVO vo : list){
            records.add(vo);
            if(vo.getChildren()!=null&&vo.getChildren().size()>0){
                this.splitList(vo.getChildren(),records);
            }
        }
    }
}
