package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.busniessplan.bean.SubpackageEntity;
import com.ejianc.business.busniessplan.bean.SubpackagepackgedetailEntity;
import com.ejianc.business.busniessplan.bean.SubpackagesupplydetailEntity;
import com.ejianc.business.busniessplan.service.ISubpackageService;
import com.ejianc.business.change.bean.ChangesubpackageEntity;
import com.ejianc.business.change.bean.ChangesubpackagedetaillEntity;
import com.ejianc.business.change.bean.ChangesubpackagesupplydetailEntity;
import com.ejianc.business.change.service.IChangesubpackageService;
import com.ejianc.business.record.bean.RecordsubpackageEntity;
import com.ejianc.business.record.bean.RecordsubpackagepackagedetailEntity;
import com.ejianc.business.record.bean.RecordsubpackagesupplydetailEntity;
import com.ejianc.business.record.service.IRecordsubpackageService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("changesubpackage") 
public class ChangesubpackageBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	//业务类型
	private static final String Subpackage = "zjkj-subpackage";//分包分供管理策划
	private static final String Subpackage_CHANGE = "zjkj-subpackageChange";//分包分供管理策划分析变更
	private static final String Subpackage_RECORD = "zjkj-subpackageRecord";//分包分供管理策划变更记录

	//单据类型
	private static final String Subpackage_BILLTYPE_CODE = "BT202202000017";//分包分供管理策划
	private static final String Subpackage_CHANGE_BILLTYPE_CODE = "BT202202000066";//分包分供管理策划变更
	private static final String Subpackage_RECORD_BILLTYPE_CODE = "BT202202000067";//分包分供管理策划变更记录

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private IChangesubpackageService changesubpackageService;
	@Autowired
	private ISubpackageService subpackageService;
	@Autowired
	private IRecordsubpackageService recordsubpackageService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前单据信息、变更信息
		ChangesubpackageEntity changeEntity = changesubpackageService.selectById(billId);
		logger.info("变更单主表id=" + changeEntity.getSubpackageId());
		SubpackageEntity subpackageEntity = subpackageService.selectById(changeEntity.getSubpackageId());
		logger.info("主单据id=" + changeEntity.getId() + "主单据创建人" + changeEntity.getCreateUserCode());

		//获取历史版本条数
		QueryWrapper<RecordsubpackageEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("subpackage_id", subpackageEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordsubpackageService.count(recordWrapper);

		logger.info("---------给变更记录表赋值--------");
		RecordsubpackageEntity recordsubpackageEntity = BeanMapper.map(subpackageEntity, RecordsubpackageEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordsubpackageEntity);
		recordsubpackageEntity.setBillState(null);
		recordsubpackageEntity.setSubpackageId(subpackageEntity.getId());
		recordsubpackageEntity.setSubpackageCode(subpackageEntity.getBillCode()+"-"+(count+1));
		recordsubpackageEntity.setId(recordId);
		recordsubpackageEntity.setBillCode(subpackageEntity.getBillCode());
		recordsubpackageEntity.setChangeReason(changeEntity.getChangeReason());
		recordsubpackageEntity.setEffectTime(new Date());

		logger.info("---------给变更记录子表赋值--------");
		List<SubpackagepackgedetailEntity> subpackagepackgedetailEntities = subpackageEntity.getSubpackagepackagedetailEntities();
		if(subpackagepackgedetailEntities!=null&&subpackagepackgedetailEntities.size()>0){
			List<RecordsubpackagepackagedetailEntity> recordsubpackagepackgedetailEntities = new ArrayList<>();
			for(SubpackagepackgedetailEntity entity : subpackagepackgedetailEntities){
				RecordsubpackagepackagedetailEntity reEntity = BeanMapper.map(entity, RecordsubpackagepackagedetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setMid(recordId);
				recordsubpackagepackgedetailEntities.add(reEntity);
				entity.setRowState("del");
			}
			recordsubpackageEntity.setSubpackagepackgedetailEntities(recordsubpackagepackgedetailEntities);
		}

		List<SubpackagesupplydetailEntity> subpackagesupplydetailEntities = subpackageEntity.getSubpackagesupplydetailEntities();
		if(subpackagesupplydetailEntities!=null&&subpackagesupplydetailEntities.size()>0){
			List<RecordsubpackagesupplydetailEntity> recordsubpackagesupplydetailEntities = new ArrayList<>();
			for(SubpackagesupplydetailEntity entity : subpackagesupplydetailEntities){
				RecordsubpackagesupplydetailEntity reEntity = BeanMapper.map(entity, RecordsubpackagesupplydetailEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setMid(recordId);
				recordsubpackagesupplydetailEntities.add(reEntity);
				entity.setRowState("del");
			}
			recordsubpackageEntity.setSubpackagesupplydetailEntities(recordsubpackagesupplydetailEntities);
		}


		logger.info("---------赋值附件信息--------");
		//复制附件信息到记录中
		String sourceBillType = "";
		//原单据类型
		sourceBillType = Subpackage_BILLTYPE_CODE;
		String targetBillType = "";
		//变更记录单剧类型
		targetBillType = Subpackage_RECORD_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(subpackageEntity.getId().toString(), sourceBillType, Subpackage , recordId.toString(), targetBillType, Subpackage_RECORD);
		recordsubpackageService.saveOrUpdate(recordsubpackageEntity, false);

		logger.info("---------修改当前单据状态--------");
		logger.info("创建人=" + subpackageEntity.getCreateUserCode());
		//3、修改当前单据状态
		SubpackageEntity newSubpackageEntity = BeanMapper.map(changeEntity, SubpackageEntity.class);
		newSubpackageEntity.setChangeState("3");//状态改为已变更
		newSubpackageEntity.setChangeId(null);
		newSubpackageEntity.setBillState(subpackageEntity.getBillState());
		newSubpackageEntity.setId(subpackageEntity.getId());
		newSubpackageEntity.setCreateTime(subpackageEntity.getCreateTime());
		newSubpackageEntity.setCreateUserCode(subpackageEntity.getCreateUserCode());
		newSubpackageEntity.setTenantId(subpackageEntity.getTenantId());
		newSubpackageEntity.setVersion(subpackageEntity.getVersion());

		logger.info("---------处理子表变更--------");
		//子表
		//处理子表变更
		List<ChangesubpackagedetaillEntity> changesubpackagedetaillList = changeEntity.getSubpackagepackagedetailEntities();
		if(changesubpackagedetaillList!=null&&changesubpackagedetaillList.size()>0){
			List<SubpackagepackgedetailEntity> newSubpackagepackgedetailList = BeanMapper.mapList(changesubpackagedetaillList, SubpackagepackgedetailEntity.class);
			newSubpackagepackgedetailList.addAll(subpackagepackgedetailEntities);
			newSubpackageEntity.setSubpackagepackagedetailEntities(newSubpackagepackgedetailList);
		}

		List<ChangesubpackagesupplydetailEntity> changesubpackagesupplydetailList = changeEntity.getSubpackagesupplydetailEntities();
		if(changesubpackagesupplydetailList!=null&&changesubpackagesupplydetailList.size()>0){
			List<SubpackagesupplydetailEntity> newSubpackagesupplydetailList = BeanMapper.mapList(changesubpackagesupplydetailList, SubpackagesupplydetailEntity.class);
			newSubpackagesupplydetailList.addAll(subpackagesupplydetailEntities);
			newSubpackageEntity.setSubpackagesupplydetailEntities(newSubpackagesupplydetailList);
		}
		logger.info("---------保存--------");
		subpackageService.saveOrUpdate(newSubpackageEntity, false);

		sourceBillType = Subpackage_CHANGE_BILLTYPE_CODE;
		targetBillType = Subpackage_BILLTYPE_CODE;

		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, Subpackage_CHANGE, subpackageEntity.getId().toString(), targetBillType, Subpackage);
		recordsubpackageService.saveOrUpdate(recordsubpackageEntity, false);

		logger.info("---------结束--------");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
		entity.setCreateTime(null);
		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

}
