/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pub.tax;

import com.ejianc.business.pub.tax.ITaxCalculate;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxCalculateUtil<T> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public void calculate(Collection<T> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (T t : list) {
                if (!(t instanceof ITaxCalculate)) {
                    this.logger.info(t.getClass().toString() + "\u6ca1\u6709\u5b9e\u73b0ITaxCalculate\u63a5\u53e3");
                    return;
                }
                ITaxCalculate iTaxCalculate = (ITaxCalculate)t;
                String[] calculateTypeArray = iTaxCalculate.getCalculateType();
                String[] priceArray = iTaxCalculate.getPriceArray();
                String[] taxPriceArray = iTaxCalculate.getTaxPriceArray();
                String[] numArray = iTaxCalculate.getNumArray();
                String[] moneyArray = iTaxCalculate.getMoneyArray();
                String[] taxMoneyArray = iTaxCalculate.getTaxMoneyArray();
                String[] taxRateArray = iTaxCalculate.getTaxRateArray();
                String[] taxArray = iTaxCalculate.getTaxArray();
                if (null == priceArray || priceArray.length <= 0 || null == taxPriceArray || taxPriceArray.length <= 0 || null == numArray || numArray.length <= 0 || null == moneyArray || moneyArray.length <= 0 || null == taxMoneyArray || taxMoneyArray.length <= 0 || null == taxRateArray || taxRateArray.length <= 0 || null == taxArray || taxArray.length <= 0) {
                    throw new BusinessException("\u7c7b\u3010" + t.getClass() + "\u3011\u7684\u6240\u6709\u5b57\u6bb5\u6570\u7ec4\u90fd\u5fc5\u987b\u6709\u503c");
                }
                int length = priceArray.length;
                if (taxPriceArray.length != length || numArray.length != length || moneyArray.length != length || taxMoneyArray.length != length || taxRateArray.length != length || taxArray.length != length) {
                    throw new BusinessException("\u7c7b\u3010" + t.getClass() + "\u3011\u7684\u6240\u6709\u5b57\u6bb5\u6570\u7ec4\u957f\u5ea6\u5fc5\u987b\u4e00\u81f4");
                }
                block7: for (int i = 0; i < priceArray.length; ++i) {
                    String calculateType;
                    switch (calculateType = null == calculateTypeArray || calculateTypeArray.length < i + 1 ? iTaxCalculate.getDefaultType() : calculateTypeArray[i]) {
                        case "ALL": {
                            this.allCalculate(iTaxCalculate, t, i);
                            continue block7;
                        }
                    }
                }
            }
        }
    }

    private void allCalculate(ITaxCalculate iTaxCalculate, T t, int i) {
        String[] priceArray = iTaxCalculate.getPriceArray();
        String[] taxPriceArray = iTaxCalculate.getTaxPriceArray();
        String[] numArray = iTaxCalculate.getNumArray();
        String[] moneyArray = iTaxCalculate.getMoneyArray();
        String[] taxMoneyArray = iTaxCalculate.getTaxMoneyArray();
        String[] taxRateArray = iTaxCalculate.getTaxRateArray();
        String[] taxArray = iTaxCalculate.getTaxArray();
        if (StringUtils.isBlank((CharSequence)priceArray[i])) {
            throw new BusinessException("\u7c7b\u3010" + t.getClass() + "\u3011\u7684\u3010priceArray\u3011\u7684\u7b2c" + (i + 1) + "\u4e2a\u503c\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)taxPriceArray[i])) {
            throw new BusinessException("\u7c7b\u3010" + t.getClass() + "\u3011\u7684\u3010taxPriceArray\u3011\u7684\u7b2c" + (i + 1) + "\u4e2a\u503c\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)numArray[i])) {
            throw new BusinessException("\u7c7b\u3010" + t.getClass() + "\u3011\u7684\u3010numArray\u3011\u7684\u7b2c" + (i + 1) + "\u4e2a\u503c\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)moneyArray[i])) {
            throw new BusinessException("\u7c7b\u3010" + t.getClass() + "\u3011\u7684\u3010moneyArray\u3011\u7684\u7b2c" + (i + 1) + "\u4e2a\u503c\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)taxMoneyArray[i])) {
            throw new BusinessException("\u7c7b\u3010" + t.getClass() + "\u3011\u7684\u3010taxMoneyArray\u3011\u7684\u7b2c" + (i + 1) + "\u4e2a\u503c\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)taxRateArray[i])) {
            throw new BusinessException("\u7c7b\u3010" + t.getClass() + "\u3011\u7684\u3010taxRateArray\u3011\u7684\u7b2c" + (i + 1) + "\u4e2a\u503c\u4e3a\u7a7a\uff01");
        }
        BigDecimal price = this.getValue(t, priceArray[i]);
        BigDecimal taxPrice = this.getValue(t, taxPriceArray[i]);
        BigDecimal num = this.getValue(t, numArray[i]);
        BigDecimal taxRate = this.getValue(t, taxRateArray[i]);
        if (null != price) {
            taxPrice = ComputeUtil.safeMultiply((BigDecimal)price, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)BigDecimal.ONE, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)taxRate, (BigDecimal)new BigDecimal(100))));
            this.setValue(t, taxPriceArray[i], taxPrice);
            BigDecimal money = ComputeUtil.safeMultiply((BigDecimal)price, (BigDecimal)num);
            this.setValue(t, moneyArray[i], money);
            BigDecimal taxMoney = ComputeUtil.safeMultiply((BigDecimal)taxPrice, (BigDecimal)num);
            this.setValue(t, taxMoneyArray[i], taxMoney);
            BigDecimal tax = ComputeUtil.safeMultiply((BigDecimal)money, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)taxRate, (BigDecimal)new BigDecimal(100)));
            if (StringUtils.isNotBlank((CharSequence)taxArray[i])) {
                this.setValue(t, taxArray[i], tax);
            }
        } else if (null != taxPrice) {
            price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)BigDecimal.ONE, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)taxRate, (BigDecimal)new BigDecimal(100))));
            this.setValue(t, priceArray[i], price);
            BigDecimal money = ComputeUtil.safeMultiply((BigDecimal)price, (BigDecimal)num);
            this.setValue(t, moneyArray[i], money);
            BigDecimal taxMoney = ComputeUtil.safeMultiply((BigDecimal)taxPrice, (BigDecimal)num);
            this.setValue(t, taxMoneyArray[i], taxMoney);
            BigDecimal tax = ComputeUtil.safeMultiply((BigDecimal)money, (BigDecimal)ComputeUtil.safeDiv((BigDecimal)taxRate, (BigDecimal)new BigDecimal(100)));
            if (StringUtils.isNotBlank((CharSequence)taxArray[i])) {
                this.setValue(t, taxArray[i], tax);
            }
        }
    }

    private BigDecimal getValue(T t, String code) {
        Class<?> mainClass = t.getClass();
        try {
            Method m = mainClass.getDeclaredMethod("get" + code.substring(0, 1).toUpperCase() + code.substring(1), null);
            try {
                return (BigDecimal)m.invoke(t, (Object[])null);
            }
            catch (IllegalAccessException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684get\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
            }
            catch (InvocationTargetException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (NoSuchMethodException e) {
            throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u672a\u8bbe\u7f6eget\u65b9\u6cd5\uff01");
        }
    }

    private void setValue(T t, String code, BigDecimal value) {
        Class<?> mainClass = t.getClass();
        try {
            Method subPid = mainClass.getDeclaredMethod("set" + code.substring(0, 1).toUpperCase() + code.substring(1), BigDecimal.class);
            try {
                subPid.invoke(t, value);
            }
            catch (IllegalAccessException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684set\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
            }
            catch (InvocationTargetException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684set\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (NoSuchMethodException e) {
            throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u672a\u8bbe\u7f6eset\u65b9\u6cd5\uff01");
        }
    }
}

