package com.ejianc.business.car.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.car.vo.MaintainLabourVO;
import com.ejianc.business.car.vo.MaintainMaterialVO;
import com.ejianc.business.car.vo.DispatchVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 车辆维修
 * 
 * @author generator
 * 
 */
public class MaintainVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long carId; // 车牌号id
    private String carName; // 车辆名称 设备名称
    private String carCode; // 车牌号
    private Long carAreaId; // 车辆所在区域
    private String carAreaName; // 车辆所在区域
    private Long carProjectId; // 所属项目 车辆所在项目
    private String carProjectName; // 所属项目 车辆所在项目
    private Long orgId; // 所属组织
    private String orgName; // 所属组织
    private Long carOrgId; // 所属公司 单据所属组织 
    private String carOrgName; // 所属公司 单据所属组织
    private BigDecimal maintainTaxMny; // 维修总金额
    private BigDecimal maintainMny; // 维修总金额(无税)
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date maintainDate; // 维修日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门
    private String memo; // 备注
    private String billCode; // 单据编号

    private List<MaintainLabourVO> labourList = new ArrayList<>(); // 车辆维修-人工费
    private List<MaintainMaterialVO> materialList = new ArrayList<>(); // 车辆维修-材料费
    private Integer billState; // 单据状态
    private String billStateName;

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "car-info")
    public Long getCarId() {
        return carId;
    }
    @ReferDeserialTransfer
    public void setCarId(Long carId) {
        this.carId = carId;
    }
    public String getCarName() {
        return carName;
    }

    public void setCarName(String carName) {
        this.carName = carName;
    }
    public String getCarCode() {
        return carCode;
    }

    public void setCarCode(String carCode) {
        this.carCode = carCode;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCarAreaId() {
        return carAreaId;
    }

    @ReferDeserialTransfer
    public void setCarAreaId(Long carAreaId) {
        this.carAreaId = carAreaId;
    }
    public String getCarAreaName() {
        return carAreaName;
    }

    public void setCarAreaName(String carAreaName) {
        this.carAreaName = carAreaName;
    }
    @ReferSerialTransfer(referCode = "market-project")
    public Long getCarProjectId() {
        return carProjectId;
    }
    @ReferDeserialTransfer
    public void setCarProjectId(Long carProjectId) {
        this.carProjectId = carProjectId;
    }
    public String getCarProjectName() {
        return carProjectName;
    }

    public void setCarProjectName(String carProjectName) {
        this.carProjectName = carProjectName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getCarOrgId() {
        return carOrgId;
    }
    @ReferDeserialTransfer
    public void setCarOrgId(Long carOrgId) {
        this.carOrgId = carOrgId;
    }
    public String getCarOrgName() {
        return carOrgName;
    }

    public void setCarOrgName(String carOrgName) {
        this.carOrgName = carOrgName;
    }
    public BigDecimal getMaintainTaxMny() {
        return maintainTaxMny;
    }

    public void setMaintainTaxMny(BigDecimal maintainTaxMny) {
        this.maintainTaxMny = maintainTaxMny;
    }
    public BigDecimal getMaintainMny() {
        return maintainMny;
    }

    public void setMaintainMny(BigDecimal maintainMny) {
        this.maintainMny = maintainMny;
    }
    public Date getMaintainDate() {
        return maintainDate;
    }

    public void setMaintainDate(Date maintainDate) {
        this.maintainDate = maintainDate;
    }
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getOrgName() {
        return orgName;
    }

    public List<MaintainLabourVO> getLabourList() {
        return labourList;
    }

    public void setLabourList(List<MaintainLabourVO> labourList) {
        this.labourList = labourList;
    }

    public List<MaintainMaterialVO> getMaterialList() {
        return materialList;
    }

    public void setMaterialList(List<MaintainMaterialVO> materialList) {
        this.materialList = materialList;
    }
}
