package com.ejianc.business.car.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.car.vo.WageUserDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 组织人员登记
 * 
 * @author generator
 * 
 */
public class WageUserVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long employeeId; // 经办人
    private String employeeName; // 经办人
    private String departmentName; // 经办部门
    private Integer totalPeopleNum; // 总人数
    private String memo; // 备注
    private Long orgId; // 单据组织id
    private String orgName; // 单据组织名称
    private Integer billState; // 单据状态
    private String billCode; // 单据编号
    private String billStateName;
    private String team; // 班组
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd",
            timezone = "GMT+8"
    )
    private Date billDate; // 制单日期
    private List<WageUserDetailVO> wageUserDetailList = new ArrayList<>(); // 组织人员登记-人员明细

    @ReferSerialTransfer(referCode = "idm-user")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Integer getTotalPeopleNum() {
        return totalPeopleNum;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public void setTotalPeopleNum(Integer totalPeopleNum) {
        this.totalPeopleNum = totalPeopleNum;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public String getTeam() {
        return team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
     public List<WageUserDetailVO> getWageUserDetailList() {
        return wageUserDetailList;
     }

     public void setWageUserDetailList(List<WageUserDetailVO> wageUserDetailList) {
        this.wageUserDetailList = wageUserDetailList;
     }
}
