package com.ejianc.foundation.cfs.api;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.ejianc.foundation.cfs.hystrix.CustomTableHystrix;
import com.ejianc.framework.core.response.CommonResponse;


@FeignClient(name= "ejc-cfs-web", url="${common.env.feign-client-url}", path="ejc-cfs-web", fallback = CustomTableHystrix.class)
public interface ICustomTableApi {

    @GetMapping(value = "/no_auth/api/customtable/parse")
    public CommonResponse<String> parse(@RequestParam(value="userId") Long userId,
    									@RequestParam(value="token") String token, 
							    		@RequestParam(value="appCode") String appCode, 
							    		@RequestParam(value = "pageMeta") String pageMeta);

}
