/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.foundation.cfs.vo.CustomColumnVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"custom/column"})
public class CustomColumnController
implements Serializable {
    private static final long serialVersionUID = -2549939173725536626L;
    @Autowired
    private ICustomColumnService customColumnService;
    @Autowired
    private ICustomTableService customTableService;

    @RequestMapping(value={"queryRefList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CustomColumnVO>> queryRefList(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition, @RequestParam(required=false) String searchObject) {
        JSONObject json;
        Page pageData = new Page((long)pageNumber, (long)pageSize, 0L);
        Long appId = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            json = JSONObject.parseObject((String)condition);
            if (json.get((Object)"appId") == null) {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11appId\uff01");
            }
        } else {
            return CommonResponse.error((String)"\u7f3a\u5c11condition\u6761\u4ef6");
        }
        appId = Long.parseLong(json.get((Object)"appId").toString());
        QueryParam param = new QueryParam();
        if (StringUtils.isNotBlank((CharSequence)searchObject)) {
            JSONObject search = JSONObject.parseObject((String)searchObject);
            for (String key : search.keySet()) {
                param.getParams().put(key, new Parameter("like", (Object)search.get((Object)key).toString()));
            }
        }
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        if (StringUtils.isNotBlank((CharSequence)searchText)) {
            param.setSearchText(searchText);
            List fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("columnName");
            fuzzyFields.add("property");
        }
        HashMap<String, Long> columnMap = new HashMap<String, Long>();
        columnMap.put("app_id", appId);
        columnMap.put("parentId", null);
        List tableList = (List)this.customTableService.listByMap(columnMap);
        if (tableList != null && tableList.size() > 0) {
            Long tableId = ((CustomTableEntity)((Object)tableList.get(0))).getId();
            param.getParams().put("tableId", new Parameter("eq", (Object)tableId));
            param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
            IPage page = this.customColumnService.queryPage(param, false);
            pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CustomColumnVO.class));
            return CommonResponse.success((Object)pageData);
        }
        return CommonResponse.success((Object)pageData);
    }
}

