/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cfs.bean.CustomAppGroupEntity;
import com.ejianc.foundation.cfs.service.ICustomAppGroupService;
import com.ejianc.foundation.cfs.vo.CustomAppGroupVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"custom/appgroup"})
public class CustomAppGroupController
implements Serializable {
    private static final long serialVersionUID = -2375185721518855309L;
    private static final String BILL_CODE = "CFS_APP_GROUP_CODE";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICustomAppGroupService service;
    @Autowired
    private IBillCodeApi billCodeApi;

    @RequestMapping(value={"/saveOrUpdateGroup"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CustomAppGroupVO> saveOrUpdateGroup(@RequestBody CustomAppGroupVO saveorUpdateVO) {
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0L) {
            CustomAppGroupEntity uniqueBean = (CustomAppGroupEntity)((Object)this.service.selectById(saveorUpdateVO.getId()));
            uniqueBean.setName(saveorUpdateVO.getName());
            uniqueBean.setCode(saveorUpdateVO.getCode());
            uniqueBean.setSequence(saveorUpdateVO.getSequence());
            this.service.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        CustomAppGroupEntity entity = (CustomAppGroupEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, CustomAppGroupEntity.class));
        entity.setId(IdWorker.getId());
        CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
        if (!billCode.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        entity.setCode((String)billCode.getData());
        this.service.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryGroupDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CustomAppGroupVO> queryGroupDetail(Long id) {
        CustomAppGroupEntity entity = (CustomAppGroupEntity)((Object)this.service.selectById(id));
        CustomAppGroupVO vo = (CustomAppGroupVO)BeanMapper.map((Object)((Object)entity), CustomAppGroupVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/deleteGroup"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteGroup(@RequestBody List<CustomAppGroupVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryGroupList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CustomAppGroupVO>> queryGroupList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CustomAppGroupVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

