/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomListService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.foundation.cfs.vo.CustomListVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"custom/table"})
public class CustomTableController
implements Serializable {
    private static final long serialVersionUID = 8717661796833595475L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ID = "id";
    private static final String DEL = "del";
    private static final String PID = "pid";
    private static final String ORG_ID = "org_id";
    private static final String CREATE_USER = "create_user";
    private static final String CREATE_TIME = "create_time";
    private static final String BILL_STATE = "bill_state";
    private static final Integer QUERY_TIMEOUT = 60;
    @Autowired
    private ICustomAppService customAppService;
    @Autowired
    private ICustomTableService customTableService;
    @Autowired
    private ICustomColumnService customColumnService;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private ICustomListService customListService;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/{pageCode}/save"}, method={RequestMethod.POST})
    public CommonResponse<String> save(@PathVariable String pageCode, @RequestBody JSONObject saveData) throws IOException {
        if (StringUtils.isBlank((CharSequence)pageCode)) {
            this.logger.error("\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return CommonResponse.error((String)"\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
        List<CustomColumnEntity> mainColumnEntities = this.customColumnService.queryColumnsByTableId(mainTableEntity.getId());
        if (saveData != null) {
            HashMap<String, Object> saveMap = new HashMap<String, Object>();
            if (mainColumnEntities != null && mainColumnEntities.size() > 0) {
                for (CustomColumnEntity customColumnEntity : mainColumnEntities) {
                    if (ID.equals(customColumnEntity.getProperty())) {
                        String value = saveData.getString(customColumnEntity.getProperty());
                        if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                        saveMap.put(customColumnEntity.getProperty(), saveData.getString(customColumnEntity.getProperty()));
                        continue;
                    }
                    saveMap.put(customColumnEntity.getProperty(), saveData.getString(customColumnEntity.getProperty()));
                }
            }
            Long mainPkId = 0L;
            if (saveMap.containsKey(ID)) {
                mainPkId = (Long)saveMap.get(ID);
                UpdateRequest updateRequest = new UpdateRequest(mainTableEntity.getTableName(), mainPkId.toString());
                updateRequest.doc(saveMap, XContentType.JSON);
                this.client.update(updateRequest, RequestOptions.DEFAULT);
            } else {
                IndexRequest indexRequest = new IndexRequest(mainTableEntity.getTableName());
                mainPkId = IdWorker.getId();
                saveMap.put(ID, mainPkId);
                indexRequest.id(mainPkId + "");
                saveMap.put(ORG_ID, InvocationInfoProxy.getOrgId());
                saveMap.put(BILL_STATE, 0);
                saveMap.put(CREATE_USER, InvocationInfoProxy.getUserid());
                saveMap.put(CREATE_TIME, new Date());
                indexRequest.source(saveMap, XContentType.JSON);
                this.client.index(indexRequest, RequestOptions.DEFAULT);
            }
            List<CustomTableEntity> childTableEntities = this.customTableService.queryChildTablesByMainTableId(mainTableEntity.getId());
            if (childTableEntities != null && childTableEntities.size() > 0) {
                for (CustomTableEntity childTableEntity : childTableEntities) {
                    JSONArray childDatas;
                    List<CustomColumnEntity> childColumnEntities = this.customColumnService.queryColumnsByTableId(childTableEntity.getId());
                    if (childColumnEntities == null || childColumnEntities.size() <= 0 || (childDatas = saveData.getJSONArray(childTableEntity.getUiKey())) == null || childDatas.size() <= 0) continue;
                    for (int i = 0; i < childDatas.size(); ++i) {
                        JSONObject childData = childDatas.getJSONObject(i);
                        String rowState = childData.getString("rowState");
                        if (DEL.equals(rowState)) {
                            DeleteRequest deleteRequest = new DeleteRequest(childTableEntity.getTableName(), childData.getString(ID));
                            this.client.delete(deleteRequest, RequestOptions.DEFAULT);
                            continue;
                        }
                        HashMap<String, Object> childSaveMap = new HashMap<String, Object>();
                        if (childColumnEntities != null && childColumnEntities.size() > 0) {
                            for (CustomColumnEntity childColumnEntity : childColumnEntities) {
                                if (ID.equals(childColumnEntity.getProperty())) {
                                    String value = childData.getString(childColumnEntity.getProperty());
                                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                                    childSaveMap.put(childColumnEntity.getProperty(), childData.getString(childColumnEntity.getProperty()));
                                    continue;
                                }
                                childSaveMap.put(childColumnEntity.getProperty(), childData.getString(childColumnEntity.getProperty()));
                            }
                        }
                        if (childSaveMap.containsKey(ID)) {
                            Long childPkId = (Long)childSaveMap.get(ID);
                            UpdateRequest updateRequest = new UpdateRequest(childTableEntity.getTableName(), childPkId.toString());
                            updateRequest.doc(childSaveMap, XContentType.JSON);
                            this.client.update(updateRequest, RequestOptions.DEFAULT);
                            continue;
                        }
                        IndexRequest indexRequest = new IndexRequest(childTableEntity.getTableName());
                        Long childPkId = IdWorker.getId();
                        childSaveMap.put(ID, childPkId);
                        childSaveMap.put(PID, mainPkId);
                        childSaveMap.put(CREATE_USER, InvocationInfoProxy.getUserid());
                        childSaveMap.put(CREATE_TIME, new Date());
                        indexRequest.id(childPkId + "");
                        indexRequest.source(childSaveMap, XContentType.JSON);
                        this.client.index(indexRequest, RequestOptions.DEFAULT);
                    }
                }
            }
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/{pageCode}/pageList"}, method={RequestMethod.POST})
    public CommonResponse<JSONObject> pageList(@PathVariable String pageCode, @RequestBody QueryParam queryParam) {
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgVoResponse = this.orgApi.findChildrenByParentId(orgId);
        if (orgVoResponse.isSuccess()) {
            List orgVos = (List)orgVoResponse.getData();
            StringBuffer orgIdBuffer = new StringBuffer();
            for (OrgVO orgVo : orgVos) {
                orgIdBuffer.append(orgVo.getId()).append(",");
            }
            queryParam.getParams().put(ORG_ID, new Parameter("in", (Object)orgIdBuffer.substring(0, orgIdBuffer.length() - 1)));
        }
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
        List<CustomListVO> headerFields = this.customListService.queryHeaderColumnByAppId(app.getId());
        IPage<JSONObject> page = new IPage<JSONObject>();
        SearchRequest searchRequest = new SearchRequest(new String[]{mainTableEntity.getTableName()});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        highlightBuilder.preTags(new String[]{"<span style=\"color:red\">"});
        highlightBuilder.postTags(new String[]{"</span>"});
        if (CollectionUtils.isNotEmpty(headerFields)) {
            for (CustomListVO headerField : headerFields) {
                if ("date".equals(headerField.getColumnType()) || "date".equals(headerField.getColumnType()) || "number".equals(headerField.getColumnType()) || "inputrefer".equals(headerField.getColumnType()) || "switch".equals(headerField.getColumnType()) || "currency".equals(headerField.getColumnType()) || "refAutoGrid".equals(headerField.getColumnType())) continue;
                highlightBuilder.field(headerField.getColumnProperty());
            }
        } else {
            highlightBuilder.field("*").requireFieldMatch(Boolean.valueOf(false));
        }
        sourceBuilder.highlighter(highlightBuilder);
        Map paramMap = queryParam.getParams();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery = this.setParam(boolQuery, paramMap);
        if (CollectionUtils.isNotEmpty((Collection)queryParam.getComplexParams())) {
            boolQuery.must((QueryBuilder)this.parseComplexParams(queryParam.getComplexParams()));
        }
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.sort(new FieldSortBuilder(CREATE_TIME).unmappedType("date").order(SortOrder.DESC));
        sourceBuilder.from(queryParam.getPageIndex() <= 0 ? 0 : (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        sourceBuilder.size(queryParam.getPageSize());
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            page = this.queryPage(paramMap, searchRequest);
        }
        catch (IOException e) {
            try {
                page = this.queryPage(paramMap, searchRequest);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        JSONObject responseData = new JSONObject();
        responseData.put("reportTitle", (Object)app.getAppName());
        responseData.put("data", page);
        responseData.put("gridheaders", headerFields);
        return CommonResponse.success((Object)responseData);
    }

    @RequestMapping(value={"/{pageCode}/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@PathVariable String pageCode, @RequestBody List<Long> ids) throws IOException {
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
        List<CustomTableEntity> childTableEntities = this.customTableService.queryChildTablesByMainTableId(mainTableEntity.getId());
        for (Long id : ids) {
            DeleteRequest mainDeleteRequest = new DeleteRequest(mainTableEntity.getTableName(), id.toString());
            this.client.delete(mainDeleteRequest, RequestOptions.DEFAULT);
            if (childTableEntities == null || childTableEntities.size() <= 0) continue;
            for (CustomTableEntity childTableEntity : childTableEntities) {
                DeleteByQueryRequest childDeleteRequest = new DeleteByQueryRequest(new String[]{childTableEntity.getTableName()});
                childDeleteRequest.setQuery((QueryBuilder)new TermQueryBuilder(PID, (Object)id));
                this.client.deleteByQuery(childDeleteRequest, RequestOptions.DEFAULT);
            }
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/{pageCode}/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> queryDetail(@PathVariable String pageCode, @RequestParam Long id) throws IOException {
        String dataStr;
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
        GetRequest getRequest = new GetRequest(mainTableEntity.getTableName(), id.toString());
        GetResponse mainResponse = this.client.get(getRequest, RequestOptions.DEFAULT);
        if (mainResponse.isExists() && StringUtils.isNotBlank((CharSequence)(dataStr = mainResponse.getSourceAsString()))) {
            JSONObject mainDetail = JSON.parseObject((String)dataStr);
            List<CustomTableEntity> childTableEntities = this.customTableService.queryChildTablesByMainTableId(mainTableEntity.getId());
            if (childTableEntities != null && childTableEntities.size() > 0) {
                for (CustomTableEntity childTableEntity : childTableEntities) {
                    BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)PID, (Object)mainDetail.get((Object)PID)));
                    SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
                    sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
                    SearchRequest searchRequest = new SearchRequest(new String[]{childTableEntity.getTableName()});
                    searchRequest.source(sourceBuilder);
                    try {
                        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                        SearchHits hits = response.getHits();
                        for (SearchHit hit : hits) {
                            String sourceAsString = hit.getSourceAsString();
                            mainDetail.put(childTableEntity.getUiKey(), JSON.parse((String)sourceAsString));
                        }
                    }
                    catch (IOException e) {
                        try {
                            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                            SearchHits hits = response.getHits();
                            for (SearchHit hit : hits) {
                                String sourceAsString = hit.getSourceAsString();
                                mainDetail.put(childTableEntity.getUiKey(), JSON.parse((String)sourceAsString));
                            }
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                            throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
                        }
                    }
                }
            }
            return CommonResponse.success((Object)mainDetail);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
    }

    private BoolQueryBuilder setParam(BoolQueryBuilder boolQuery, Map<String, Parameter> paramMap) {
        for (Map.Entry<String, Parameter> entry : paramMap.entrySet()) {
            Parameter param = entry.getValue();
            if (param.getValue() == null || StringUtils.isBlank((CharSequence)(param.getValue() + ""))) continue;
            if ("eq".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)entry.getKey(), (String)param.getValue().toString()));
                continue;
            }
            if ("like".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)entry.getKey(), (Object)param.getValue().toString()).analyzer("ik_smart"));
                continue;
            }
            if ("in".equals(param.getType())) {
                Object inParam = param.getValue();
                if (inParam instanceof String) {
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)entry.getKey(), Arrays.asList(inParam.toString().split(","))));
                    continue;
                }
                if (!(inParam instanceof JSONArray)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)entry.getKey(), (Collection)JSONObject.parseArray((String)JSONObject.toJSONString((Object)inParam), Long.class)));
                continue;
            }
            if ("between".equals(param.getType())) {
                String[] dataArr = param.getValue().toString().split(",");
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).from((Object)dataArr[0]).to((Object)dataArr[1]).includeLower(true).includeUpper(true));
                continue;
            }
            if ("gt".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).gt((Object)param.getValue().toString()));
                continue;
            }
            if ("ge".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).gte((Object)param.getValue().toString()));
                continue;
            }
            if ("lt".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).lt((Object)param.getValue().toString()));
                continue;
            }
            if (!"le".equals(param.getType())) continue;
            boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).lte((Object)param.getValue().toString()));
        }
        return boolQuery;
    }

    private BoolQueryBuilder parseComplexParams(List<ComplexParam> complexParams) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        for (ComplexParam cp : complexParams) {
            if ("and".equals(cp.getLogic())) {
                if (!cp.getParams().isEmpty()) {
                    boolQuery.must((QueryBuilder)this.setParam(QueryBuilders.boolQuery(), cp.getParams()));
                }
                if (!CollectionUtils.isNotEmpty((Collection)cp.getComplexParams())) continue;
                boolQuery.must((QueryBuilder)this.parseComplexParams(cp.getComplexParams()));
                continue;
            }
            if (!cp.getParams().isEmpty()) {
                boolQuery.should((QueryBuilder)this.setParam(QueryBuilders.boolQuery(), cp.getParams()));
            }
            if (!CollectionUtils.isNotEmpty((Collection)cp.getComplexParams())) continue;
            boolQuery.should((QueryBuilder)this.parseComplexParams(cp.getComplexParams()));
        }
        return boolQuery;
    }

    private IPage<JSONObject> queryPage(Map<String, Parameter> paramMap, SearchRequest searchRequest) throws IOException {
        Page page = new Page();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        for (SearchHit hit : response.getHits()) {
            Map source = hit.getSourceAsMap();
            Map highlightFields = hit.getHighlightFields();
            for (Map.Entry highlightEntry : highlightFields.entrySet()) {
                HighlightField nameField;
                Parameter parameter;
                if (!paramMap.containsKey(highlightEntry.getKey()) || !StringUtils.isNotBlank((CharSequence)((parameter = paramMap.get(highlightEntry.getKey())).getValue() + "")) || (nameField = (HighlightField)highlightEntry.getValue()) == null) continue;
                Text[] fragments = nameField.fragments();
                StringBuilder nameTmp = new StringBuilder();
                for (Text text : fragments) {
                    nameTmp.append(text);
                }
                source.put(highlightEntry.getKey(), nameTmp.toString());
            }
        }
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            list.add(new JSONObject(hit.getSourceAsMap()));
        }
        page.setRecords(list);
        page.setTotal(hits.getTotalHits().value);
        return page;
    }
}

