/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomListService;
import com.ejianc.foundation.cfs.vo.CustomAppVO;
import com.ejianc.foundation.front.api.IFrontApi;
import com.ejianc.foundation.front.vo.IdeModuleVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import redis.clients.jedis.Jedis;

@RestController
@RequestMapping(value={"custom/app"})
public class CustomAppController
implements Serializable {
    private static final long serialVersionUID = -2549939173725536626L;
    private static final String CURRENTUSER_ROLE_KEY = "currentuser_role_key:";
    @Autowired
    private ICustomAppService customAppService;
    @Autowired
    private ICustomListService customListService;
    @Autowired
    private IFrontApi iFrontApi;
    @Autowired
    private CacheManager cacheManager;

    @RequestMapping(value={"/queryAppList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CustomAppVO>> queryAppList(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.customAppService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CustomAppVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveOrUpdateApp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdateApp(@RequestBody CustomAppVO customAppVO) {
        if (customAppVO.getId() != null && customAppVO.getId() > 0L) {
            CustomAppEntity uniqueBean = (CustomAppEntity)((Object)this.customAppService.selectById(customAppVO.getId()));
            uniqueBean.setAppGroupId(customAppVO.getAppGroupId());
            if (!Objects.equals(customAppVO.getAppCode(), uniqueBean.getAppCode())) {
                return CommonResponse.error((String)"\u5e94\u7528\u7f16\u7801\u4e0d\u53ef\u4fee\u6539\uff01");
            }
            if (!Objects.equals(customAppVO.getAppName(), uniqueBean.getAppName())) {
                return CommonResponse.error((String)"\u5e94\u7528\u540d\u79f0\u4e0d\u53ef\u4fee\u6539\uff01");
            }
            if ((uniqueBean.getPublishState() == 0 || uniqueBean.getPublishState() == null) && customAppVO.getPublishState() == 1) {
                QueryParam param = new QueryParam();
                param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
                param.getParams().put("appId", new Parameter("eq", (Object)uniqueBean.getId()));
                List list = this.customListService.queryList(param, false);
                if (ListUtil.isEmpty((List)list)) {
                    return CommonResponse.error((String)"\u5c1a\u672a\u914d\u7f6e\u5217\u8868\u9879\uff0c\u8bf7\u5148\u914d\u7f6e\u5217\u8868\u9879\uff01");
                }
            }
            uniqueBean.setAppIcon(customAppVO.getAppIcon());
            uniqueBean.setAuthFlag(customAppVO.getAuthFlag());
            uniqueBean.setAppState(customAppVO.getAppState());
            uniqueBean.setPublishState(customAppVO.getPublishState());
            uniqueBean.setSequence(customAppVO.getSequence());
            uniqueBean.setType(customAppVO.getType());
            this.customAppService.saveOrUpdate((Object)uniqueBean, false);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        CustomAppEntity entity = (CustomAppEntity)((Object)BeanMapper.map((Object)customAppVO, CustomAppEntity.class));
        entity.setId(IdWorker.getId());
        entity.setAppCode("CFS" + System.currentTimeMillis());
        IdeModuleVO moduleVO = new IdeModuleVO();
        moduleVO.setId(entity.getId());
        moduleVO.setCode(entity.getAppCode());
        moduleVO.setAppId(entity.getId());
        moduleVO.setAppCode(entity.getAppCode());
        moduleVO.setCreateDate(new Date());
        moduleVO.setName(entity.getAppName());
        moduleVO.setCreateId(InvocationInfoProxy.getUserid());
        moduleVO.setData(this.customAppService.getPageInitData(entity.getAppName()));
        CommonResponse response = this.iFrontApi.insertNewCfsPage(moduleVO);
        if (!response.isSuccess()) {
            return CommonResponse.error((String)response.getMsg());
        }
        this.customAppService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/deleteApp"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> deleteApp(@RequestBody List<CustomAppVO> vos) {
        this.customAppService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"list"})
    public CommonResponse<List<CustomAppVO>> queryList() {
        List<CustomAppVO> noAuthCustomApps;
        ArrayList<CustomAppVO> appList = new ArrayList<CustomAppVO>();
        HashMap<Long, Long> customAppMap = new HashMap<Long, Long>();
        Long userId = InvocationInfoProxy.getUserid();
        List<Long> roleIds = this.getUserRoleCache(userId);
        if (roleIds != null && roleIds.size() > 0) {
            List<CustomAppVO> customAppVos;
            String roleIdStr = "";
            for (Long l : roleIds) {
                roleIdStr = roleIdStr + l + ",";
            }
            if (StringUtils.isNotBlank((CharSequence)roleIdStr) && (customAppVos = this.customAppService.queryUserCustomAppList(roleIdStr.substring(0, roleIdStr.length() - 1))) != null && customAppVos.size() > 0) {
                for (CustomAppVO customAppVo : customAppVos) {
                    if (!StringUtils.isNotBlank((CharSequence)customAppVo.getType()) || !customAppVo.getType().contains("1")) continue;
                    customAppVo.setPcUrl("/ejc-cfs-frontend/#/cfsDefine/" + customAppVo.getAppCode() + "/" + customAppVo.getAppCode());
                    appList.add(customAppVo);
                    customAppMap.put(customAppVo.getId(), customAppVo.getId());
                }
            }
        }
        if ((noAuthCustomApps = this.customAppService.queryAllNoAuthCustomApps()) != null && noAuthCustomApps.size() > 0) {
            for (CustomAppVO customAppVO : noAuthCustomApps) {
                if (customAppMap.containsKey(customAppVO.getId()) || !StringUtils.isNotBlank((CharSequence)customAppVO.getType()) || !customAppVO.getType().contains("1")) continue;
                customAppVO.setPcUrl("/ejc-cfs-frontend/#/cfsDefine/" + customAppVO.getAppCode() + "/" + customAppVO.getAppCode());
                appList.add(customAppVO);
            }
        }
        return CommonResponse.success(appList);
    }

    private List<Long> getUserRoleCache(Long userId) {
        ArrayList<Long> resultList = new ArrayList<Long>();
        final String key = CURRENTUSER_ROLE_KEY + userId;
        Set roleIds = (Set)this.cacheManager.execute((CacheManager.JedisAction)new CacheManager.JedisAction<Set<String>>(){

            public Set<String> action(Jedis jedis) {
                return jedis.smembers(key);
            }
        });
        if (roleIds != null && !roleIds.isEmpty()) {
            for (String roleId : roleIds) {
                resultList.add(Long.parseLong(roleId));
            }
        }
        return resultList;
    }
}

