package com.ejianc.foundation.cfs.controller;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomAppGroupEntity;
import com.ejianc.foundation.cfs.service.ICustomAppGroupService;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.vo.CustomAppGroupVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@RestController
@RequestMapping("custom/appgroup")
public class CustomAppGroupController implements Serializable {

	private static final long serialVersionUID = -2375185721518855309L;
    private static final String BILL_CODE = "CFS_APP_GROUP_CODE";
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICustomAppGroupService service; 
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICustomAppService customAppService;
	

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdateGroup", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CustomAppGroupVO> saveOrUpdateGroup(@RequestBody CustomAppGroupVO saveorUpdateVO) {
		if(saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) {
			CustomAppGroupEntity uniqueBean = service.selectById(saveorUpdateVO.getId());
			uniqueBean.setName(saveorUpdateVO.getName());
			uniqueBean.setCode(saveorUpdateVO.getCode());
			uniqueBean.setSequence(saveorUpdateVO.getSequence());
			service.saveOrUpdate(uniqueBean, false);
			return CommonResponse.success("修改成功！");
		}else{
	    	CustomAppGroupEntity entity = BeanMapper.map(saveorUpdateVO, CustomAppGroupEntity.class);
	    	entity.setId(IdWorker.getId());
	    	CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
			service.saveOrUpdate(entity, false);
	    	return CommonResponse.success("保存成功！");
		}
    }
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryGroupDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CustomAppGroupVO> queryGroupDetail(Long id) {
    	CustomAppGroupEntity entity = service.selectById(id);
    	CustomAppGroupVO vo = BeanMapper.map(entity, CustomAppGroupVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/deleteGroup", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteGroup(@RequestBody List<CustomAppGroupVO> vos) {
    	QueryWrapper<CustomAppEntity> queryAppWrapper = new QueryWrapper<>();
    	queryAppWrapper.eq("dr", 0);
    	queryAppWrapper.in("app_group_id", vos.stream().map(CustomAppGroupVO::getId).collect(Collectors.toList()));
		List<CustomAppEntity> list = customAppService.list(queryAppWrapper);
		if(list!=null&&list.size()>0){
			return CommonResponse.error("删除的分组中存在应用，不能删除");
		}
        service.removeByIds(vos.stream().map(CustomAppGroupVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
    
    /**
     * @Description queryList 查询应用分组
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
	@RequestMapping(value = "/queryGroupList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CustomAppGroupVO>> queryGroupList(@RequestBody QueryParam param) {
        /** 租户隔离 */
    	param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
    	IPage<CustomAppGroupEntity> page = service.queryPage(param,false);

    	IPage<CustomAppGroupVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CustomAppGroupVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

}
