package com.ejianc.foundation.cfs.service;

import java.io.IOException;
import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 自定义表
 * 
 * @author guoming
 *
 */
public interface ICustomTableService extends IBaseService<CustomTableEntity> {

	void deleteCustomTable(Long mainFormId);

	/**
	 * 根据appId查询主表信息
	 * 
	 * @param id
	 * @return
	 */
	CustomTableEntity queryMainTableByAppId(Long appId);

	/**
	 * 根据主tableId查询子表
	 * 
	 * @param mainTableId
	 * @return
	 */
	List<CustomTableEntity> queryChildTablesByMainTableId(Long mainTableId);

	CommonResponse<JSONObject> queryDetail(String pageCode, Long id) throws IOException;
}
