package com.ejianc.foundation.cfs.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.mapper.CustomColumnMapper;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class CustomColumnServiceImpl extends BaseServiceImpl<CustomColumnMapper, CustomColumnEntity> implements ICustomColumnService {

	@Autowired
	private CustomColumnMapper customColumnMapper;
	
	@Override
	public void deleteCustomColumnByTableId(Long mainFormId) {
		customColumnMapper.deleteCustomColumnByTableId(mainFormId);
	}

	@Override
	public List<CustomColumnEntity> queryColumnsByTableId(Long tableId) {
		QueryWrapper<CustomColumnEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("custom_table_id", tableId);
		List<CustomColumnEntity> columnEntities = customColumnMapper.selectList(queryWrapper);
		return columnEntities;
	}

}
