package com.ejianc.foundation.cfs.service.impl;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.mapper.CustomTableMapper;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class CustomTableServiceImpl extends BaseServiceImpl<CustomTableMapper, CustomTableEntity> implements ICustomTableService {
	private final static String ID = "id";
	private final static String DEL = "del";
	private final static String PID = "pid";
	private final static String ORG_ID = "orgId";
	private final static String CREATE_USER = "createUser";
	private final static String CREATE_TIME = "createTime";
	private final static String BILL_STATE = "billState";
	private final static Integer QUERY_TIMEOUT = 60;
	@Autowired
	private CustomTableMapper customTableMapper;
	@Autowired
	private ICustomAppService customAppService;
	@Autowired
	private RestHighLevelClient client;
	
	@Override
	public void deleteCustomTable(Long mainFormId) {
		customTableMapper.deleteCustomTable(mainFormId);
	}

	@Override
	public CustomTableEntity queryMainTableByAppId(Long appId) {
		CustomTableEntity customTableEntity = customTableMapper.queryMainTableByAppId(appId);
		return customTableEntity;
	}

	@Override
	public List<CustomTableEntity> queryChildTablesByMainTableId(Long mainTableId) {
		QueryWrapper<CustomTableEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("parent_id", mainTableId);
		List<CustomTableEntity> childTableEntities = customTableMapper.selectList(queryWrapper);
		return childTableEntities;
	}

	@Override
	public CommonResponse<JSONObject> queryDetail(String pageCode, Long id) throws IOException {
		//根据应用编号查询应用
		CustomAppEntity app = customAppService.queryCustomAppByCode(pageCode);
		//根据appid查询主表信息
		CustomTableEntity mainTableEntity = this.queryMainTableByAppId(app.getId());

		GetRequest getRequest = new GetRequest(mainTableEntity.getTableName(), id.toString());
		GetResponse mainResponse = client.get(getRequest, RequestOptions.DEFAULT);
		if(mainResponse.isExists()) {
			String dataStr = mainResponse.getSourceAsString();

			if(StringUtils.isNotBlank(dataStr)) {
				JSONObject mainDetail = JSON.parseObject(dataStr);

				//查询子表
				List<CustomTableEntity> childTableEntities = this.queryChildTablesByMainTableId(mainTableEntity.getId());
				if(childTableEntities != null && childTableEntities.size() > 0) {
					for(CustomTableEntity childTableEntity:childTableEntities) {
						JSONArray subTbsData = new JSONArray();
						BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
						boolQueryBuilder.must(QueryBuilders.termQuery(PID, mainDetail.get(ID)));

						SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
						sourceBuilder.query(boolQueryBuilder);
						sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间

						SearchRequest searchRequest = new SearchRequest(childTableEntity.getTableName());
						searchRequest.source(sourceBuilder);
						try {
							SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
							SearchHits hits = response.getHits();
							for (SearchHit hit : hits) {
								String sourceAsString = hit.getSourceAsString();
								mainDetail.put(childTableEntity.getUiKey(), JSON.parse(sourceAsString));
								subTbsData.add(JSON.parse(sourceAsString));
							}
							mainDetail.put(childTableEntity.getUiKey(), subTbsData);
						} catch (IOException e) {
							try { //报IOException时， 重试一次
								SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
								SearchHits hits = response.getHits();
								for (SearchHit hit : hits) {
									String sourceAsString = hit.getSourceAsString();
									subTbsData.add(JSON.parse(sourceAsString));
								}
								mainDetail.put(childTableEntity.getUiKey(), subTbsData);
							} catch(IOException e1) {
								e1.printStackTrace();
								throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG："+e1.getMessage());
							}
						}
					}
				}
				return CommonResponse.success(mainDetail);
			}
		}
		return CommonResponse.error("查询失败:数据已删除或不存在！");
	}

}
