/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.mapper.CustomTableMapper;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomTableServiceImpl
extends BaseServiceImpl<CustomTableMapper, CustomTableEntity>
implements ICustomTableService {
    private static final String ID = "id";
    private static final String DEL = "del";
    private static final String PID = "pid";
    private static final String ORG_ID = "orgId";
    private static final String CREATE_USER = "createUser";
    private static final String CREATE_TIME = "createTime";
    private static final String BILL_STATE = "billState";
    private static final Integer QUERY_TIMEOUT = 60;
    @Autowired
    private CustomTableMapper customTableMapper;
    @Autowired
    private ICustomAppService customAppService;
    @Autowired
    private RestHighLevelClient client;

    @Override
    public void deleteCustomTable(Long mainFormId) {
        this.customTableMapper.deleteCustomTable(mainFormId);
    }

    @Override
    public CustomTableEntity queryMainTableByAppId(Long appId) {
        CustomTableEntity customTableEntity = this.customTableMapper.queryMainTableByAppId(appId);
        return customTableEntity;
    }

    @Override
    public List<CustomTableEntity> queryChildTablesByMainTableId(Long mainTableId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"parent_id", (Object)mainTableId);
        List childTableEntities = this.customTableMapper.selectList((Wrapper)queryWrapper);
        return childTableEntities;
    }

    @Override
    public CommonResponse<JSONObject> queryDetail(String pageCode, Long id) throws IOException {
        String dataStr;
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        CustomTableEntity mainTableEntity = this.queryMainTableByAppId(app.getId());
        GetRequest getRequest = new GetRequest(mainTableEntity.getTableName(), id.toString());
        GetResponse mainResponse = this.client.get(getRequest, RequestOptions.DEFAULT);
        if (mainResponse.isExists() && StringUtils.isNotBlank((CharSequence)(dataStr = mainResponse.getSourceAsString()))) {
            JSONObject mainDetail = JSON.parseObject((String)dataStr);
            List<CustomTableEntity> childTableEntities = this.queryChildTablesByMainTableId(mainTableEntity.getId());
            if (childTableEntities != null && childTableEntities.size() > 0) {
                for (CustomTableEntity childTableEntity : childTableEntities) {
                    JSONArray subTbsData = new JSONArray();
                    BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)PID, (Object)mainDetail.get((Object)ID)));
                    SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
                    sourceBuilder.query((QueryBuilder)boolQueryBuilder);
                    sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
                    SearchRequest searchRequest = new SearchRequest(new String[]{childTableEntity.getTableName()});
                    searchRequest.source(sourceBuilder);
                    try {
                        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                        SearchHits hits = response.getHits();
                        for (SearchHit hit : hits) {
                            String sourceAsString = hit.getSourceAsString();
                            mainDetail.put(childTableEntity.getUiKey(), JSON.parse((String)sourceAsString));
                            subTbsData.add(JSON.parse((String)sourceAsString));
                        }
                        mainDetail.put(childTableEntity.getUiKey(), (Object)subTbsData);
                    }
                    catch (IOException e) {
                        try {
                            SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                            SearchHits hits = response.getHits();
                            for (SearchHit hit : hits) {
                                String sourceAsString = hit.getSourceAsString();
                                subTbsData.add(JSON.parse((String)sourceAsString));
                            }
                            mainDetail.put(childTableEntity.getUiKey(), (Object)subTbsData);
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                            throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
                        }
                    }
                }
            }
            return CommonResponse.success((Object)mainDetail);
        }
        return CommonResponse.error((String)"\u67e5\u8be2\u5931\u8d25:\u6570\u636e\u5df2\u5220\u9664\u6216\u4e0d\u5b58\u5728\uff01");
    }
}

