/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomListService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.foundation.cfs.util.ParsePageMetaUtils;
import com.ejianc.foundation.cfs.vo.ColumnVO;
import com.ejianc.foundation.cfs.vo.PageData;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/no_auth/api/customtable/"})
public class CustomTableApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SESSION_PREFIX = "ICOP_SESSION_USER:";
    private static final Gson gson = new Gson();
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private ICustomAppService customAppService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICustomTableService customTableService;
    @Autowired
    private ICustomColumnService customColumnService;
    @Autowired
    private ICustomListService customListService;

    @PostMapping(value={"parse"})
    public CommonResponse<String> parse(@RequestBody PageData pageData) throws IOException {
        this.logger.info(pageData.toString());
        String sid = SESSION_PREFIX + pageData.getUserId();
        String userContextStr = this.sessionManager.getSessionCacheAttribute(sid, pageData.getToken());
        if (StringUtils.isBlank((CharSequence)userContextStr)) {
            return CommonResponse.error((String)"\u7528\u6237\u4e0a\u4e0b\u6587\u4e3a\u7a7a\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
        }
        UserContext userContext = (UserContext)gson.fromJson(userContextStr, UserContext.class);
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageData.getAppCode());
        if (app != null) {
            if ("1".equals(app.getPublishState())) {
                return CommonResponse.error((String)"\u8be5\u5e94\u7528\u5df2\u53d1\u5e03\uff0c\u4e0d\u80fd\u8fdb\u884c\u8bbe\u8ba1\uff01");
            }
            Map<String, List<JSONObject>> pageMetaMap = ParsePageMetaUtils.parse(pageData.getPageMeta());
            List<JSONObject> formWidgetList = pageMetaMap.get("FormWidget");
            List<JSONObject> editTableWidgetList = pageMetaMap.get("EditTableWidget");
            Long mainFormId = IdWorker.getId();
            this.clearCustomTable(app.getId());
            if (ListUtil.isNotEmpty(formWidgetList)) {
                CustomTableEntity mainTable = new CustomTableEntity();
                String mainTableName = "formWidget_" + pageData.getAppCode();
                mainTableName = mainTableName.toLowerCase();
                mainTable.setId(mainFormId);
                mainTable.setAppId(app.getId());
                mainTable.setUiKey("mainUiKey");
                mainTable.setTableName(mainTableName);
                mainTable.setTenantId(userContext.getTenantid());
                mainTable.setCreateUserCode(userContext.getUserCode());
                mainTable.setCreateTime(new Date());
                this.customTableService.saveOrUpdate((Object)mainTable);
                XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties");
                mapping.startObject("id").field("type", "text").endObject();
                mapping.startObject("orgId").field("type", "text").endObject();
                mapping.startObject("orgName").field("type", "text").endObject();
                mapping.startObject("billState").field("type", "integer").endObject();
                mapping.startObject("createTime").field("type", "date").field("format", "yyyy-MM-dd HH:mm:ss").endObject();
                mapping.startObject("createUser").field("type", "text").endObject();
                mapping.startObject("creatorName").field("type", "text").endObject();
                List<CustomColumnEntity> entities = this.getPublicCustomColumnEntity(mainFormId, 1);
                entities.forEach(col -> this.customColumnService.save(col));
                for (int i = 0; i < formWidgetList.size(); ++i) {
                    JSONArray mainChildren = formWidgetList.get(i).getJSONArray("children");
                    if (mainChildren == null) continue;
                    for (int m = 0; m < mainChildren.size(); ++m) {
                        String uitype;
                        JSONObject mainField = mainChildren.getJSONObject(m);
                        CustomColumnEntity mainCol = new CustomColumnEntity();
                        mainCol.setId(IdWorker.getId());
                        mainCol.setCustomTableId(mainFormId);
                        mainCol.setColumnName(mainField.getString("uititle"));
                        mainCol.setProperty(mainField.getString("uikey"));
                        switch (uitype = mainField.getString("uisubtype")) {
                            case "date": {
                                mainCol.setType("date");
                                mapping.startObject(mainField.getString("uikey")).field("type", "date").field("format", "yyyy-MM-dd HH:mm:ss").endObject();
                                break;
                            }
                            case "time": {
                                mapping.startObject(mainField.getString("uikey")).field("type", "date").field("format", "yyyy-MM-dd HH:mm:ss").endObject();
                                mainCol.setType("date");
                                break;
                            }
                            case "number": {
                                mainCol.setType("number");
                                mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
                                break;
                            }
                            case "inputrefer": 
                            case "enumselect": {
                                mainCol.setType("refer");
                                mainCol.setVal(mainField.getString("refinfokey"));
                                mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
                                break;
                            }
                            case "switch": {
                                mainCol.setType("integer");
                                String name = "";
                                name = StringUtils.isNotEmpty((CharSequence)mainField.getString("checkedChildren")) ? name + mainField.getString("checkedChildren") + "," : name + "\u662f,";
                                name = StringUtils.isNotEmpty((CharSequence)mainField.getString("unCheckedChildren")) ? name + mainField.getString("unCheckedChildren") : name + "\u5426";
                                mainCol.setVal(name);
                                mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
                                break;
                            }
                            case "currency": {
                                mainCol.setType("bigdecimal");
                                mapping.startObject(mainField.getString("uikey")).field("type", "text").endObject();
                                break;
                            }
                            case "select": {
                                mainCol.setType("select");
                                mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
                                break;
                            }
                            case "refAutoGrid": {
                                mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
                                mainCol.setType("refer");
                                mainCol.setVal(mainField.getString("refinfokey"));
                                break;
                            }
                            default: {
                                mainCol.setType("string");
                                mapping.startObject(mainField.getString("uikey")).field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
                            }
                        }
                        mainCol.setSequence(m + 1);
                        this.customColumnService.save((Object)mainCol);
                    }
                }
                mapping.endObject().endObject();
                CreateIndexRequest createIndexRequest = new CreateIndexRequest(mainTableName);
                createIndexRequest.settings(Settings.builder().put("index.number_of_shards", 5).put("index.number_of_replicas", 1));
                createIndexRequest.mapping(mapping);
                createIndexRequest.alias(new Alias(app.getAppName() + "\u4e3b\u8868"));
                CreateIndexResponse createIndexResponse = this.client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
                boolean acknowledged = createIndexResponse.isAcknowledged();
                if (!acknowledged) {
                    this.logger.info("es\u5e93\u521b\u5efa\u5931\u8d25");
                    return CommonResponse.error((String)"es\u5e93\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                }
            }
            if (ListUtil.isNotEmpty(editTableWidgetList)) {
                for (int i = 0; i < editTableWidgetList.size(); ++i) {
                    String childUiKey = editTableWidgetList.get(i).getString("uikey");
                    Long childPkId = IdWorker.getId();
                    String subTableName = "editTableWidget_" + pageData.getAppCode() + "_" + childUiKey;
                    subTableName = subTableName.toLowerCase();
                    CustomTableEntity subTable = new CustomTableEntity();
                    subTable.setId(childPkId);
                    subTable.setParentId(mainFormId);
                    subTable.setAppId(app.getId());
                    subTable.setUiKey(childUiKey);
                    subTable.setTableName(subTableName);
                    subTable.setTenantId(userContext.getTenantid());
                    subTable.setCreateUserCode(userContext.getUserCode());
                    subTable.setCreateTime(new Date());
                    this.customTableService.saveOrUpdate((Object)subTable);
                    JSONArray childrenArray = editTableWidgetList.get(i).getJSONArray("children");
                    XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("properties");
                    mapping.startObject("id").field("type", "text").endObject();
                    mapping.startObject("pid").field("type", "text").endObject();
                    mapping.startObject("createTime").field("type", "date").field("format", "yyyy-MM-dd HH:mm:ss").endObject();
                    mapping.startObject("createUser").field("type", "text").endObject();
                    mapping.startObject("creatorName").field("type", "text").endObject();
                    List<CustomColumnEntity> entities = this.getPublicCustomColumnEntity(childPkId, 0);
                    entities.forEach(col -> this.customColumnService.save(col));
                    if (childrenArray != null) {
                        for (int m = 0; m < childrenArray.size(); ++m) {
                            String uitype;
                            JSONObject childField = childrenArray.getJSONObject(m);
                            CustomColumnEntity subCol = new CustomColumnEntity();
                            subCol.setId(IdWorker.getId());
                            subCol.setCustomTableId(childPkId);
                            subCol.setColumnName(childField.getString("uititle"));
                            subCol.setProperty(childField.getString("uikey"));
                            subCol.setSequence(m);
                            switch (uitype = childField.getString("uisubtype")) {
                                case "date": {
                                    subCol.setType("date");
                                    mapping.startObject(childField.getString("uikey")).field("type", "date").field("format", StringUtils.isNotEmpty((CharSequence)childField.getString("format")) ? childField.getString("format") : "yyyy-MM-dd").endObject();
                                    break;
                                }
                                case "number": {
                                    subCol.setType("number");
                                    mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
                                    break;
                                }
                                case "inputrefer": 
                                case "enumselect": {
                                    subCol.setType("refer");
                                    subCol.setVal(childField.getString("refinfokey"));
                                    mapping.startObject(childField.getString("uikey")).field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
                                    break;
                                }
                                case "switch": {
                                    subCol.setType("integer");
                                    String name = "";
                                    name = StringUtils.isNotEmpty((CharSequence)childField.getString("checkedChildren")) ? name + childField.getString("checkedChildren") + "," : name + "\u662f,";
                                    name = StringUtils.isNotEmpty((CharSequence)childField.getString("unCheckedChildren")) ? name + childField.getString("unCheckedChildren") : name + "\u5426";
                                    subCol.setVal(name);
                                    mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
                                    break;
                                }
                                case "currency": {
                                    subCol.setType("bigdecimal");
                                    mapping.startObject(childField.getString("uikey")).field("type", "text").endObject();
                                    break;
                                }
                                case "refAutoGrid": {
                                    subCol.setType("string");
                                    mapping.startObject(childField.getString("uikey")).field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
                                    subCol.setVal(childField.getString("refinfokey"));
                                    break;
                                }
                                case "select": {
                                    subCol.setType("select");
                                    mapping.startObject(childField.getString("uikey")).field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
                                    break;
                                }
                                default: {
                                    subCol.setType("string");
                                    mapping.startObject(childField.getString("uikey")).field("type", "text").field("analyzer", "ik_max_word").field("search_analyzer", "ik_smart").endObject();
                                }
                            }
                            this.customColumnService.save((Object)subCol);
                        }
                    }
                    mapping.endObject().endObject();
                    CreateIndexRequest createIndexRequest = new CreateIndexRequest(subTableName);
                    createIndexRequest.settings(Settings.builder().put("index.number_of_replicas", 1).put("index.number_of_shards", 5));
                    createIndexRequest.alias(new Alias(app.getAppName() + "\u5b50\u8868" + (i + 1)));
                    createIndexRequest.mapping(mapping);
                    CreateIndexResponse createIndexResponse = this.client.indices().create(createIndexRequest, RequestOptions.DEFAULT);
                    boolean acknowledged = createIndexResponse.isAcknowledged();
                    if (acknowledged) continue;
                    this.logger.info("es\u5e93\u521b\u5efa\u5931\u8d25");
                    return CommonResponse.error((String)"es\u5e93\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                }
            }
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return CommonResponse.error((String)"\u5e94\u7528\u7f16\u7801\u67e5\u8be2\u5931\u8d25\u3002");
    }

    private List<CustomColumnEntity> getPublicCustomColumnEntity(Long mainFormId, int type) {
        ArrayList<CustomColumnEntity> list = new ArrayList<CustomColumnEntity>();
        CustomColumnEntity col = new CustomColumnEntity();
        col.setId(IdWorker.getId());
        col.setCustomTableId(mainFormId);
        col.setColumnName("id");
        col.setProperty("id");
        col.setType("string");
        col.setSequence(-1);
        list.add(col);
        col = new CustomColumnEntity();
        col.setId(IdWorker.getId());
        col.setCustomTableId(mainFormId);
        col.setType("date");
        col.setColumnName("\u521b\u5efa\u65f6\u95f4");
        col.setProperty("createTime");
        col.setSequence(0);
        list.add(col);
        col = new CustomColumnEntity();
        col.setId(IdWorker.getId());
        col.setCustomTableId(mainFormId);
        col.setType("string");
        col.setColumnName("\u521b\u5efa\u4ebaid");
        col.setProperty("createUser");
        col.setSequence(0);
        list.add(col);
        col = new CustomColumnEntity();
        col.setId(IdWorker.getId());
        col.setCustomTableId(mainFormId);
        col.setType("string");
        col.setColumnName("\u521b\u5efa\u4eba\u540d\u79f0");
        col.setProperty("creatorName");
        col.setSequence(0);
        list.add(col);
        if (type == 1) {
            col = new CustomColumnEntity();
            col.setId(IdWorker.getId());
            col.setCustomTableId(mainFormId);
            col.setType("integer");
            col.setColumnName("\u5355\u636e\u72b6\u6001");
            col.setProperty("billState");
            col.setSequence(0);
            list.add(col);
            col = new CustomColumnEntity();
            col.setId(IdWorker.getId());
            col.setCustomTableId(mainFormId);
            col.setType("string");
            col.setColumnName("\u7ec4\u7ec7id");
            col.setProperty("orgId");
            col.setSequence(0);
            list.add(col);
            col = new CustomColumnEntity();
            col.setId(IdWorker.getId());
            col.setCustomTableId(mainFormId);
            col.setType("string");
            col.setColumnName("\u7ec4\u7ec7\u540d\u79f0");
            col.setProperty("orgName");
            col.setSequence(0);
            list.add(col);
        } else {
            col = new CustomColumnEntity();
            col.setId(IdWorker.getId());
            col.setCustomTableId(mainFormId);
            col.setType("string");
            col.setColumnName("\u4e3b\u8868id");
            col.setProperty("pid");
            col.setSequence(0);
            list.add(col);
        }
        return list;
    }

    private void clearCustomTable(Long appId) throws IOException {
        QueryWrapper childWrapper = new QueryWrapper();
        childWrapper.eq((Object)"app_id", (Object)appId);
        List childCustomTableEntities = this.customTableService.list((Wrapper)childWrapper);
        if (childCustomTableEntities != null && childCustomTableEntities.size() > 0) {
            for (int i = 0; i < childCustomTableEntities.size(); ++i) {
                CustomTableEntity childCustomTableEntity = (CustomTableEntity)((Object)childCustomTableEntities.get(i));
                this.customTableService.deleteCustomTable(childCustomTableEntity.getId());
                this.customColumnService.deleteCustomColumnByTableId(childCustomTableEntity.getId());
                GetIndexRequest request = new GetIndexRequest(new String[]{childCustomTableEntity.getTableName()});
                boolean exists = this.client.indices().exists(request, RequestOptions.DEFAULT);
                if (!exists) continue;
                DeleteIndexRequest childDeleteIndexRequest = new DeleteIndexRequest(childCustomTableEntity.getTableName());
                this.client.indices().delete(childDeleteIndexRequest, RequestOptions.DEFAULT);
            }
        }
        QueryWrapper lw = new QueryWrapper();
        lw.eq((Object)"app_id", (Object)appId);
        List listEntities = this.customListService.list((Wrapper)lw);
        if (ListUtil.isNotEmpty((List)listEntities)) {
            this.customListService.removeByIds(listEntities.stream().map(BaseEntity::getId).collect(Collectors.toList()));
        }
    }

    @RequestMapping(value={"queryColumnList"}, method={RequestMethod.GET})
    public CommonResponse<List<ColumnVO>> queryColumnList(@RequestParam(value="appCode", required=true) String appCode, @RequestParam(value="range", required=true) String range) {
        ArrayList<ColumnVO> resultList = new ArrayList<ColumnVO>();
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(appCode);
        if (app != null) {
            QueryWrapper childWrapper = new QueryWrapper();
            childWrapper.eq((Object)"app_id", (Object)app.getId());
            childWrapper.eq((Object)"dr", (Object)0);
            List childCustomTableEntities = this.customTableService.list((Wrapper)childWrapper);
            Long mainId = null;
            ArrayList<CustomTableEntity> childrenCustomTables = new ArrayList<CustomTableEntity>();
            if (childCustomTableEntities != null && childCustomTableEntities.size() > 0) {
                for (CustomTableEntity entity : childCustomTableEntities) {
                    if (entity.getParentId() != null) {
                        childrenCustomTables.add(entity);
                        continue;
                    }
                    mainId = entity.getId();
                }
                if (mainId != null) {
                    QueryWrapper mainWrapper = new QueryWrapper();
                    mainWrapper.eq((Object)"custom_table_id", (Object)mainId);
                    mainWrapper.eq((Object)"dr", (Object)0);
                    List mainColumnList = this.customColumnService.list((Wrapper)mainWrapper);
                    for (CustomColumnEntity customColumnEntity : mainColumnList) {
                        ColumnVO vo = new ColumnVO();
                        vo.setId(customColumnEntity.getId());
                        vo.setName(customColumnEntity.getColumnName() + "(" + customColumnEntity.getProperty() + ")");
                        vo.setCode(customColumnEntity.getProperty());
                        vo.setDataType(customColumnEntity.getType());
                        vo.setDisplayName(customColumnEntity.getColumnName());
                        resultList.add(vo);
                    }
                    if ("children".equals(range) && childrenCustomTables != null && childrenCustomTables.size() > 0) {
                        for (CustomTableEntity customTableEntity : childrenCustomTables) {
                            QueryWrapper childrenWrapper = new QueryWrapper();
                            childrenWrapper.eq((Object)"custom_table_id", (Object)customTableEntity.getId());
                            childrenWrapper.eq((Object)"dr", (Object)0);
                            ColumnVO cvo = new ColumnVO();
                            cvo.setId(customTableEntity.getId());
                            cvo.setName(customTableEntity.getTableName());
                            cvo.setCode(customTableEntity.getUiKey());
                            cvo.setMainAttributeField(customTableEntity.getUiKey());
                            cvo.setDisplayName(customTableEntity.getTableName());
                            resultList.add(cvo);
                            List childrenColumnList = this.customColumnService.list((Wrapper)childrenWrapper);
                            if (childrenColumnList == null || childrenColumnList.size() <= 0) continue;
                            for (CustomColumnEntity columnentity : childrenColumnList) {
                                ColumnVO vo = new ColumnVO();
                                vo.setId(columnentity.getId());
                                vo.setName(columnentity.getColumnName() + "(" + columnentity.getProperty() + ")");
                                vo.setCode(columnentity.getProperty());
                                vo.setDisplayName(columnentity.getColumnName());
                                vo.setDataType(columnentity.getType());
                                vo.setParentId(customTableEntity.getId());
                                vo.setMainAttributeField(customTableEntity.getUiKey());
                                resultList.add(vo);
                            }
                        }
                    }
                }
            }
        }
        return CommonResponse.success(resultList);
    }

    @RequestMapping(value={"updateBillState"}, method={RequestMethod.GET})
    public CommonResponse<Boolean> updateBillState(@RequestParam(value="appCode", required=true) String appCode, @RequestParam(value="id", required=true) Long id, @RequestParam(value="billState", required=true) Integer billState) throws IOException {
        CommonResponse<JSONObject> response = this.customTableService.queryDetail(appCode, id);
        if (response.isSuccess()) {
            CustomAppEntity app = this.customAppService.queryCustomAppByCode(appCode);
            CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
            JSONObject entity = (JSONObject)response.getData();
            entity.put("billState", (Object)billState);
            UpdateRequest updateRequest = new UpdateRequest(mainTableEntity.getTableName(), id.toString());
            updateRequest.doc((Map)entity, XContentType.JSON);
            UpdateResponse update = this.client.update(updateRequest, RequestOptions.DEFAULT);
            if (update.status().getStatus() != RestStatus.OK.getStatus()) {
                this.logger.error(response.toString());
                return CommonResponse.error((String)"\u66f4\u65b0\u5931\u8d25");
            }
            return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f\uff01", (Object)true);
        }
        return CommonResponse.error((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @RequestMapping(value={"queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> queryDetail(@RequestParam(value="appCode", required=true) String appCode, @RequestParam(value="id", required=true) Long id) throws IOException {
        return this.customTableService.queryDetail(appCode, id);
    }

    @RequestMapping(value={"queryPrintDetail"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> queryPrintDetail(@RequestParam(value="appCode", required=true) String appCode, @RequestParam(value="id", required=true) Long id) throws IOException {
        return this.customTableService.queryPrintDetail(appCode, id);
    }
}

