package com.ejianc.foundation.cfs.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

/**
 * 自定义应用
 * 
 * @author guoming
 *
 */
@TableName("ejc_cfs_app")
public class CustomAppEntity extends BaseEntity {

	private static final long serialVersionUID = -8878993756357134195L;

	@TableField(value = "app_group_id")
	private Long appGroupId; // 应用分组Id

	@TableField(value = "app_code")
	private String appCode; // 应用编码

	@TableField(value = "app_name")
	private String appName; // 应用名称

	@TableField(value = "app_icon")
	private String appIcon; // 应用图标

	@TableField(value = "query_range")
	private Integer queryRange; // 查询范围: 0:本下，1:本人，2:租户

	@TableField(value = "auth_flag")
	private Integer authFlag; // 是否控权: 1:控权， 0： 不控权

	@TableField(value = "app_state")
	private Integer appState; // 应用状态： 1：启用， 0：停用

	@TableField(value = "publish_state")
	private Integer publishState; // 发布状态： 1：已发布， 0：未发布

	@TableField(value = "sequence")
	private Integer sequence; // 排序号

	@TableField(value = "type")
	private String type;// '应用类型 1PC 2移动'

	public Long getAppGroupId() {
		return appGroupId;
	}

	public void setAppGroupId(Long appGroupId) {
		this.appGroupId = appGroupId;
	}

	public String getAppCode() {
		return appCode;
	}

	public void setAppCode(String appCode) {
		this.appCode = appCode;
	}

	public String getAppName() {
		return appName;
	}

	public void setAppName(String appName) {
		this.appName = appName;
	}

	public String getAppIcon() {
		return appIcon;
	}

	public void setAppIcon(String appIcon) {
		this.appIcon = appIcon;
	}

	public Integer getQueryRange() {
		return queryRange;
	}

	public void setQueryRange(Integer queryRange) {
		this.queryRange = queryRange;
	}

	public Integer getAuthFlag() {
		return authFlag;
	}

	public void setAuthFlag(Integer authFlag) {
		this.authFlag = authFlag;
	}

	public Integer getAppState() {
		return appState;
	}

	public void setAppState(Integer appState) {
		this.appState = appState;
	}

	public Integer getPublishState() {
		return publishState;
	}

	public void setPublishState(Integer publishState) {
		this.publishState = publishState;
	}

	public Integer getSequence() {
		return sequence;
	}

	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

}
