package com.ejianc.foundation.cfs.service.impl;

import java.util.ArrayList;
import java.util.List;

import com.ejianc.foundation.cfs.mapper.CustomAppMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.mapper.CustomColumnMapper;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class CustomColumnServiceImpl extends BaseServiceImpl<CustomColumnMapper, CustomColumnEntity> implements ICustomColumnService {

	@Autowired
	private CustomColumnMapper customColumnMapper;
	@Autowired
	private ICustomAppService customAppService;
	@Autowired
	private ICustomTableService customTableService;
	@Autowired
	private ICustomColumnService customColumnService;
	@Autowired
	private CustomAppMapper customAppMapper;
	
	@Override
	public void deleteCustomColumnByTableId(Long mainFormId) {
		customColumnMapper.deleteCustomColumnByTableId(mainFormId);
	}

	@Override
	public List<CustomColumnEntity> queryColumnsByTableId(Long tableId) {
		QueryWrapper<CustomColumnEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("custom_table_id", tableId);
		List<CustomColumnEntity> columnEntities = customColumnMapper.selectList(queryWrapper);
		return columnEntities;
	}

	@Override
	public JSONObject getEntityDetailTree(String appCode) {
		//根据应用编号查询应用
		CustomAppEntity app = customAppService.queryCustomAppByCode(appCode);

		return getEntityDetailTree(app);
	}

	private JSONObject getEntityDetailTree(CustomAppEntity app) {
		JSONObject resp = new JSONObject();
		QueryWrapper<CustomTableEntity> mainWrapper = new QueryWrapper<>();
		mainWrapper.eq("app_id", app.getId());
		mainWrapper.eq("dr", 0);
		mainWrapper.isNull("parent_id");
		List<CustomTableEntity> mainCustomTableEntities = customTableService.list(mainWrapper);
		if(mainCustomTableEntities!=null&&mainCustomTableEntities.size()>0){
			CustomTableEntity customTable = mainCustomTableEntities.get(0);

			translateEntityInfo(customTable, resp);
			resp.put("parentEntityId", customTable.getId());
			resp.put("entityName", app.getAppCode());
			resp.put("displayName", app.getAppName());
			resp.put("entityFullName", app.getAppName());

			QueryWrapper<CustomColumnEntity> mainColumnWrapper = new QueryWrapper<>();
			mainColumnWrapper.eq("custom_table_id", customTable.getId());
			mainColumnWrapper.eq("dr", 0);
			//2、根据主表查询主表字段
			List<CustomColumnEntity> mainColumnList = customColumnService.list(mainColumnWrapper);
			List<JSONObject> attrs = new ArrayList<>();
			if(CollectionUtils.isNotEmpty(mainColumnList)) {
				for(CustomColumnEntity entity : mainColumnList){
					JSONObject attr = new JSONObject();
					translateAttrInfo(entity, attr);
					attrs.add(attr);
				}
			}

			//查询子表信息
			QueryWrapper<CustomTableEntity> childWrapper = new QueryWrapper<>();
			childWrapper.eq("app_id", app.getId());
			childWrapper.eq("dr", 0);
			childWrapper.eq("parent_id", customTable.getId());
			List<CustomTableEntity> childCustomTableEntities = customTableService.list(childWrapper);

			if(CollectionUtils.isNotEmpty(childCustomTableEntities)) {
				for(CustomTableEntity cls : childCustomTableEntities) {
					JSONObject childJson = new JSONObject();
					translateEntityInfo(cls, childJson);

					QueryWrapper<CustomColumnEntity> childColumnWrapper = new QueryWrapper<>();
					childColumnWrapper.eq("custom_table_id", cls.getId());
					childColumnWrapper.eq("dr", 0);
					//2、根据主表查询主表字段
					List<CustomColumnEntity> childColumnList = customColumnService.list(childColumnWrapper);
					List<JSONObject> childattrs = new ArrayList<>();
					if(CollectionUtils.isNotEmpty(childColumnList)) {
						for(CustomColumnEntity entity : childColumnList){
							JSONObject attr = new JSONObject();
							translateAttrInfo(entity, attr);
							childattrs.add(attr);
						}
					}
					childJson.put("attrs", childattrs);
					attrs.add(childJson);
				}
			}
			resp.put("attrs", attrs);
		}

		return resp;
	}

	@Override
	public JSONObject getEntityDetailTreeByAppId(Long appId) {
		//根据应用编号查询应用
		CustomAppEntity app = customAppMapper.selectById(appId);
		return getEntityDetailTree(app);
	}

	/**
	 * 从类实体基本信息中抽取打印元数据需要的属性字段
	 *
	 * @param mdClassVO
	 * @param resp
	 */
	private void translateEntityInfo(CustomTableEntity mdClassVO, JSONObject resp) {
		resp.put("entityName", mdClassVO.getUiKey());
		resp.put("entityId", mdClassVO.getId());
		resp.put("displayName", mdClassVO.getTableName());
		resp.put("entityFullName", mdClassVO.getTableName());
		resp.put("isKey", false);
		resp.put("key", mdClassVO.getId());
		resp.put("type", "entity");
	}

	/**
	 * 从属性实体中抽取打印元数据需要的属性字段
	 *
	 * @param attr
	 * @param resp
	 */
	private void translateAttrInfo(CustomColumnEntity attr, JSONObject resp) {
		resp.put("entityName", attr.getProperty());
		resp.put("entityId", attr.getId());
		resp.put("displayName", attr.getColumnName());
		resp.put("entityFullName", attr.getType());
		resp.put("isKey", "id".equals(attr.getProperty()));
		resp.put("key", attr.getId());
		resp.put("parentEntityId", attr.getCustomTableId());
		resp.put("dataFormat", "");
		resp.put("sourceType", attr.getProperty());
		resp.put("type", "attr");
	}

	@Override
	public JSONObject findPrintContent(String appCode, Boolean isBpm, String qrcode) {
		JSONObject resp = new JSONObject();
		JSONObject content = new JSONObject();
		JSONObject bo = new JSONObject();

		//根据应用编号查询应用
		CustomAppEntity app = customAppService.queryCustomAppByCode(appCode);

		QueryWrapper<CustomTableEntity> mainWrapper = new QueryWrapper<>();
		mainWrapper.eq("app_id", app.getId());
		mainWrapper.eq("dr", 0);
		mainWrapper.isNull("parent_id");
		List<CustomTableEntity> mainCustomTableEntities = customTableService.list(mainWrapper);
		if(mainCustomTableEntities!=null&&mainCustomTableEntities.size()>0){
			CustomTableEntity customTable = mainCustomTableEntities.get(0);
			JSONArray subBos = new JSONArray();
			bo.put("bo_code", appCode);
			bo.put("bo_name", app.getAppName());
			bo.put("key", customTable.getId());
			JSONArray mainAttrs = new JSONArray();

			QueryWrapper<CustomColumnEntity> mainColumnWrapper = new QueryWrapper<>();
			mainColumnWrapper.eq("custom_table_id", customTable.getId());
			mainColumnWrapper.eq("dr", 0);
			//2、根据主表查询主表字段
			List<CustomColumnEntity> mainColumnList = customColumnService.list(mainColumnWrapper);
			if(CollectionUtils.isNotEmpty(mainColumnList)) {
				for(CustomColumnEntity entity : mainColumnList){
					JSONObject attr = new JSONObject();
					translatePrintAttrInfo(entity,attr);
					mainAttrs.add(attr);
				}
			}
			bo.put("bo_attrs", mainAttrs);
			
			if(isBpm){
				//有审批打印
				JSONObject bpm = new JSONObject();
				bpm.put("bo_code", "ApproveInfo");
				bpm.put("bo_name", "审批信息");
				JSONArray bpmAttrs = new JSONArray();
				addPrintBpmAttrInfo("approveNode","流程环节名称",bpmAttrs);
				addPrintBpmAttrInfo("approver","审批人",bpmAttrs);
				addPrintBpmAttrInfo("approvalOutcome","审批结果",bpmAttrs);
				addPrintBpmAttrInfo("processTime","审批时间",bpmAttrs);
				addPrintBpmAttrInfo("organiser","发起人",bpmAttrs);
				addPrintBpmAttrInfo("startTime","发起时间",bpmAttrs);
				addPrintBpmAttrInfo("approveInfo","审批意见",bpmAttrs);
				addPrintBpmAttrInfo("approveTimes","发起次数",bpmAttrs);
				bpm.put("bo_attrs", bpmAttrs);
				subBos.add(bpm);
			}
			
			//查询子表信息
			QueryWrapper<CustomTableEntity> childWrapper = new QueryWrapper<>();
			childWrapper.eq("app_id", app.getId());
			childWrapper.eq("dr", 0);
			childWrapper.eq("parent_id", customTable.getId());
			List<CustomTableEntity> childCustomTableEntities = customTableService.list(childWrapper);

			if(CollectionUtils.isNotEmpty(childCustomTableEntities)) {
				for(CustomTableEntity cls : childCustomTableEntities) {
					JSONObject childJson = new JSONObject();
					childJson.put("bo_code", cls.getUiKey());
					childJson.put("bo_name", cls.getTableName());
					childJson.put("key", cls.getId());
					JSONArray childAttrs = new JSONArray();

					QueryWrapper<CustomColumnEntity> childColumnWrapper = new QueryWrapper<>();
					childColumnWrapper.eq("custom_table_id", cls.getId());
					childColumnWrapper.eq("dr", 0);
					//2、根据主表查询主表字段
					List<CustomColumnEntity> childColumnList = customColumnService.list(childColumnWrapper);
					if(CollectionUtils.isNotEmpty(childColumnList)) {
						for(CustomColumnEntity entity : childColumnList){
							JSONObject attr = new JSONObject();
							translatePrintAttrInfo(entity,attr);
							childAttrs.add(attr);
						}
					}
					childJson.put("bo_attrs", childAttrs);
					subBos.add(childJson);//添加子表信息
				}
			}
			bo.put("sub_bos", subBos);
		}

		content.put("bo", bo);
		resp.put("boCode", appCode);
		resp.put("content", content.toJSONString());
		resp.put("qrcode", qrcode);
		return resp;
	}

	/**
	 * 从属性实体中抽取打印元数据需要的属性字段
	 *
	 * @param attr
	 * @param resp
	 */
	private void translatePrintAttrInfo(CustomColumnEntity attr, JSONObject resp) {
		resp.put("code", attr.getProperty());
		resp.put("fieldname", attr.getProperty());
		resp.put("typename", attr.getProperty());
		resp.put("name", attr.getColumnName());
		resp.put("fieldtype", attr.getType().contains("date")?"string":attr.getType());
		resp.put("key", attr.getId());
		resp.put("type", "attr");
		resp.put("dataFormat", "");
		resp.put("sourceType", attr.getProperty());
		resp.put("isPrimary", "id".equals(attr.getProperty())?1:0);
	}

	/**
	 * 从属性实体中抽取打印元数据需要的属性字段
	 *
	 * @param attr
	 * @param resp
	 */
	private void addPrintBpmAttrInfo(String code, String name,JSONArray bpmAttrs) {
		JSONObject attr = new JSONObject();
		attr.put("code", code);
		attr.put("fieldname", code);
		attr.put("typename", code);
		attr.put("name", name);
		attr.put("fieldtype", "VARCHAR");
		attr.put("isPrimary", "approveNode".equals(code)?1:0);
		bpmAttrs.add(attr);
	}
}
