/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cust.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.cust.bean.BusinessTableEntity;
import com.ejianc.foundation.cust.mapper.BusinessTableMapper;
import com.ejianc.foundation.cust.service.IBusinessTableService;
import com.ejianc.foundation.cust.util.BusinessTableCacheUtil;
import com.ejianc.foundation.cust.util.TableOperator;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bus/businessTable/"})
public class BusinessTableController {
    @Autowired
    private IBusinessTableService businessTableService;
    @Autowired
    private BusinessTableMapper businessTableMapper;

    @RequestMapping(value={"/pageList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BusinessTableEntity>> pageList(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        LinkedHashMap order = queryParam.getOrderMap();
        order.put("createTime", "desc");
        IPage pageData = this.businessTableService.queryPage(queryParam, false);
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"save"})
    public CommonResponse<String> save(@RequestBody BusinessTableEntity businessTableEntity) {
        this.businessTableService.saveBusinessTable(businessTableEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"getObject"})
    public CommonResponse<BusinessTableEntity> getObject(HttpServletRequest request) {
        String id = request.getParameter("id");
        String key = request.getParameter("key");
        String fill = request.getParameter("fill");
        BusinessTableEntity table = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            table = (BusinessTableEntity)((Object)this.businessTableService.getById((Serializable)((Object)id)));
        } else if (StringUtils.isNotBlank((CharSequence)key)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"unique_key", (Object)key);
            table = (BusinessTableEntity)((Object)this.businessTableService.getOne((Wrapper)queryWrapper));
        }
        if ("1".equals(fill) && table != null) {
            table = this.businessTableService.getFilledByKey(table.getUniqueKey());
        }
        return CommonResponse.success((Object)((Object)table));
    }

    @RequestMapping(value={"createTable"})
    public CommonResponse<String> createTable(HttpServletRequest request) {
        String id = request.getParameter("id");
        BusinessTableEntity businessTable = (BusinessTableEntity)((Object)this.businessTableService.getById((Serializable)((Object)id)));
        businessTable = this.businessTableService.getFilledByKey(businessTable.getUniqueKey());
        TableOperator tableOperate = new TableOperator(this.businessTableMapper, businessTable);
        tableOperate.createTable();
        businessTable.setCreatedTable(true);
        BusinessTableCacheUtil.put(businessTable);
        return CommonResponse.success((String)"\u5efa\u8868\u6210\u529f");
    }

    @RequestMapping(value={"cleanCache"})
    public CommonResponse<String> cleanCache(HttpServletRequest request) {
        BusinessTableCacheUtil.clean();
        return CommonResponse.success((String)"\u6e05\u7406\u6210\u529f");
    }

    @RequestMapping(value={"remove"})
    public CommonResponse<String> remove(@RequestParam String id) {
        this.businessTableService.removeTableByPkId(id);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }
}

