/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cust.generator;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.cust.bean.BusinessColumnEntity;
import com.ejianc.foundation.cust.bean.BusinessTableRel;
import com.ejianc.foundation.cust.bean.model.FormColumn;
import com.ejianc.foundation.cust.bean.model.FormGroup;
import com.ejianc.foundation.cust.constant.BusColumnCtrlType;
import com.ejianc.foundation.cust.util.BusTableRelType;
import com.ejianc.foundation.cust.util.ThreadMapUtil;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsFormElementGenerator {
    protected Logger LOG = LoggerFactory.getLogger(this.getClass());

    public abstract String getGeneratorName();

    public String getColumn(BusinessColumnEntity column, BusinessTableRel relation) {
        if (column == null) {
            throw new BusinessException(String.format("%s \u751f\u6210\u8868\u5355\u5f02\u5e38\uff0ccolumn \u4e3a null", relation != null ? relation.getTableComment() : ""));
        }
        String boCode = relation.getBusObj().getUniqueKey();
        ThreadMapUtil.put("boCode", boCode);
        ThreadMapUtil.put("relation", relation);
        if (column.getCtrl() == null) {
            this.LOG.debug(" column [{}]ctrl \u914d\u7f6e\u4e3a\u7a7a\uff0c\u9ed8\u8ba4\u751f\u6210 input\u6846\uff0c\u8868\uff1a{}", (Object)column.getComment(), (Object)column.getTable().getComment());
            return this.getColumnOnetext(column);
        }
        BusColumnCtrlType columnType = BusColumnCtrlType.getByKey(column.getCtrl().getType());
        try {
            switch (columnType) {
                case ONETEXT: {
                    return this.getColumnOnetext(column);
                }
                case DATE: {
                    return this.getColumnDate(column);
                }
                case DIC: {
                    return this.getColumnDic(column);
                }
                case SERIALNO: {
                    return this.getColumnIdentity(column);
                }
                case MULTITEXT: {
                    return this.getColumnMultitext(column);
                }
                case CHECKBOX: {
                    return this.getColumnCheckBox(column);
                }
                case RADIO: {
                    return this.getColumnRadio(column);
                }
                case SELECT: {
                    return this.getColumnSelect(column, false);
                }
                case FILE: {
                    return this.getColumnFile(column);
                }
            }
            return "";
        }
        catch (Exception e) {
            throw new BusinessException(String.format("\u8868\u5355\u5b57\u6bb5 [%s-%s]\u89e3\u6790\u5931\u8d25 ,\u63a7\u4ef6\u7c7b\u578b[%s] :%s", column.getTable().getName(), column.getComment(), columnType.getDesc(), e.getMessage()), (Throwable)e);
        }
    }

    public String getColumn(FormGroup group, FormColumn formColumn) {
        BusinessColumnEntity businessColumn;
        BusinessTableRel table;
        BusinessTableRel tableRel = group.getTableRelation();
        if (StringUtils.isNotEmpty((String)formColumn.getTableKey()) && !formColumn.getTableKey().equals(tableRel.getTableKey()) && (table = tableRel.find(formColumn.getTableKey())) != null) {
            tableRel = table;
        }
        if (!formColumn.getTableKey().equals(tableRel.getTableKey())) {
            this.LOG.error("\u751f\u6210\u8868\u5355\u53ef\u80fd\u5b58\u5728\u5f02\u5e38\uff01formColumnTableKey{},tableRelTableKey{}", (Object)formColumn.getTableKey(), (Object)tableRel.getTableKey());
        }
        if ((businessColumn = tableRel.getTable().getColumnByKey(formColumn.getKey())) == null) {
            this.LOG.error("\u5e03\u5c40\u6a21\u677f\u67e5\u627eColumn\u914d\u7f6e\u5931\u8d25\uff01\u5b57\u6bb5\uff1a{}\uff0c\u8868\uff1a{}", (Object)formColumn.getComment(), (Object)formColumn.getTableKey());
        }
        return this.getColumn(businessColumn, tableRel);
    }

    protected abstract String getColumnOnetext(BusinessColumnEntity var1);

    protected abstract String getColumnDate(BusinessColumnEntity var1);

    protected abstract String getColumnDic(BusinessColumnEntity var1);

    protected abstract String getColumnIdentity(BusinessColumnEntity var1);

    protected abstract String getColumnMultitext(BusinessColumnEntity var1);

    protected abstract String getColumnCheckBox(BusinessColumnEntity var1);

    protected abstract String getColumnRadio(BusinessColumnEntity var1);

    protected abstract String getColumnSelect(BusinessColumnEntity var1, Boolean var2);

    protected abstract String getColumnFile(BusinessColumnEntity var1);

    protected Element getElement(String type) {
        Document doc = Jsoup.parse((String)"");
        Element element = doc.createElement(type);
        return element;
    }

    protected void handlePermission(Element element, BusinessColumnEntity column) {
        element.attr("ab-basic-permission", this.getPermissionPath(column));
        element.attr("desc", column.getComment());
    }

    public String getPermissionPath(BusinessColumnEntity column, BusinessTableRel relation) {
        String boCode = relation.getBusObj().getUniqueKey();
        return "permission." + boCode + "." + column.getTable().getUniqueKey() + "." + column.getUniqueKey();
    }

    protected String getPermissionPath(BusinessColumnEntity column) {
        String boCode = (String)ThreadMapUtil.get("boCode");
        return "permission." + boCode + "." + column.getTable().getUniqueKey() + "." + column.getUniqueKey();
    }

    protected void handleValidateRules(Element element, BusinessColumnEntity column) {
        if (column.getCtrl() == null) {
            element.attr("ab-validate", "{}");
            return;
        }
        String rulesStr = column.getCtrl().getValidRule();
        JSONObject validateRule = new JSONObject();
        if (StringUtils.isNotEmpty((String)rulesStr)) {
            JSONArray rules = JSONArray.parseArray((String)rulesStr);
            for (int i = 0; i < rules.size(); ++i) {
                JSONObject rule = rules.getJSONObject(i);
                validateRule.put(rule.getString("name"), (Object)true);
            }
            if (1 == column.getRequired()) {
                validateRule.put("required", (Object)true);
            }
            if (column.getColLength() > 1) {
                validateRule.put("maxlength", (Object)column.getColLength());
            }
        }
        element.attr("ab-validate", validateRule.toJSONString());
        BusinessTableRel relation = (BusinessTableRel)ThreadMapUtil.get("relation");
        element.attr("desc", relation.getTableComment() + "-" + column.getComment());
    }

    public String getScopePath(BusinessTableRel relation) {
        if (relation.getType().equals(BusTableRelType.MAIN.getKey())) {
            return "data." + relation.getBusObj().getUniqueKey();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(relation.getTableKey());
        if (relation.getType().equals(BusTableRelType.ONE_TO_MANY.getKey())) {
            sb.append("List");
            if (this.isThreeChildren(relation)) {
                sb.insert(0, "subTempData.");
                return sb.toString();
            }
        }
        this.getParentPath(relation.getParent(), sb);
        return sb.toString();
    }

    protected void getParentPath(BusinessTableRel parent, StringBuilder sb) {
        if (parent == null) {
            return;
        }
        if (parent.getType().equals(BusTableRelType.ONE_TO_MANY.getKey())) {
            sb.insert(0, parent.getTableKey() + ".");
            return;
        }
        if (parent.getType().equals(BusTableRelType.ONE_TO_ONE.getKey())) {
            sb.insert(0, parent.getTableKey() + ".");
        }
        if (parent.getType().equals(BusTableRelType.MAIN.getKey())) {
            sb.insert(0, "data." + parent.getBusObj().getUniqueKey() + ".");
        }
        this.getParentPath(parent.getParent(), sb);
    }

    public abstract String getSubAttrs(BusinessTableRel var1);

    public boolean isThreeChildren(BusinessTableRel rel) {
        return rel.getType().equals(BusTableRelType.ONE_TO_MANY.getKey()) && !rel.getParent().getType().equals(BusTableRelType.MAIN.getKey());
    }

    public String getDivVIf(BusinessTableRel relation) {
        if (this.isThreeChildren(relation)) {
            return "v-if=\"subTempData." + relation.getParent().getTableKey() + "\"";
        }
        return "";
    }

    protected void handleElementPlaceHolder(BusinessColumnEntity column, Element element) {
        if (column.getCtrl() == null) {
            return;
        }
        String configStr = column.getCtrl().getConfig();
        if (StringUtils.isEmpty((String)configStr)) {
            return;
        }
        JSONObject config = JSON.parseObject((String)configStr);
        Boolean placeholder = config.getBoolean("placeholder");
        if (placeholder == null || !placeholder.booleanValue()) {
            return;
        }
        element.attr("placeholder", config.getString("placeholderText"));
    }
}

