package com.ejianc.foundation.cfs.controller;

import java.io.Serializable;
import java.util.*;

import com.alibaba.fastjson.JSONArray;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.foundation.cfs.vo.CustomColumnVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@RestController
@RequestMapping("custom/column")
public class CustomColumnController implements Serializable {

	private static final long serialVersionUID = -2549939173725536626L;

    @Autowired
    private ICustomColumnService customColumnService; 
    @Autowired
    private ICustomTableService customTableService;
    
    @RequestMapping(value = "queryRefList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CustomColumnVO>> queryRefList(
    		@RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
    		@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition
    		, @RequestParam(required=false) String searchObject) {
    	IPage<CustomColumnVO> pageData = new Page<>(pageNumber, pageSize,0);
    	Long appId = null;
    	if(StringUtils.isNotBlank(condition)){
    		JSONObject json = JSONObject.parseObject(condition);
    		if(json.get("appId")!=null){
    			appId = Long.parseLong(json.get("appId").toString());
    		}else {
                return CommonResponse.error("condition条件缺少appId！");
            }
    	}else {
    	    return CommonResponse.error("缺少condition条件");
        }
    	QueryParam param = new QueryParam();
    	if(StringUtils.isNotBlank(searchObject)){
    		JSONObject search = JSONObject.parseObject(searchObject);
    		for(String key : search.keySet()){
    			param.getParams().put(key,new Parameter(QueryParam.LIKE,search.get(key).toString()));
    		}
    	}
    	param.setPageSize(pageSize);
    	param.setPageIndex(pageNumber);
        if(StringUtils.isNotBlank(searchText)){
        	param.setSearchText(searchText);
            /** 模糊搜索配置字段示例 */
            List<String> fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("columnName");
            fuzzyFields.add("property");
        }
		//根据appid查询table信息
        Map<String, Object> columnMap = new HashMap<>();
        columnMap.put("app_id", appId);
        columnMap.put("parent_id", null);
        List<CustomTableEntity> tableList = (List<CustomTableEntity>) customTableService.listByMap(columnMap);
        if(tableList!=null&&tableList.size()>0){
            //根据tableId查询列表项
        	Long tableId = tableList.get(0).getId();
            param.getParams().put("customTableId",new Parameter(QueryParam.EQ,tableId));
            param.getOrderMap().put("sequence",QueryParam.DESC);
        	IPage<CustomColumnEntity> page = customColumnService.queryPage(param,false);
        	pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
      		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CustomColumnVO.class));
            return CommonResponse.success(pageData);
        }else{
            return CommonResponse.success(pageData);
        }
        
    }


    /**
     * @Author mrsir_wxp
     * @Date 2021/1/5 查询子表字段参照
     * @Description queryCFSRefList
     * @Param [pageNumber, pageSize, searchText, appId, uiKey]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage<com.ejianc.foundation.cfs.vo.CustomColumnVO>>
     */
    @RequestMapping(value = "queryCFSRefList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CustomColumnVO>> queryCFSRefList(
    		@RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = "10") int pageSize,
    		@RequestParam(required=false) String searchText, @RequestParam(required=false) String condition ) {
    	if(StringUtils.isBlank(condition)){
			return CommonResponse.error("缺少条件！");
		}
		Long appId = JSONObject.parseObject(condition).getLong("appId");
		String uiKey = JSONObject.parseObject(condition).getString("uiKey");
		if(appId == null || StringUtils.isBlank(uiKey)){
			return CommonResponse.error("缺少条件！");
		}
    	QueryParam param = new QueryParam();
		param.getParams().put("appId",new Parameter(QueryParam.EQ,appId));
		param.getParams().put("uiKey",new Parameter(QueryParam.EQ,uiKey));
		List<CustomTableEntity> list =  customTableService.queryList(param,false);
    	if(ListUtil.isEmpty(list)){
			return CommonResponse.error("查无数据！");
		}
		CustomTableEntity customTableEntity = list.get(0);
		//根据tableId查询列表项
		Long tableId = customTableEntity.getId();
		param = new QueryParam();
    	param.setPageIndex(pageNumber);
		param.setPageSize(pageSize);
		if(StringUtils.isNotBlank(searchText)){
        	param.setSearchText(searchText);
            /** 模糊搜索配置字段示例 */
            List<String> fuzzyFields = param.getFuzzyFields();
            fuzzyFields.add("columnName");
            fuzzyFields.add("property");
        }
		param.getOrderMap().put("sequence",QueryParam.DESC);
		param.getParams().put("customTableId",new Parameter(QueryParam.EQ,tableId));
		IPage<CustomColumnEntity> page = customColumnService.queryPage(param,false);
		IPage<CustomColumnVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CustomColumnVO.class));
		return CommonResponse.success(pageData);
    }

	/**
	 * 查询打印使用的业务对象信息树
	 *
	 * @param appCode
	 * @return
	 */
	@GetMapping("/getEntityDetailTree")
	@ResponseBody
	public CommonResponse<JSONObject> findEntityDetailForPrint(@RequestParam String appCode) {
		JSONObject resp = new JSONObject();
		resp = customColumnService.getEntityDetailTree(appCode);
		if(resp.isEmpty()) {
			return CommonResponse.success("打印元数据实体查询失败，实体不存在");
		} else {
			return CommonResponse.success("打印元数据实体查询成功", resp);
		}
	}

	/**
	 * 查询打印使用的业务对象信息树(项目datav使用)
	 *
	 * @param appId
	 * @return
	 */
	@GetMapping("/getEntityDetailTreeByAppId")
	@ResponseBody
	public CommonResponse<JSONArray> getEntityDetailTreeByAppId(@RequestParam Long appId) {
		JSONArray resp = new JSONArray();
		JSONObject entity = new JSONObject();
		JSONObject detail = customColumnService.getEntityDetailTreeByAppId(appId);

		entity.put("title", detail.getString("displayName"));
		entity.put("fieldText", detail.getString("displayName"));
		entity.put("id", detail.getString("key"));
		entity.put("type", 0);
		entity.put("code", detail.getString("entityName"));
		entity.put("isList", "1");
		entity.put("expand", true);
		entity.put("dataFormat", null);

		List<JSONObject> attrs = (List<JSONObject>) detail.get("attrs");
		if(CollectionUtils.isNotEmpty(attrs)) {
			List<JSONObject> children = new ArrayList<>();
			for(JSONObject attr : attrs) {
				JSONObject attrJson = new JSONObject();
				attrJson.put("id", attr.getString("key"));
				attrJson.put("title", attr.getString("displayName"));
				attrJson.put("fieldText", attr.getString("displayName"));
				attrJson.put("code", attr.getString("entityName"));
				attrJson.put("type", 0);
				attrJson.put("isList", "1");
				attrJson.put("expand", true);
				attrJson.put("dataFormat", attr.getString("dataFormat"));
				children.add(attrJson);
			}
			entity.put("children", children);
		}
		resp.add(entity);

		if(resp.isEmpty()) {
			return CommonResponse.success("打印元数据实体查询失败，实体不存在");
		} else {
			return CommonResponse.success("打印元数据实体查询成功", resp);
		}
	}

	/**
	 * 查询打印模板使用的内容信息---直接获取
	 *
	 * @param appCode
	 * @return
	 */
	@GetMapping("/findPrintContent")
	@ResponseBody
	public CommonResponse<JSONObject> findPrintContent(@RequestParam String appCode,
			@RequestParam(defaultValue = "false") Boolean isBpm,@RequestParam(defaultValue = "") String qrcode) {
		JSONObject resp = new JSONObject();
		resp = customColumnService.findPrintContent(appCode,isBpm,qrcode);
		if(resp.isEmpty()) {
			return CommonResponse.success("打印模板数据查询失败，数据不存在");
		} else {
			return CommonResponse.success("打印模板数据查询成功", resp);
		}
	}
}
