package com.ejianc.foundation.cfs.service.impl;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.bpm.vo.BpmApproveHistoryInfo;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomListEntity;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomListService;
import com.ejianc.foundation.cfs.util.BillStateEnum;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.mapper.CustomTableMapper;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomTableServiceImpl extends BaseServiceImpl<CustomTableMapper, CustomTableEntity> implements ICustomTableService {
	private Logger logger = LoggerFactory.getLogger(getClass());

	private final static String ID = "id";
	private final static String DEL = "del";
	private final static String PID = "pid";
	private final static String ORG_ID = "orgId";
	private final static String CREATE_USER = "createUser";
	private final static String CREATE_TIME = "createTime";
	private final static String BILL_STATE = "billState";
	private final static Integer QUERY_TIMEOUT = 60;

	@Autowired
	private IBpmApi bpmApi;
	@Autowired
	private CustomTableMapper customTableMapper;
	@Autowired
	private ICustomAppService customAppService;
	@Autowired
	private ICustomColumnService customColumnService;
	@Autowired
	private RestHighLevelClient client;
	@Autowired
	private ICustomListService customListService;
	
	@Override
	public void deleteCustomTable(Long mainFormId) {
		customTableMapper.deleteCustomTable(mainFormId);
	}

	@Override
	public CustomTableEntity queryMainTableByAppId(Long appId) {
		CustomTableEntity customTableEntity = customTableMapper.queryMainTableByAppId(appId);
		return customTableEntity;
	}

	@Override
	public List<CustomTableEntity> queryChildTablesByMainTableId(Long mainTableId) {
		QueryWrapper<CustomTableEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("parent_id", mainTableId);
		List<CustomTableEntity> childTableEntities = customTableMapper.selectList(queryWrapper);
		return childTableEntities;
	}

	@Override
	public CommonResponse<JSONObject> queryDetail(String pageCode, Long id) throws IOException {
		//根据应用编号查询应用
		CustomAppEntity app = customAppService.queryCustomAppByCode(pageCode);
		//根据appid查询主表信息
		CustomTableEntity mainTableEntity = this.queryMainTableByAppId(app.getId());

		GetRequest getRequest = new GetRequest(mainTableEntity.getTableName(), id.toString());
		GetResponse mainResponse = client.get(getRequest, RequestOptions.DEFAULT);
		if(mainResponse.isExists()) {
			String dataStr = mainResponse.getSourceAsString();

			if(StringUtils.isNotBlank(dataStr)) {
				JSONObject mainDetail = JSON.parseObject(dataStr);

				//查询子表
				List<CustomTableEntity> childTableEntities = this.queryChildTablesByMainTableId(mainTableEntity.getId());
				if(childTableEntities != null && childTableEntities.size() > 0) {
					for(CustomTableEntity childTableEntity:childTableEntities) {
						JSONArray subTbsData = new JSONArray();
						BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
						boolQueryBuilder.must(QueryBuilders.termQuery(PID, mainDetail.get(ID)));

						SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
						sourceBuilder.query(boolQueryBuilder);
						sourceBuilder.sort(new FieldSortBuilder("rowIndex").order(SortOrder.ASC));
						sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间

						SearchRequest searchRequest = new SearchRequest(childTableEntity.getTableName());
						searchRequest.source(sourceBuilder);
						try {
							SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
							SearchHits hits = response.getHits();
							for (SearchHit hit : hits) {
								String sourceAsString = hit.getSourceAsString();
								mainDetail.put(childTableEntity.getUiKey(), JSON.parse(sourceAsString));
								subTbsData.add(JSON.parse(sourceAsString));
							}
							mainDetail.put(childTableEntity.getUiKey(), subTbsData);
						} catch (IOException e) {
							try { //报IOException时， 重试一次
								SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
								SearchHits hits = response.getHits();
								for (SearchHit hit : hits) {
									String sourceAsString = hit.getSourceAsString();
									subTbsData.add(JSON.parse(sourceAsString));
								}
								mainDetail.put(childTableEntity.getUiKey(), subTbsData);
							} catch(IOException e1) {
								e1.printStackTrace();
								throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG："+e1.getMessage());
							}
						}
					}
				}
				return CommonResponse.success(mainDetail);
			}
		}
		return CommonResponse.error("查询失败:数据已删除或不存在！");
	}

	@Override
	public CommonResponse<JSONObject> queryPrintDetail(String pageCode, Long id) throws IOException {
		//根据应用编号查询应用
		CustomAppEntity app = customAppService.queryCustomAppByCode(pageCode);
		//根据appid查询主表信息
		CustomTableEntity mainTableEntity = this.queryMainTableByAppId(app.getId());
		/** 主表字段 */
		List<CustomColumnEntity> mainCols = customColumnService.queryColumnsByTableId(mainTableEntity.getId());

		GetRequest getRequest = new GetRequest(mainTableEntity.getTableName(), id.toString());
		GetResponse mainResponse = client.get(getRequest, RequestOptions.DEFAULT);
		if(mainResponse.isExists()) {
			String dataStr = mainResponse.getSourceAsString();
			if(StringUtils.isNotBlank(dataStr)) {
				JSONObject mainDetail = JSON.parseObject(dataStr);
				for (CustomColumnEntity col:mainCols){
					if("refer".equals(col.getType())){
						if(StringUtils.isNotEmpty(mainDetail.getString(col.getProperty()))){
							mainDetail.put(col.getProperty(),JSONObject.parseObject(mainDetail.getString(col.getProperty())).getString("name"));
						}
					}
					if("select".equals(col.getType())){
						if(StringUtils.isNotEmpty(mainDetail.getString(col.getProperty()))){
							mainDetail.put(col.getProperty(),JSONObject.parseObject(mainDetail.getString(col.getProperty())).getString("text"));
						}
					}
					if("billState".equals(col.getProperty())){
						if(StringUtils.isNotEmpty(mainDetail.getString(col.getProperty()))){
							mainDetail.put(col.getProperty(), BillStateEnum.getEnumByStateCode(mainDetail.getInteger(col.getProperty())).getDescription());
						}
					}
					if("integer".equals(col.getType()) && !"billState".equals(col.getProperty())){
						String[] names = StringUtils.isNotEmpty(col.getVal())?col.getVal().split(","):new String[]{"是","否"};
						if("1".equals(mainDetail.getString(col.getProperty()))){
							mainDetail.put(col.getProperty(),names[0]);
						}else {
							mainDetail.put(col.getProperty(),names[1]);
						}
					}
				}
				//查询子表
				List<CustomTableEntity> childTableEntities = this.queryChildTablesByMainTableId(mainTableEntity.getId());
				if(childTableEntities != null && childTableEntities.size() > 0) {
					for(CustomTableEntity childTableEntity:childTableEntities) {
						/** 子表字段 */
						List<CustomColumnEntity> subCols = customColumnService.queryColumnsByTableId(childTableEntity.getId());

						JSONArray subTbsData = new JSONArray();
						BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
						boolQueryBuilder.must(QueryBuilders.termQuery(PID, mainDetail.get(ID)));

						SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
						sourceBuilder.query(boolQueryBuilder);
						sourceBuilder.timeout(new TimeValue(QUERY_TIMEOUT, TimeUnit.SECONDS)); //设置超时时间

						SearchRequest searchRequest = new SearchRequest(childTableEntity.getTableName());
						searchRequest.source(sourceBuilder);
						try {
							SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
							SearchHits hits = response.getHits();
							for (SearchHit hit : hits) {
								String sourceAsString = hit.getSourceAsString();
								JSONObject subDetail = JSON.parseObject(sourceAsString);
								for (CustomColumnEntity col:subCols){
									if("refer".equals(col.getType())){
										if(StringUtils.isNotEmpty(subDetail.getString(col.getProperty()))){
											subDetail.put(col.getProperty(),JSONObject.parseObject(subDetail.getString(col.getProperty())).getString("name"));
										}
									}
									if("select".equals(col.getType())){
										if(StringUtils.isNotEmpty(subDetail.getString(col.getProperty()))){
											subDetail.put(col.getProperty(),JSONObject.parseObject(subDetail.getString(col.getProperty())).getString("text"));
										}
									}
									if("integer".equals(col.getType())){
										String[] names = StringUtils.isNotEmpty(col.getVal())?col.getVal().split(","):new String[]{"是","否"};
										if("1".equals(subDetail.getString(col.getProperty()))){
											subDetail.put(col.getProperty(),names[0]);
										}else {
											subDetail.put(col.getProperty(),names[1]);
										}
									}
								}
								subTbsData.add(subDetail);
							}
							mainDetail.put(childTableEntity.getUiKey(), subTbsData);
						} catch (IOException e) {
							try { //报IOException时， 重试一次
								SearchResponse response = client.search(searchRequest, RequestOptions.DEFAULT);
								SearchHits hits = response.getHits();
								for (SearchHit hit : hits) {

									String sourceAsString = hit.getSourceAsString();
									JSONObject subDetail = JSON.parseObject(sourceAsString);
									for (CustomColumnEntity col:subCols){
										if("refer".equals(col.getType())){
											if(StringUtils.isNotEmpty(subDetail.getString(col.getProperty()))){
												subDetail.put(col.getProperty(),JSONObject.parseObject(subDetail.getString(col.getProperty())).getString("name"));
											}
										}
										if("select".equals(col.getType())){
											if(StringUtils.isNotEmpty(subDetail.getString(col.getProperty()))){
												subDetail.put(col.getProperty(),JSONObject.parseObject(subDetail.getString(col.getProperty())).getString("text"));
											}
										}
										if("integer".equals(col.getType())){
											String[] names = StringUtils.isNotEmpty(col.getVal())?col.getVal().split(","):new String[]{"是","否"};
											if("1".equals(subDetail.getString(col.getProperty()))){
												subDetail.put(col.getProperty(),names[0]);
											}else {
												subDetail.put(col.getProperty(),names[1]);
											}
										}
									}
									subTbsData.add(subDetail);
								}
								mainDetail.put(childTableEntity.getUiKey(), subTbsData);
							} catch(IOException e1) {
								e1.printStackTrace();
								throw new BusinessException("根据 parammap 条件，查询全部记录索引失败，MSG："+e1.getMessage());
							}
						}
					}
				}

				//自由态，直接提交，审批不通过---不查询审批历史
				CommonResponse<List<BpmApproveHistoryInfo>> approveList = bpmApi.queryHistoryById(id);
				mainDetail.put("ApproveInfo", approveList.getData());

				return CommonResponse.success(mainDetail);
			}
		}
		return CommonResponse.error("查询失败:数据已删除或不存在！");
	}

	@Override
	@Transactional
	public void clearCustomTable(Long appId) {
		QueryWrapper<CustomTableEntity> childWrapper = new QueryWrapper<>();
		childWrapper.eq("app_id", appId);
		List<CustomTableEntity> childCustomTableEntities = this.list(childWrapper);

		if(childCustomTableEntities != null && childCustomTableEntities.size() > 0) {
			for(int i=0; i<childCustomTableEntities.size(); i++) {
				CustomTableEntity childCustomTableEntity = childCustomTableEntities.get(i);
				this.deleteCustomTable(childCustomTableEntity.getId());
				customColumnService.deleteCustomColumnByTableId(childCustomTableEntity.getId());
				try {
					GetIndexRequest request = new GetIndexRequest(childCustomTableEntity.getTableName());
					boolean exists = client.indices().exists(request, RequestOptions.DEFAULT);
					if(exists){
						DeleteIndexRequest childDeleteIndexRequest = new DeleteIndexRequest(childCustomTableEntity.getTableName());
						try {
							client.indices().delete(childDeleteIndexRequest, RequestOptions.DEFAULT);
						}catch (IOException ee){
							client.indices().delete(childDeleteIndexRequest, RequestOptions.DEFAULT);
							logger.error("删除es库出错！"+ee.getMessage());
						}
					}
				}catch (IOException e){
					logger.error("删除es库出错！-- "+e.getMessage());
				}
			}
		}
		QueryWrapper<CustomListEntity> lw = new QueryWrapper<>();
		lw.eq("app_id", appId);
		List<CustomListEntity> listEntities = customListService.list(lw);
		if(ListUtil.isNotEmpty(listEntities)){
			customListService.removeByIds(listEntities.stream().map(CustomListEntity::getId).collect(Collectors.toList()));
		}
	}

}
