package com.ejianc.foundation.cust.bean.model;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import com.ejianc.foundation.cust.bean.BusinessTableRel;

public class FormGroup {
	private String comment;
	private String key;
	private BusinessTableRel tableRelation;
	private List<FormColumn> columnList;
	
	public boolean hasTitle() {
		return StringUtils.isNotEmpty(comment);
	}
	
	/**
	 * 获取当前组一对一子表的一对多子表。 一对一的一对一暂不支持吧。后面在写递归
	 * @return
	 */
	public List<BusinessTableRel> getOne2OneChildsOne2ManyRelations(){
		List<BusinessTableRel> grandson = new ArrayList<BusinessTableRel>();
		// 获取一对一子表
		tableRelation.getChildren("oneToOne").forEach(one2One->{
			grandson.addAll(one2One.getChildren("oneToMany"));
		});
		return grandson;
	}
	
	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public List<FormColumn> getColumnList() {
		return columnList;
	}

	public BusinessTableRel getTableRelation() {
		return tableRelation;
	}

	public void setTableRelation(BusinessTableRel tableRelation) {
		this.tableRelation = tableRelation;
	}

	public void setColumnList(List<FormColumn> columnList) {
		this.columnList = columnList;
	}

}
