package com.ejianc.foundation.cust.controller;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.cust.bean.BusinessFormdefEntity;
import com.ejianc.foundation.cust.service.IBusinessFormdefService;
import com.ejianc.foundation.cust.service.IBusinessObjectService;
import com.ejianc.foundation.cust.service.IFormTemplateService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@RestController
@RequestMapping("/form/formDef/")
public class BusinessFormDefController {
	
	@Autowired
	private IBusinessFormdefService businessFormdefService;
	@Autowired
	private IBusinessObjectService businessObjectService;
	@Autowired
	private IFormTemplateService formTemplateService;
	
	/**
	 * 
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<BusinessFormdefEntity>> pageList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		Map<String, String> order = queryParam.getOrderMap();
		order.put("createTime", "desc");
		IPage<BusinessFormdefEntity> pageData = businessFormdefService.queryPage(queryParam, false);
		return CommonResponse.success(pageData);
	}
	
	
	/**
	 * 保存/修改
	 * 
	 * @param businessFormdefEntity
	 * @return
	 */
	@RequestMapping("save")
	public CommonResponse<String> save(@RequestBody BusinessFormdefEntity businessFormdefEntity) {
		if(StringUtils.isBlank(businessFormdefEntity.getUniqueKey()) && businessFormdefService.getByKey(businessFormdefEntity.getUniqueKey()) != null) {
			throw new BusinessException("表单 KEY 已经存在，请修改表单 KEY 的值");
		}
		businessFormdefService.saveFormDef(businessFormdefEntity);
		return CommonResponse.success();
	}
	
	/**
	 * 获取formDef的后端
	 * 目前支持根据id和key 获取formDef
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping("getObject")
	public CommonResponse<JSONObject> getObject(HttpServletRequest request) {
		String id = request.getParameter("id");
		String key = request.getParameter("key");
		BusinessFormdefEntity formDef = null;
		if(StringUtils.isNotBlank(id)) {
			formDef = businessFormdefService.getById(id);
		}else if(StringUtils.isNotBlank(key)) {
			QueryWrapper<BusinessFormdefEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("unique_key", key);
			formDef = businessFormdefService.getOne(queryWrapper);
		}
		JSONObject json = formDef == null ? new JSONObject() : (JSONObject) JSON.toJSON(formDef);
		return CommonResponse.success(json);
	}
	
	/**
	 * boTree数据树
	 * 
	 * @param boKey
	 * @return
	 */
	@RequestMapping("boTreeData")
	public List<JSONObject> boTreeData(@RequestParam String boKey) {
		return businessObjectService.boTreeData(boKey);
	}
	
	/**
	 * <pre>
	 * 根据bo获取表单模板信息
	 * </pre>
	 * 
	 * @return
	 */
	@RequestMapping("templateData")
	public CommonResponse<JSONArray> templateData(@RequestParam String boKey, @RequestParam String type) {
		JSONArray array = formTemplateService.templateData(boKey, type);
		return CommonResponse.success(array);
	}
	
	/**
	 * 根据表单选择的模版生成html
	 * 
	 * @param request
	 * @param jsonArray
	 * @return
	 */
	@RequestMapping("createHtml")
	public CommonResponse<String> createHtml(HttpServletRequest request, @RequestBody JSONArray jsonArray) {
		String boKey = request.getParameter("boKey");
		String formType = request.getParameter("formType");
		String html = businessFormdefService.generateFormHtml(boKey, jsonArray, formType);
		return CommonResponse.success(html);
	}
	
	/**
	 * 根据主键删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping("remove")
	public CommonResponse<String> remove(@RequestParam String id) {
		businessFormdefService.removeBusinessFormdefById(id);
		return CommonResponse.success("删除成功");
	}

}
