/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.mapper.CustomAppMapper;
import com.ejianc.foundation.cfs.mapper.CustomColumnMapper;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomColumnServiceImpl
extends BaseServiceImpl<CustomColumnMapper, CustomColumnEntity>
implements ICustomColumnService {
    @Autowired
    private CustomColumnMapper customColumnMapper;
    @Autowired
    private ICustomAppService customAppService;
    @Autowired
    private ICustomTableService customTableService;
    @Autowired
    private ICustomColumnService customColumnService;
    @Autowired
    private CustomAppMapper customAppMapper;

    @Override
    public void deleteCustomColumnByTableId(Long mainFormId) {
        this.customColumnMapper.deleteCustomColumnByTableId(mainFormId);
    }

    @Override
    public List<CustomColumnEntity> queryColumnsByTableId(Long tableId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"custom_table_id", (Object)tableId);
        List columnEntities = this.customColumnMapper.selectList((Wrapper)queryWrapper);
        return columnEntities;
    }

    @Override
    public JSONObject getEntityDetailTree(String appCode) {
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(appCode);
        return this.getEntityDetailTree(app);
    }

    private JSONObject getEntityDetailTree(CustomAppEntity app) {
        JSONObject resp = new JSONObject();
        QueryWrapper mainWrapper = new QueryWrapper();
        mainWrapper.eq((Object)"app_id", (Object)app.getId());
        mainWrapper.eq((Object)"dr", (Object)0);
        mainWrapper.isNull((Object)"parent_id");
        List mainCustomTableEntities = this.customTableService.list((Wrapper)mainWrapper);
        if (mainCustomTableEntities != null && mainCustomTableEntities.size() > 0) {
            CustomTableEntity customTable = (CustomTableEntity)((Object)mainCustomTableEntities.get(0));
            this.translateEntityInfo(customTable, resp);
            resp.put("parentEntityId", (Object)customTable.getId());
            resp.put("entityName", (Object)app.getAppCode());
            resp.put("displayName", (Object)app.getAppName());
            resp.put("entityFullName", (Object)app.getAppName());
            QueryWrapper mainColumnWrapper = new QueryWrapper();
            mainColumnWrapper.eq((Object)"custom_table_id", (Object)customTable.getId());
            mainColumnWrapper.eq((Object)"dr", (Object)0);
            List mainColumnList = this.customColumnService.list((Wrapper)mainColumnWrapper);
            ArrayList<JSONObject> attrs = new ArrayList<JSONObject>();
            if (CollectionUtils.isNotEmpty((Collection)mainColumnList)) {
                for (CustomColumnEntity entity : mainColumnList) {
                    JSONObject attr = new JSONObject();
                    this.translateAttrInfo(entity, attr);
                    attrs.add(attr);
                }
            }
            QueryWrapper childWrapper = new QueryWrapper();
            childWrapper.eq((Object)"app_id", (Object)app.getId());
            childWrapper.eq((Object)"dr", (Object)0);
            childWrapper.eq((Object)"parent_id", (Object)customTable.getId());
            List childCustomTableEntities = this.customTableService.list((Wrapper)childWrapper);
            if (CollectionUtils.isNotEmpty((Collection)childCustomTableEntities)) {
                for (CustomTableEntity cls : childCustomTableEntities) {
                    JSONObject childJson = new JSONObject();
                    this.translateEntityInfo(cls, childJson);
                    QueryWrapper childColumnWrapper = new QueryWrapper();
                    childColumnWrapper.eq((Object)"custom_table_id", (Object)cls.getId());
                    childColumnWrapper.eq((Object)"dr", (Object)0);
                    List childColumnList = this.customColumnService.list((Wrapper)childColumnWrapper);
                    ArrayList<JSONObject> childattrs = new ArrayList<JSONObject>();
                    if (CollectionUtils.isNotEmpty((Collection)childColumnList)) {
                        for (CustomColumnEntity entity : childColumnList) {
                            JSONObject attr = new JSONObject();
                            this.translateAttrInfo(entity, attr);
                            childattrs.add(attr);
                        }
                    }
                    childJson.put("attrs", childattrs);
                    attrs.add(childJson);
                }
            }
            resp.put("attrs", attrs);
        }
        return resp;
    }

    @Override
    public JSONObject getEntityDetailTreeByAppId(Long appId) {
        CustomAppEntity app = (CustomAppEntity)((Object)this.customAppMapper.selectById(appId));
        return this.getEntityDetailTree(app);
    }

    private void translateEntityInfo(CustomTableEntity mdClassVO, JSONObject resp) {
        resp.put("entityName", (Object)mdClassVO.getUiKey());
        resp.put("entityId", (Object)mdClassVO.getId());
        resp.put("displayName", (Object)mdClassVO.getTableName());
        resp.put("entityFullName", (Object)mdClassVO.getTableName());
        resp.put("isKey", (Object)false);
        resp.put("key", (Object)mdClassVO.getId());
        resp.put("type", (Object)"entity");
    }

    private void translateAttrInfo(CustomColumnEntity attr, JSONObject resp) {
        resp.put("entityName", (Object)attr.getProperty());
        resp.put("entityId", (Object)attr.getId());
        resp.put("displayName", (Object)attr.getColumnName());
        resp.put("entityFullName", (Object)attr.getType());
        resp.put("isKey", (Object)"id".equals(attr.getProperty()));
        resp.put("key", (Object)attr.getId());
        resp.put("parentEntityId", (Object)attr.getCustomTableId());
        resp.put("dataFormat", (Object)"");
        resp.put("sourceType", (Object)attr.getProperty());
        resp.put("type", (Object)"attr");
    }

    @Override
    public JSONObject findPrintContent(String appCode, Boolean isBpm, String qrcode) {
        JSONObject resp = new JSONObject();
        JSONObject content = new JSONObject();
        JSONObject bo = new JSONObject();
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(appCode);
        QueryWrapper mainWrapper = new QueryWrapper();
        mainWrapper.eq((Object)"app_id", (Object)app.getId());
        mainWrapper.eq((Object)"dr", (Object)0);
        mainWrapper.isNull((Object)"parent_id");
        List mainCustomTableEntities = this.customTableService.list((Wrapper)mainWrapper);
        if (mainCustomTableEntities != null && mainCustomTableEntities.size() > 0) {
            CustomTableEntity customTable = (CustomTableEntity)((Object)mainCustomTableEntities.get(0));
            JSONArray subBos = new JSONArray();
            bo.put("bo_code", (Object)appCode);
            bo.put("bo_name", (Object)app.getAppName());
            bo.put("key", (Object)customTable.getId());
            JSONArray mainAttrs = new JSONArray();
            QueryWrapper mainColumnWrapper = new QueryWrapper();
            mainColumnWrapper.eq((Object)"custom_table_id", (Object)customTable.getId());
            mainColumnWrapper.eq((Object)"dr", (Object)0);
            List mainColumnList = this.customColumnService.list((Wrapper)mainColumnWrapper);
            if (CollectionUtils.isNotEmpty((Collection)mainColumnList)) {
                for (CustomColumnEntity entity : mainColumnList) {
                    JSONObject attr = new JSONObject();
                    this.translatePrintAttrInfo(entity, attr);
                    mainAttrs.add((Object)attr);
                }
            }
            bo.put("bo_attrs", (Object)mainAttrs);
            if (isBpm.booleanValue()) {
                JSONObject bpm = new JSONObject();
                bpm.put("bo_code", (Object)"ApproveInfo");
                bpm.put("bo_name", (Object)"\u5ba1\u6279\u4fe1\u606f");
                JSONArray bpmAttrs = new JSONArray();
                this.addPrintBpmAttrInfo("approveNode", "\u6d41\u7a0b\u73af\u8282\u540d\u79f0", bpmAttrs);
                this.addPrintBpmAttrInfo("approver", "\u5ba1\u6279\u4eba", bpmAttrs);
                this.addPrintBpmAttrInfo("approvalOutcome", "\u5ba1\u6279\u7ed3\u679c", bpmAttrs);
                this.addPrintBpmAttrInfo("processTime", "\u5ba1\u6279\u65f6\u95f4", bpmAttrs);
                this.addPrintBpmAttrInfo("approveInfo", "\u5ba1\u6279\u610f\u89c1", bpmAttrs);
                bpm.put("bo_attrs", (Object)bpmAttrs);
                subBos.add((Object)bpm);
            }
            QueryWrapper childWrapper = new QueryWrapper();
            childWrapper.eq((Object)"app_id", (Object)app.getId());
            childWrapper.eq((Object)"dr", (Object)0);
            childWrapper.eq((Object)"parent_id", (Object)customTable.getId());
            List childCustomTableEntities = this.customTableService.list((Wrapper)childWrapper);
            if (CollectionUtils.isNotEmpty((Collection)childCustomTableEntities)) {
                for (CustomTableEntity cls : childCustomTableEntities) {
                    JSONObject childJson = new JSONObject();
                    childJson.put("bo_code", (Object)cls.getUiKey());
                    childJson.put("bo_name", (Object)cls.getTableName());
                    childJson.put("key", (Object)cls.getId());
                    JSONArray childAttrs = new JSONArray();
                    QueryWrapper childColumnWrapper = new QueryWrapper();
                    childColumnWrapper.eq((Object)"custom_table_id", (Object)cls.getId());
                    childColumnWrapper.eq((Object)"dr", (Object)0);
                    List childColumnList = this.customColumnService.list((Wrapper)childColumnWrapper);
                    if (CollectionUtils.isNotEmpty((Collection)childColumnList)) {
                        for (CustomColumnEntity entity : childColumnList) {
                            JSONObject attr = new JSONObject();
                            this.translatePrintAttrInfo(entity, attr);
                            childAttrs.add((Object)attr);
                        }
                    }
                    childJson.put("bo_attrs", (Object)childAttrs);
                    subBos.add((Object)childJson);
                }
            }
            bo.put("sub_bos", (Object)subBos);
        }
        content.put("bo", (Object)bo);
        resp.put("boCode", (Object)appCode);
        resp.put("content", (Object)content.toJSONString());
        resp.put("qrcode", (Object)qrcode);
        return resp;
    }

    private void translatePrintAttrInfo(CustomColumnEntity attr, JSONObject resp) {
        resp.put("code", (Object)attr.getProperty());
        resp.put("fieldname", (Object)attr.getProperty());
        resp.put("typename", (Object)attr.getProperty());
        resp.put("name", (Object)attr.getColumnName());
        resp.put("fieldtype", (Object)(attr.getType().contains("date") ? "string" : attr.getType()));
        resp.put("key", (Object)attr.getId());
        resp.put("type", (Object)"attr");
        resp.put("dataFormat", (Object)"");
        resp.put("sourceType", (Object)attr.getProperty());
        resp.put("isPrimary", (Object)("id".equals(attr.getProperty()) ? 1 : 0));
    }

    private void addPrintBpmAttrInfo(String code, String name, JSONArray bpmAttrs) {
        JSONObject attr = new JSONObject();
        attr.put("code", (Object)code);
        attr.put("fieldname", (Object)code);
        attr.put("typename", (Object)code);
        attr.put("name", (Object)name);
        attr.put("type", (Object)"attr");
        attr.put("fieldtype", (Object)"VARCHAR");
        attr.put("isPrimary", (Object)("approveNode".equals(code) ? 1 : 0));
        bpmAttrs.add((Object)attr);
    }
}

