package com.ejianc.foundation.cfs.service;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

public interface ICustomColumnService extends IBaseService<CustomColumnEntity> {

	void deleteCustomColumnByTableId(Long mainFormId);

	/**
	 * 根据表ID查询其下的所有列字段
	 * 
	 * @param tableId
	 * @return
	 */
	List<CustomColumnEntity> queryColumnsByTableId(Long tableId);

	/**
	 * 查询打印使用的业务对象信息树
	 *
	 * @param appCode
	 * @return
	 */
	JSONObject getEntityDetailTree(String appCode);

	/**
	 * 查询打印模板使用的内容信息---直接获取
	 *
	 * @param appCode
	 * @param qucord 
	 * @param isBpm 
	 * @return
	 */
	JSONObject findPrintContent(String appCode, Boolean isBpm, String qrcode);

	/**
	 * 查询打印使用的业务对象信息树
	 *
	 * @param appId
	 * @return
	 */
	JSONObject getEntityDetailTreeByAppId(Long appId);
}
