package com.ejianc.foundation.cust.controller;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.cust.bean.BusinessFormdefEntity;
import com.ejianc.foundation.cust.bean.BusinessObjectEntity;
import com.ejianc.foundation.cust.bean.BusinessTableRel;
import com.ejianc.foundation.cust.service.IBusinessFormdefService;
import com.ejianc.foundation.cust.service.IBusinessObjectService;
import com.ejianc.foundation.cust.util.BusTableRelType;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@RestController
@RequestMapping("/bus/businessObject/")
public class BusinessObjectController {
	
	@Autowired
	private IBusinessObjectService businessObjectService;
	@Autowired
	private IBusinessFormdefService businessFormdefService;
	
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<BusinessObjectEntity>> pageList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		Map<String, String> order = queryParam.getOrderMap();
		order.put("createTime", "desc");
		IPage<BusinessObjectEntity> pageData = businessObjectService.queryPage(queryParam, false);
		return CommonResponse.success(pageData);
	}

	@RequestMapping("getObject")
	public CommonResponse<BusinessObjectEntity> getObject(HttpServletRequest request) {
		String id = request.getParameter("id");
		String key = request.getParameter("key");
		String fill = request.getParameter("fill");
		
		BusinessObjectEntity object = null;
		if(StringUtils.isNotBlank(id)) {
			object = businessObjectService.getById(id);
		}else if(StringUtils.isNotBlank(key)){
			QueryWrapper<BusinessObjectEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("uniqueKey", key);
			object = businessObjectService.getOne(queryWrapper);
		}
		if("1".equals(fill) && object != null) {
			object = businessObjectService.getFilledByKey(object.getUniqueKey());
		}
		return CommonResponse.success(object);
	}
	
	@RequestMapping("save")
	public CommonResponse<String> save(@RequestBody BusinessObjectEntity businessObject) {
		businessObjectService.saveBusinessObject(businessObject);
		return CommonResponse.success();
	}
	
	@RequestMapping("saveOverallArrangement")
	public CommonResponse<String> saveOverallArrangement(HttpServletRequest request) {
		String overallArrangement = request.getParameter("overallArrangement");
		String boCode = request.getParameter("boCode");
		businessObjectService.updateOverallArrangementByCode(boCode, overallArrangement);
		return CommonResponse.success();
	}
	
	@RequestMapping("getOverallArrangement")
	public CommonResponse<JSONObject> getOverallArrangement(@RequestParam String boCode) {
		String param = businessObjectService.getOverallArrangementByCode(boCode);
		JSONObject object = new JSONObject();
		if(StringUtils.isNotBlank(param)) {
			object = JSON.parseObject(param);
		}
		System.out.println(object);
		return CommonResponse.success(object);
	}
	
	@RequestMapping("getBoStruct")
	public CommonResponse<JSONObject> getBoStruct(@RequestParam String key) {
		BusinessObjectEntity object = businessObjectService.getFilledByKey(key);
		return CommonResponse.success(getBoStruct(object.getRelation()));
	}
	
	/**
	 * 删除
	 * 
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("remove")
	public CommonResponse<String> remove(@RequestParam String id) {
		QueryWrapper<BusinessFormdefEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("bo_key", id);
		List<BusinessFormdefEntity> formdefList = businessFormdefService.list(queryWrapper);
		if(formdefList != null && formdefList.size() > 0) {
			throw new BusinessException("表单还在使用业务对象， 删除业务对象失败！");
		}
		businessObjectService.removeById(id);
		return CommonResponse.success("删除成功");
	}
	
	/**
	 * <pre>
	 * 获取bo结构
	 * </pre>
	 * 
	 * @param rel
	 * @return
	 */
	private JSONObject getBoStruct(BusinessTableRel rel) {
		JSONObject json = new JSONObject();
		rel.getTable().getColumns().forEach(column -> {
			json.put(column.getUniqueKey(), column.initValue() == null ? "" : column.initValue());
		});
		rel.getChildren().forEach(r -> {
			if (BusTableRelType.ONE_TO_ONE.equalsWithKey(r.getType())) {
				json.put(r.getTableKey(), getBoStruct(r));
			} else {
				JSONObject jo = getBoStruct(r);
				JSONArray ja = new JSONArray();
				ja.add(jo);
				json.put(r.getTableKey() + "List", ja);
			}
		});

		return json;
	}
}
