package com.ejianc.foundation.cust.controller;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.cust.bean.BusinessTableEntity;
import com.ejianc.foundation.cust.mapper.BusinessTableMapper;
import com.ejianc.foundation.cust.service.IBusinessTableService;
import com.ejianc.foundation.cust.util.BusinessTableCacheUtil;
import com.ejianc.foundation.cust.util.TableOperator;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

@RestController
@RequestMapping("/bus/businessTable/")
public class BusinessTableController {
	
	@Autowired
	private IBusinessTableService businessTableService;
	@Autowired
	private BusinessTableMapper businessTableMapper;
	
	/**
	 * 查询列表
	 * 
	 * @param queryParam
	 * @return
	 */
	@RequestMapping(value = "/pageList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<BusinessTableEntity>> pageList(@RequestBody QueryParam queryParam) {
		queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		Map<String, String> order = queryParam.getOrderMap();
		order.put("createTime", "desc");
		IPage<BusinessTableEntity> pageData = businessTableService.queryPage(queryParam, false);
		return CommonResponse.success(pageData);
	}
	
	/**
	 * 保存或修改
	 * 
	 * @param businessTableEntity
	 * @return
	 */
	@RequestMapping("save")
	public CommonResponse<String> save(@RequestBody BusinessTableEntity businessTableEntity) {
		businessTableService.saveBusinessTable(businessTableEntity);
		return CommonResponse.success("保存成功");
	}
	
	/**
	 * 获取BusinessTable的后端
	 * 目前支持根据id,key 获取BusinessTable
	 * 
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping("getObject")
	public CommonResponse<BusinessTableEntity> getObject(HttpServletRequest request) {
		String id = request.getParameter("id");
		String key = request.getParameter("key");
		String fill = request.getParameter("fill");
		BusinessTableEntity table = null;
		if(StringUtils.isNotBlank(id)) {
			table = businessTableService.getById(id);
		}else if(StringUtils.isNotBlank(key)) {
			QueryWrapper<BusinessTableEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("unique_key", key);
			table = businessTableService.getOne(queryWrapper);
		}
		if("1".equals(fill) && table != null) {
			table = businessTableService.getFilledByKey(table.getUniqueKey());
		}
		return CommonResponse.success(table);
	}
	
	/**
	 * 新建表
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping("createTable")
	public CommonResponse<String> createTable(HttpServletRequest request) {
		String id = request.getParameter("id");
		BusinessTableEntity businessTable = businessTableService.getById(id);
		businessTable = businessTableService.getFilledByKey(businessTable.getUniqueKey());
		TableOperator tableOperate = new TableOperator(businessTableMapper, businessTable);
		tableOperate.createTable();
		businessTable.setCreatedTable(true);
		BusinessTableCacheUtil.put(businessTable);
		return CommonResponse.success("建表成功");
		
	}
	
	/**
	 * 清理成功
	 * 
	 * @param request
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("cleanCache")
	public CommonResponse<String> cleanCache(HttpServletRequest request) {
		BusinessTableCacheUtil.clean();
		return CommonResponse.success("清理成功");
	}

	/**
	 * 删除
	 * 
	 * @param id
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("remove")
    public CommonResponse<String> remove(@RequestParam String id) {
		businessTableService.removeTableByPkId(id);
		return CommonResponse.success("删除成功");
	}

}
