package com.ejianc.foundation.cust.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cust.bean.BusinessColumnCtrlEntity;
import com.ejianc.foundation.cust.bean.BusinessColumnEntity;
import com.ejianc.foundation.cust.bean.BusinessTableEntity;
import com.ejianc.foundation.cust.mapper.BusinessColumnCtrlMapper;
import com.ejianc.foundation.cust.mapper.BusinessColumnMapper;
import com.ejianc.foundation.cust.mapper.BusinessTableMapper;
import com.ejianc.foundation.cust.service.IBusinessTableService;
import com.ejianc.foundation.cust.util.BusinessTableCacheUtil;
import com.ejianc.foundation.cust.util.TableOperator;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;

@Service
public class BusinessTableServiceImpl extends BaseServiceImpl<BusinessTableMapper, BusinessTableEntity> implements IBusinessTableService {

	@Autowired
	private BusinessTableMapper businessTableMapper;
	@Autowired
	private BusinessColumnMapper businessColumnMapper;
	@Autowired
	private BusinessColumnCtrlMapper businessColumnCtrlMapper;
	
	private String generateKey() {
		SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmss");
		return Utils.randString(3).toLowerCase()+format.format(new Date());
	}
	
	@Override
	public void saveBusinessTable(BusinessTableEntity businessTableEntity) {
		TableOperator tableOperate = new TableOperator(businessTableMapper, businessTableEntity);;
		
		if(businessTableEntity.getId() != null && businessTableEntity.getId() > 0) { //修改
			BusinessTableEntity uniqueBean = businessTableMapper.selectById(businessTableEntity.getId());
			uniqueBean.setName(businessTableEntity.getName());
			uniqueBean.setComment(businessTableEntity.getComment());
			uniqueBean.setGroupId(businessTableEntity.getGroupId());
			uniqueBean.setGroupName(businessTableEntity.getGroupName());
			businessTableMapper.updateById(uniqueBean);
			
			//删除关联字段控件
			businessColumnCtrlMapper.removeByTableId(businessTableEntity.getId());
			//删除关联字段
			businessColumnMapper.removeByTableId(businessTableEntity.getId());
		}else{ //新增
			//新建内部表时，表已经存在库中， 则抛出异常
			if(tableOperate.isTableCreated()) {
				throw new BusinessException("表[" + businessTableEntity.getName() + "]已经存在数据库中");
			}
			businessTableEntity.setId(IdWorker.getId());
			businessTableEntity.setUniqueKey(generateKey());
			businessTableMapper.insert(businessTableEntity);
		}
		
		for(BusinessColumnEntity businessColumn:businessTableEntity.getColumns()) {
			if(businessColumn.getId() == null) {
				businessColumn.setId(IdWorker.getId());
			}
			businessColumn.setUniqueKey(generateKey());
			businessColumn.setTableId(businessTableEntity.getId());
			businessColumnMapper.insert(businessColumn);
			//控件
			if(1 == businessColumn.getPrimary()) { //主键没空间
				continue;
			}
			BusinessColumnCtrlEntity ctrl = businessColumn.getCtrl();
			if(ctrl == null) {
				throw new BusinessException("字段必须配置控件！");
			}
			if(ctrl.getId() == null) {
				ctrl.setId(IdWorker.getId());
			}
			ctrl.setColumnId(businessColumn.getId());
			businessColumnCtrlMapper.insert(ctrl);
		}
		
		tableOperate.syncColumn();
		
		BusinessTableCacheUtil.put(businessTableEntity);
	}
	
	@Override
	public BusinessTableEntity getFilledByKey(String uniqueKey) {
		BusinessTableEntity businessTable = BusinessTableCacheUtil.get(uniqueKey);
		if(businessTable != null) {
			return businessTable;
		}
		businessTable = getByKey(uniqueKey);
		fill(businessTable);
		BusinessTableCacheUtil.put(businessTable); //加入缓存
		return businessTable;
	}

	private void fill(BusinessTableEntity businessTable) {
		if(businessTable == null) {
			return;
		}
		QueryWrapper<BusinessColumnEntity> columnWrapper = new QueryWrapper<>();
		columnWrapper.eq("table_id", businessTable.getId());
		List<BusinessColumnEntity> columns = businessColumnMapper.selectList(columnWrapper);
		for(BusinessColumnEntity column:columns) {
			QueryWrapper<BusinessColumnCtrlEntity> ctrlQueryWrapper = new QueryWrapper<>();
			ctrlQueryWrapper.eq("column_id", column.getId());
			BusinessColumnCtrlEntity businessColumnCtrlEntity = businessColumnCtrlMapper.selectOne(ctrlQueryWrapper);
			column.setCtrl(businessColumnCtrlEntity);
			column.setTable(businessTable);
		}
		businessTable.setColumns(columns);
		
		//创建表
		TableOperator tableOperator = new TableOperator(businessTableMapper, businessTable);
		businessTable.setCreatedTable(tableOperator.isTableCreated());
	}

	private BusinessTableEntity getByKey(String uniqueKey) {
		QueryWrapper<BusinessTableEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("unique_key", uniqueKey);
		BusinessTableEntity businessTable = businessTableMapper.selectOne(queryWrapper);
		return businessTable;
	}

	@Override
	public void removeTableByPkId(String tableId) {
		//删除列
		businessColumnMapper.removeByTableId(Long.parseLong(tableId));
		//删除列控件
		businessColumnCtrlMapper.removeByTableId(Long.parseLong(tableId));
		//删除表
		businessTableMapper.removeTableByPkId(tableId);
	}
}
