/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomDataEntity;
import com.ejianc.foundation.cfs.bean.CustomListEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomDataService;
import com.ejianc.foundation.cfs.service.ICustomListService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.foundation.cfs.util.BillStateEnum;
import com.ejianc.foundation.cfs.util.ExcelExportSubData;
import com.ejianc.foundation.cfs.util.ExcelExportUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"custom/table"})
public class CustomTableController
implements Serializable {
    private static final long serialVersionUID = 8717661796833595475L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String ID = "id";
    private static final String DEL = "del";
    private static final String PID = "pid";
    private static final String ORG_ID = "orgId";
    private static final String CREATE_USER = "createUser";
    private static final String CREATE_TIME = "createTime";
    private static final String BILL_STATE = "billState";
    private static final Integer QUERY_TIMEOUT = 60;
    @Autowired
    private ICustomAppService customAppService;
    @Autowired
    private ICustomTableService customTableService;
    @Autowired
    private ICustomColumnService customColumnService;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private ICustomDataService iCustomDataService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ICustomListService customListService;

    @RequestMapping(value={"/{pageCode}/save"}, method={RequestMethod.POST})
    public CommonResponse<JSONObject> save(@PathVariable String pageCode, @RequestBody JSONObject saveData) throws IOException {
        if (StringUtils.isBlank((CharSequence)pageCode)) {
            this.logger.error("\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return CommonResponse.error((String)"\u5e94\u7528\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
        List<CustomColumnEntity> mainColumnEntities = this.customColumnService.queryColumnsByTableId(mainTableEntity.getId());
        if (saveData != null) {
            Object response;
            HashMap<String, Object> saveMap = new HashMap<String, Object>();
            if (mainColumnEntities != null && mainColumnEntities.size() > 0) {
                for (CustomColumnEntity col : mainColumnEntities) {
                    String v;
                    if (col.getUniqued() == null || !col.getUniqued().booleanValue() || !StringUtils.isNotEmpty((CharSequence)(v = saveData.getString(col.getProperty())))) continue;
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put(col.getProperty(), new Parameter("eq", (Object)v));
                    IPage<JSONObject> pages = this.getPageListData(app, queryParam, InvocationInfoProxy.getOrgId());
                    if (StringUtils.isBlank((CharSequence)saveData.getString(ID))) {
                        if (pages.getTotal() <= 0L) continue;
                        return CommonResponse.error((String)(col.getColumnName() + "\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01"));
                    }
                    if (pages.getTotal() > 1L) {
                        return CommonResponse.error((String)(col.getColumnName() + "\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01"));
                    }
                    if (pages.getTotal() != 1L || saveData.getString(ID).equals(((JSONObject)pages.getRecords().get(0)).getString(ID))) continue;
                    return CommonResponse.error((String)(col.getColumnName() + "\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01"));
                }
                for (CustomColumnEntity customColumnEntity : mainColumnEntities) {
                    if (ID.equals(customColumnEntity.getProperty())) {
                        String value = saveData.getString(customColumnEntity.getProperty());
                        if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                        saveMap.put(customColumnEntity.getProperty(), saveData.getString(customColumnEntity.getProperty()));
                        continue;
                    }
                    if ("refer".equals(customColumnEntity.getType())) {
                        if (saveData.getJSONObject(customColumnEntity.getProperty()) == null) continue;
                        saveMap.put(customColumnEntity.getProperty(), saveData.getJSONObject(customColumnEntity.getProperty()).toJSONString());
                        continue;
                    }
                    if ("date".equals(customColumnEntity.getType())) {
                        JSONObject col;
                        if (!StringUtils.isNotEmpty((CharSequence)saveData.getString(customColumnEntity.getProperty()))) continue;
                        String dateString = saveData.getString(customColumnEntity.getProperty());
                        String val = customColumnEntity.getVal();
                        if (StringUtils.isNotEmpty((CharSequence)val) && StringUtils.isNotEmpty((CharSequence)(col = JSONObject.parseObject((String)val)).getString("format")) && col.getString("format").length() != dateString.length()) {
                            if (dateString.length() == 10 && col.getString("format").length() == 19) {
                                dateString = dateString + " 00:00:00";
                            }
                            if (dateString.length() == 19 && col.getString("format").length() == 10) {
                                dateString = dateString.substring(0, 10);
                            }
                        }
                        saveMap.put(customColumnEntity.getProperty(), dateString);
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)saveData.getString(customColumnEntity.getProperty()))) continue;
                    saveMap.put(customColumnEntity.getProperty(), saveData.getString(customColumnEntity.getProperty()));
                }
            }
            Long mainPkId = 0L;
            if (saveMap.containsKey(ID)) {
                mainPkId = Long.parseLong(saveMap.get(ID).toString());
                UpdateRequest updateRequest = new UpdateRequest(mainTableEntity.getTableName(), mainPkId.toString());
                updateRequest.doc(saveMap, XContentType.JSON);
                response = this.client.update(updateRequest, RequestOptions.DEFAULT);
                if (response.status().getStatus() != RestStatus.OK.getStatus()) {
                    this.logger.error(response.toString());
                    return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25");
                }
            } else {
                IndexRequest indexRequest = new IndexRequest(mainTableEntity.getTableName());
                mainPkId = IdWorker.getId();
                saveMap.put(ID, mainPkId + "");
                indexRequest.id(mainPkId + "");
                saveMap.put(ORG_ID, InvocationInfoProxy.getOrgId() + "");
                saveMap.put(BILL_STATE, 0);
                saveMap.put(CREATE_USER, InvocationInfoProxy.getUserid() + "");
                indexRequest.source(saveMap, XContentType.JSON);
                response = this.client.index(indexRequest, RequestOptions.DEFAULT);
                if (response.status().getStatus() == RestStatus.CREATED.getStatus()) {
                    saveData.put(ID, saveMap.get(ID));
                    saveData.put(ORG_ID, saveMap.get(ORG_ID));
                    saveData.put(BILL_STATE, (Object)0);
                    saveData.put(CREATE_USER, saveMap.get(CREATE_USER));
                } else {
                    this.logger.error(response.toString());
                    return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25");
                }
            }
            List<CustomTableEntity> childTableEntities = this.customTableService.queryChildTablesByMainTableId(mainTableEntity.getId());
            if (ListUtil.isNotEmpty(childTableEntities)) {
                for (CustomTableEntity childTableEntity : childTableEntities) {
                    List<CustomColumnEntity> childColumnEntities = this.customColumnService.queryColumnsByTableId(childTableEntity.getId());
                    if (!ListUtil.isNotEmpty(childColumnEntities)) continue;
                    JSONArray childDatas = saveData.getJSONArray(childTableEntity.getUiKey());
                    JSONArray saveChildData = new JSONArray();
                    if (ListUtil.isNotEmpty((List)childDatas)) {
                        for (int i = 0; i < childDatas.size(); ++i) {
                            JSONObject childData = childDatas.getJSONObject(i);
                            childData.put("rowIndex", (Object)i);
                            String rowState = childData.getString("rowState");
                            if (DEL.equals(rowState) && StringUtils.isNotEmpty((CharSequence)childData.getString(ID))) {
                                DeleteRequest deleteRequest = new DeleteRequest(childTableEntity.getTableName(), childData.getString(ID));
                                this.client.delete(deleteRequest, RequestOptions.DEFAULT);
                                continue;
                            }
                            HashMap<String, Object> childSaveMap = new HashMap<String, Object>();
                            for (CustomColumnEntity childColumnEntity : childColumnEntities) {
                                if (ID.equals(childColumnEntity.getProperty())) {
                                    String value = childData.getString(childColumnEntity.getProperty());
                                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                                    childSaveMap.put(childColumnEntity.getProperty(), childData.getString(childColumnEntity.getProperty()));
                                    continue;
                                }
                                childSaveMap.put(childColumnEntity.getProperty(), childData.getString(childColumnEntity.getProperty()));
                            }
                            childSaveMap.put("rowIndex", i);
                            this.logger.info("childSaveMap i={},\u6570\u636e\uff1a{}", (Object)i, (Object)JSONObject.toJSONString(childSaveMap));
                            this.logger.info("childData i={},\u6570\u636e\uff1a{}", (Object)i, (Object)JSONObject.toJSONString((Object)childData));
                            if (childSaveMap.containsKey(ID)) {
                                Long childPkId = Long.parseLong(childSaveMap.get(ID).toString());
                                UpdateRequest updateRequest = new UpdateRequest(childTableEntity.getTableName(), childPkId.toString());
                                updateRequest.doc(childSaveMap, XContentType.JSON);
                                this.client.update(updateRequest, RequestOptions.DEFAULT);
                                saveChildData.add((Object)childData);
                                continue;
                            }
                            IndexRequest indexRequest = new IndexRequest(childTableEntity.getTableName());
                            Long childPkId = IdWorker.getId();
                            childSaveMap.put(ID, childPkId + "");
                            childSaveMap.put(PID, mainPkId + "");
                            childSaveMap.put(CREATE_USER, InvocationInfoProxy.getUserid() + "");
                            childSaveMap.put(CREATE_TIME, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                            indexRequest.id(childPkId + "");
                            indexRequest.source(childSaveMap, XContentType.JSON);
                            IndexResponse response2 = this.client.index(indexRequest, RequestOptions.DEFAULT);
                            if (response2.status().getStatus() == RestStatus.CREATED.getStatus()) {
                                childData.put(ID, childSaveMap.get(ID));
                                childData.put(PID, childSaveMap.get(PID));
                                childData.put(CREATE_USER, saveMap.get(CREATE_USER));
                                childData.put(CREATE_TIME, saveMap.get(CREATE_TIME));
                                childData.put("rowState", null);
                                saveChildData.add((Object)childData);
                                continue;
                            }
                            this.logger.error(response2.toString());
                            return CommonResponse.error((String)"\u4fdd\u5b58\u5931\u8d25");
                        }
                    }
                    saveData.put(childTableEntity.getUiKey(), (Object)saveChildData);
                }
            }
            ArrayList<Long> attachIds = new ArrayList<Long>();
            JSONArray array = saveData.getJSONArray("attachIds");
            if (array != null && array.size() > 0) {
                for (int i = 0; i < array.size(); ++i) {
                    Long attrId = array.getLong(i);
                    attachIds.add(attrId);
                }
            }
            this.logger.info("attachIds----{}", (Object)JSONObject.toJSONString(attachIds));
            if (ListUtil.isNotEmpty(attachIds)) {
                CommonResponse res = this.attachmentApi.updateAttachRef(mainPkId, attachIds);
                this.logger.info("attachIds----CommonResponse {}", (Object)JSONObject.toJSONString((Object)res));
            }
            QueryParam dataParam = new QueryParam();
            dataParam.getParams().put("mainId", new Parameter("eq", (Object)mainPkId));
            List dataEntityList = this.iCustomDataService.queryList(dataParam, false);
            CustomDataEntity customDataEntity = null;
            if (ListUtil.isEmpty((List)dataEntityList)) {
                customDataEntity = new CustomDataEntity();
                customDataEntity.setMainId(mainPkId);
                customDataEntity.setAppCode(pageCode);
            } else {
                customDataEntity = (CustomDataEntity)((Object)dataEntityList.get(0));
            }
            customDataEntity.setData(saveData.toJSONString());
            this.iCustomDataService.saveOrUpdate((Object)customDataEntity, false);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f", (Object)saveData);
    }

    public static void main(String[] args) {
        String s = "2023-01-05 00:00:00";
        System.out.println(s.substring(0, 10));
    }

    @RequestMapping(value={"/{pageCode}/pageList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<JSONObject>> pageList(@PathVariable String pageCode, @RequestBody QueryParam queryParam) {
        Long orgId = InvocationInfoProxy.getOrgId();
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        return CommonResponse.success(this.getPageListData(app, queryParam, orgId));
    }

    @RequestMapping(value={"/{pageCode}/export"}, method={RequestMethod.POST})
    @ResponseBody
    public void export(@PathVariable String pageCode, @RequestBody QueryParam queryParam, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long orgId = InvocationInfoProxy.getOrgId();
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        IPage<JSONObject> pageData = this.getPageListData(app, queryParam, orgId);
        ExcelExportUtil excelExport = new ExcelExportUtil();
        List<JSONObject> res = this.getExportData(pageData.getRecords(), app.getId());
        if (ListUtil.isEmpty(res)) {
            return;
        }
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
        List<ExcelExportSubData> subExportData = this.getSubExportData(res, mainTableEntity, app.getId());
        excelExport.setData(res);
        excelExport.setSubDataList(subExportData);
        ArrayList<String> properties = new ArrayList<String>();
        ArrayList<String> titleList = new ArrayList<String>();
        QueryParam param = new QueryParam();
        param.getParams().put("customTableId", new Parameter("eq", (Object)mainTableEntity.getId()));
        List list = this.customColumnService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)list)) {
            for (CustomColumnEntity customListEntity : list) {
                if (Objects.equals(customListEntity.getProperty(), CREATE_USER) || Objects.equals(customListEntity.getProperty(), ORG_ID) || Objects.equals(customListEntity.getProperty(), ID)) continue;
                properties.add(customListEntity.getProperty());
                titleList.add(customListEntity.getColumnName());
            }
        }
        if (properties.size() > 0) {
            excelExport.setHeardKey(properties.toArray(new String[properties.size()]));
            excelExport.setFontSize(12);
            excelExport.setSheetName(app.getAppName());
            excelExport.setTitle(app.getAppName());
            excelExport.setHeardList(titleList.toArray(new String[titleList.size()]));
            excelExport.exportExport(response);
        }
    }

    private List<ExcelExportSubData> getSubExportData(List<JSONObject> mainData, CustomTableEntity mainTableEntity, Long appId) {
        ArrayList<ExcelExportSubData> subDataList = new ArrayList<ExcelExportSubData>();
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("appId", new Parameter("eq", (Object)appId));
        param.getParams().put("subExportRelation", new Parameter("eq", (Object)true));
        List listEntityList = this.customListService.queryList(param, false);
        List<CustomTableEntity> childTableEntities = this.customTableService.queryChildTablesByMainTableId(mainTableEntity.getId());
        if (ListUtil.isNotEmpty(childTableEntities)) {
            int i = 1;
            for (CustomTableEntity childTableEntity : childTableEntities) {
                param = new QueryParam();
                param.getParams().put("customTableId", new Parameter("eq", (Object)childTableEntity.getId()));
                List list = this.customColumnService.queryList(param, false);
                ArrayList<JSONObject> subTbsData = new ArrayList<JSONObject>();
                SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
                sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
                SearchRequest searchRequest = new SearchRequest(new String[]{childTableEntity.getTableName()});
                searchRequest.source(sourceBuilder);
                try {
                    SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                    SearchHits hits = response.getHits();
                    for (SearchHit hit : hits) {
                        String sourceAsString = hit.getSourceAsString();
                        JSONObject rowData = JSON.parseObject((String)sourceAsString);
                        if (ListUtil.isNotEmpty((List)listEntityList)) {
                            for (CustomListEntity listEntity : listEntityList) {
                                for (JSONObject mainDatum : mainData) {
                                    if (!Objects.equals(mainDatum.getLong(ID), rowData.getLong(PID))) continue;
                                    rowData.put(listEntity.getColumnProperty(), mainDatum.get((Object)listEntity.getColumnProperty()));
                                }
                            }
                        }
                        for (CustomColumnEntity col : list) {
                            String[] stringArray;
                            if ("refer".equals(col.getType()) && StringUtils.isNotEmpty((CharSequence)rowData.getString(col.getProperty()))) {
                                rowData.put(col.getProperty(), (Object)JSONObject.parseObject((String)rowData.getString(col.getProperty())).getString("name"));
                            }
                            if ("select".equals(col.getType()) && StringUtils.isNotEmpty((CharSequence)rowData.getString(col.getProperty()))) {
                                rowData.put(col.getProperty(), (Object)JSONObject.parseObject((String)rowData.getString(col.getProperty())).getString("text"));
                            }
                            if (BILL_STATE.equals(col.getProperty()) && StringUtils.isNotEmpty((CharSequence)rowData.getString(col.getProperty()))) {
                                rowData.put(col.getProperty(), (Object)BillStateEnum.getEnumByStateCode(rowData.getInteger(col.getProperty())).getDescription());
                            }
                            if (!"integer".equals(col.getType()) || BILL_STATE.equals(col.getProperty())) continue;
                            if (StringUtils.isNotEmpty((CharSequence)col.getVal())) {
                                stringArray = col.getVal().split(",");
                            } else {
                                String[] stringArray2 = new String[2];
                                stringArray2[0] = "\u662f";
                                stringArray = stringArray2;
                                stringArray2[1] = "\u5426";
                            }
                            String[] names = stringArray;
                            if ("1".equals(rowData.getString(col.getProperty()))) {
                                rowData.put(col.getProperty(), (Object)names[0]);
                                continue;
                            }
                            rowData.put(col.getProperty(), (Object)names[1]);
                        }
                        subTbsData.add(rowData);
                    }
                }
                catch (IOException e) {
                    try {
                        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
                        SearchHits hits = response.getHits();
                        for (SearchHit hit : hits) {
                            String sourceAsString = hit.getSourceAsString();
                            subTbsData.add(JSON.parseObject((String)sourceAsString));
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
                    }
                }
                ExcelExportSubData subData = new ExcelExportSubData();
                subData.setData(subTbsData);
                ArrayList<String> properties = new ArrayList<String>();
                ArrayList<String> titleList = new ArrayList<String>();
                if (ListUtil.isNotEmpty((List)listEntityList)) {
                    for (CustomListEntity listEntity : listEntityList) {
                        properties.add(listEntity.getColumnProperty());
                        titleList.add(listEntity.getColumnName());
                    }
                }
                if (ListUtil.isNotEmpty((List)list)) {
                    for (CustomColumnEntity customListEntity : list) {
                        if (Objects.equals(customListEntity.getProperty(), CREATE_USER) || Objects.equals(customListEntity.getProperty(), "creatorName") || Objects.equals(customListEntity.getProperty(), ORG_ID) || Objects.equals(customListEntity.getProperty(), PID) || Objects.equals(customListEntity.getProperty(), "rowIndex") || Objects.equals(customListEntity.getProperty(), ID)) continue;
                        titleList.add(customListEntity.getColumnName());
                        properties.add(customListEntity.getProperty());
                    }
                }
                subData.setHeardKey(properties.toArray(new String[properties.size()]));
                subData.setFontSize(12);
                subData.setSheetName("\u5b50\u8868" + i);
                subData.setTitle("\u5b50\u8868" + i);
                subData.setHeardList(titleList.toArray(new String[titleList.size()]));
                subDataList.add(subData);
                ++i;
            }
        }
        return subDataList;
    }

    private List<JSONObject> getExportData(List<JSONObject> list, Long appId) {
        ArrayList<JSONObject> res = new ArrayList<JSONObject>();
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(appId);
        List<CustomColumnEntity> mainCols = this.customColumnService.queryColumnsByTableId(mainTableEntity.getId());
        if (ListUtil.isNotEmpty(list)) {
            for (JSONObject mainDetail : list) {
                for (CustomColumnEntity col : mainCols) {
                    String[] stringArray;
                    if ("refer".equals(col.getType()) && StringUtils.isNotEmpty((CharSequence)mainDetail.getString(col.getProperty()))) {
                        mainDetail.put(col.getProperty(), (Object)JSONObject.parseObject((String)mainDetail.getString(col.getProperty())).getString("name"));
                    }
                    if ("select".equals(col.getType()) && StringUtils.isNotEmpty((CharSequence)mainDetail.getString(col.getProperty()))) {
                        mainDetail.put(col.getProperty(), (Object)JSONObject.parseObject((String)mainDetail.getString(col.getProperty())).getString("text"));
                    }
                    if (BILL_STATE.equals(col.getProperty()) && StringUtils.isNotEmpty((CharSequence)mainDetail.getString(col.getProperty()))) {
                        mainDetail.put(col.getProperty(), (Object)BillStateEnum.getEnumByStateCode(mainDetail.getInteger(col.getProperty())).getDescription());
                    }
                    if (!"integer".equals(col.getType()) || BILL_STATE.equals(col.getProperty())) continue;
                    if (StringUtils.isNotEmpty((CharSequence)col.getVal())) {
                        stringArray = col.getVal().split(",");
                    } else {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = "\u662f";
                        stringArray = stringArray2;
                        stringArray2[1] = "\u5426";
                    }
                    String[] names = stringArray;
                    if ("1".equals(mainDetail.getString(col.getProperty()))) {
                        mainDetail.put(col.getProperty(), (Object)names[0]);
                        continue;
                    }
                    mainDetail.put(col.getProperty(), (Object)names[1]);
                }
                res.add(mainDetail);
            }
        }
        return res;
    }

    private IPage<JSONObject> getPageListData(CustomAppEntity app, QueryParam queryParam, Long orgId) {
        CommonResponse orgVoResponse;
        if ((app.getQueryRange() == 0 || app.getQueryRange() == 1 && queryParam.getParams().get(CREATE_USER) == null) && (orgVoResponse = this.orgApi.findChildrenByParentId(orgId)).isSuccess()) {
            List orgVos = (List)orgVoResponse.getData();
            StringBuffer orgIdBuffer = new StringBuffer();
            for (OrgVO orgVo : orgVos) {
                orgIdBuffer.append(orgVo.getId()).append(",");
            }
            queryParam.getParams().put(ORG_ID, new Parameter("in", (Object)orgIdBuffer.substring(0, orgIdBuffer.length() - 1)));
        }
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
        IPage<JSONObject> page = new IPage<JSONObject>();
        SearchRequest searchRequest = new SearchRequest(new String[]{mainTableEntity.getTableName()});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        Map paramMap = queryParam.getParams();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery = this.setParam(boolQuery, paramMap);
        if (CollectionUtils.isNotEmpty((Collection)queryParam.getComplexParams())) {
            boolQuery.must((QueryBuilder)this.parseComplexParams(queryParam.getComplexParams()));
        }
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.sort(new FieldSortBuilder(CREATE_TIME).order(SortOrder.DESC));
        sourceBuilder.from(queryParam.getPageIndex() <= 0 ? 0 : (queryParam.getPageIndex() - 1) * queryParam.getPageSize());
        sourceBuilder.size(queryParam.getPageSize());
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        try {
            page = this.queryPage(paramMap, searchRequest);
        }
        catch (IOException e) {
            try {
                page = this.queryPage(paramMap, searchRequest);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                throw new BusinessException("\u6839\u636e parammap \u6761\u4ef6\uff0c\u67e5\u8be2\u5168\u90e8\u8bb0\u5f55\u7d22\u5f15\u5931\u8d25\uff0cMSG\uff1a" + e1.getMessage());
            }
        }
        return page;
    }

    @PostMapping(value={"/pageList/{appId}"})
    public CommonResponse<JSONObject> pageListByAppId(@PathVariable Long appId, @RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        JSONObject appJson = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        CustomAppEntity app = (CustomAppEntity)((Object)this.customAppService.selectById(appId));
        if (null == app) {
            return CommonResponse.error((String)"\u67e5\u8be2\u81ea\u5b9a\u4e49\u5e94\u7528\u6570\u636e\u5931\u8d25\uff0c\u65e0\u5339\u914d\u7684\u5e94\u7528\u4fe1\u606f\uff01");
        }
        IPage<JSONObject> page = this.getPageListData(app, queryParam, orgId);
        if (ListUtil.isNotEmpty((List)page.getRecords())) {
            CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
            List<CustomColumnEntity> mainColumnEntities = this.customColumnService.queryColumnsByTableId(mainTableEntity.getId());
            page.getRecords().forEach(o -> mainColumnEntities.forEach(col -> {
                if (("refer".equals(col.getType()) || "select".equals(col.getType())) && o.get((Object)col.getProperty()) != null) {
                    JSONObject data = JSONObject.parseObject((String)o.getString(col.getProperty()));
                    if (StringUtils.isNotEmpty((CharSequence)data.getString("name"))) {
                        o.put(col.getProperty(), (Object)data.getString("name"));
                    } else if (StringUtils.isNotEmpty((CharSequence)data.getString("text"))) {
                        o.put(col.getProperty(), (Object)data.getString("text"));
                    }
                }
                if (BILL_STATE.equals(col.getProperty())) {
                    o.put(col.getProperty(), (Object)BillStateEnum.getEnumByStateCode(o.getInteger(col.getProperty())).getDescription());
                }
            }));
        }
        appJson.put("count", (Object)page.getTotal());
        appJson.put("dbType", (Object)"0");
        appJson.put("isList", (Object)"1");
        appJson.put("isPage", (Object)"1");
        appJson.put("linkList", null);
        appJson.put("expData", (Object)new JSONObject());
        appJson.put("list", (Object)page.getRecords());
        appJson.put("total", (Object)page.getPages());
        resp.put(app.getAppCode(), (Object)appJson);
        return CommonResponse.success((Object)resp);
    }

    @RequestMapping(value={"/{pageCode}/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@PathVariable String pageCode, @RequestBody List<Long> ids) throws IOException {
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
        List<CustomTableEntity> childTableEntities = this.customTableService.queryChildTablesByMainTableId(mainTableEntity.getId());
        for (Long id : ids) {
            DeleteRequest mainDeleteRequest = new DeleteRequest(mainTableEntity.getTableName(), id.toString());
            this.client.delete(mainDeleteRequest, RequestOptions.DEFAULT);
            if (childTableEntities != null && childTableEntities.size() > 0) {
                for (CustomTableEntity childTableEntity : childTableEntities) {
                    DeleteByQueryRequest childDeleteRequest = new DeleteByQueryRequest(new String[]{childTableEntity.getTableName()});
                    childDeleteRequest.setQuery((QueryBuilder)new TermQueryBuilder(PID, (Object)id));
                    this.client.deleteByQuery(childDeleteRequest, RequestOptions.DEFAULT);
                }
            }
            QueryParam dataParam = new QueryParam();
            dataParam.getParams().put("mainId", new Parameter("eq", (Object)id));
            List dataEntityList = this.iCustomDataService.queryList(dataParam, false);
            if (!ListUtil.isNotEmpty((List)dataEntityList)) continue;
            this.iCustomDataService.removeById(((CustomDataEntity)((Object)dataEntityList.get(0))).getId(), false);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/{pageCode}/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> queryDetail(@PathVariable String pageCode, @RequestParam Long id) throws IOException {
        return this.customTableService.queryDetail(pageCode, id);
    }

    @RequestMapping(value={"/{pageCode}/queryPrintDetail"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> queryPrintDetail(@PathVariable String pageCode, @RequestParam Long id) throws IOException {
        return this.customTableService.queryPrintDetail(pageCode, id);
    }

    @RequestMapping(value={"/syncToEs"}, method={RequestMethod.GET})
    public CommonResponse<String> syncToEs(@RequestParam String pageCode) {
        Thread runnable = new Thread(() -> {
            QueryParam dataParam = new QueryParam();
            dataParam.getParams().put("appCode", new Parameter("eq", (Object)pageCode));
            int index = 1;
            dataParam.setPageIndex(index);
            dataParam.setPageSize(500);
            IPage page = this.iCustomDataService.queryPage(dataParam, false);
            while (ListUtil.isNotEmpty((List)page.getRecords())) {
                this.saveToEs(page.getRecords(), pageCode);
                dataParam.setPageIndex(++index);
                page = this.iCustomDataService.queryPage(dataParam, false);
            }
        });
        runnable.start();
        return CommonResponse.success((String)"\u540c\u6b65\u4efb\u52a1\u5df2\u63d0\u4ea4\uff0c\u7cfb\u7edf\u5728\u540e\u53f0\u5904\u7406\u4e2d...");
    }

    private void saveToEs(List<CustomDataEntity> entities, String pageCode) {
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageCode);
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
        List<CustomColumnEntity> mainColumnEntities = this.customColumnService.queryColumnsByTableId(mainTableEntity.getId());
        for (CustomDataEntity entity : entities) {
            List<CustomTableEntity> childTableEntities;
            JSONObject saveData = JSONObject.parseObject((String)entity.getData());
            HashMap<String, String> saveMap = new HashMap<String, String>();
            if (mainColumnEntities != null && mainColumnEntities.size() > 0) {
                for (CustomColumnEntity customColumnEntity : mainColumnEntities) {
                    if (ID.equals(customColumnEntity.getProperty())) {
                        String value = saveData.getString(customColumnEntity.getProperty());
                        if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                        saveMap.put(customColumnEntity.getProperty(), saveData.getString(customColumnEntity.getProperty()));
                        continue;
                    }
                    if ("refer".equals(customColumnEntity.getType())) {
                        if (saveData.getJSONObject(customColumnEntity.getProperty()) == null) continue;
                        saveMap.put(customColumnEntity.getProperty(), saveData.getJSONObject(customColumnEntity.getProperty()).toJSONString());
                        continue;
                    }
                    if ("date".equals(customColumnEntity.getType())) {
                        JSONObject col;
                        if (!StringUtils.isNotEmpty((CharSequence)saveData.getString(customColumnEntity.getProperty()))) continue;
                        String dateString = saveData.getString(customColumnEntity.getProperty());
                        String val = customColumnEntity.getVal();
                        if (StringUtils.isNotEmpty((CharSequence)val) && StringUtils.isNotEmpty((CharSequence)(col = JSONObject.parseObject((String)val)).getString("format")) && col.getString("format").length() != dateString.length()) {
                            if (dateString.length() == 10 && col.getString("format").length() == 19) {
                                dateString = dateString + " 00:00:00";
                            }
                            if (dateString.length() == 19 && col.getString("format").length() == 10) {
                                dateString = dateString.substring(0, 10);
                            }
                        }
                        saveMap.put(customColumnEntity.getProperty(), dateString);
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)saveData.getString(customColumnEntity.getProperty()))) continue;
                    saveMap.put(customColumnEntity.getProperty(), saveData.getString(customColumnEntity.getProperty()));
                }
            }
            Long mainPkId = entity.getMainId();
            try {
                UpdateResponse response;
                GetRequest getRequest = new GetRequest(mainTableEntity.getTableName(), mainPkId.toString());
                GetResponse mainResponse = this.client.get(getRequest, RequestOptions.DEFAULT);
                if (mainResponse.isExists()) {
                    UpdateRequest updateRequest = new UpdateRequest(mainTableEntity.getTableName(), mainPkId.toString());
                    updateRequest.doc(saveMap, XContentType.JSON);
                    response = this.client.update(updateRequest, RequestOptions.DEFAULT);
                    if (response.status().getStatus() != RestStatus.OK.getStatus()) {
                        this.logger.info("\u4e3b\u8868\u540c\u6b65\u5931\u8d25\uff01appCode={},id={},error={}", new Object[]{pageCode, mainPkId, response.toString()});
                    }
                } else {
                    IndexRequest indexRequest = new IndexRequest(mainTableEntity.getTableName());
                    saveMap.put(ID, mainPkId + "");
                    indexRequest.id(mainPkId + "");
                    saveMap.put(ORG_ID, saveData.getString(ORG_ID));
                    saveMap.put(BILL_STATE, saveData.getString(BILL_STATE));
                    saveMap.put(CREATE_USER, saveData.getString(CREATE_USER));
                    indexRequest.source(saveMap, XContentType.JSON);
                    response = this.client.index(indexRequest, RequestOptions.DEFAULT);
                    if (response.status().getStatus() == RestStatus.CREATED.getStatus()) {
                        saveData.put(ID, saveMap.get(ID));
                        saveData.put(ORG_ID, saveMap.get(ORG_ID));
                        saveData.put(BILL_STATE, saveMap.get(BILL_STATE));
                        saveData.put(CREATE_USER, saveMap.get(CREATE_USER));
                    } else {
                        this.logger.error(response.toString());
                        this.logger.info("\u4e3b\u8868\u540c\u6b65\u5931\u8d25\uff01appCode={},id={},error={}", new Object[]{pageCode, mainPkId, response.toString()});
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.logger.info("\u4e3b\u8868\u540c\u6b65\u5931\u8d25\uff01appCode={},id={},error={}", (Object)pageCode, (Object)mainPkId);
            }
            if (!ListUtil.isNotEmpty(childTableEntities = this.customTableService.queryChildTablesByMainTableId(mainTableEntity.getId()))) continue;
            for (CustomTableEntity childTableEntity : childTableEntities) {
                JSONArray childDatas;
                List<CustomColumnEntity> childColumnEntities = this.customColumnService.queryColumnsByTableId(childTableEntity.getId());
                if (!ListUtil.isNotEmpty(childColumnEntities) || !ListUtil.isNotEmpty((List)(childDatas = saveData.getJSONArray(childTableEntity.getUiKey())))) continue;
                for (int i = 0; i < childDatas.size(); ++i) {
                    JSONObject childData = childDatas.getJSONObject(i);
                    childData.put("rowIndex", (Object)i);
                    String rowState = childData.getString("rowState");
                    if (DEL.equals(rowState) && StringUtils.isNotEmpty((CharSequence)childData.getString(ID))) continue;
                    HashMap<String, Object> childSaveMap = new HashMap<String, Object>();
                    for (CustomColumnEntity childColumnEntity : childColumnEntities) {
                        if (ID.equals(childColumnEntity.getProperty())) {
                            String value = childData.getString(childColumnEntity.getProperty());
                            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                            childSaveMap.put(childColumnEntity.getProperty(), childData.getString(childColumnEntity.getProperty()));
                            continue;
                        }
                        childSaveMap.put(childColumnEntity.getProperty(), childData.getString(childColumnEntity.getProperty()));
                    }
                    childSaveMap.put("rowIndex", i);
                    try {
                        GetRequest getRequest = new GetRequest(childTableEntity.getTableName(), childData.get((Object)ID).toString());
                        GetResponse mainResponse = this.client.get(getRequest, RequestOptions.DEFAULT);
                        if (mainResponse.isExists()) {
                            UpdateRequest updateRequest = new UpdateRequest(childTableEntity.getTableName(), childData.get((Object)ID).toString());
                            updateRequest.doc(childSaveMap, XContentType.JSON);
                            this.client.update(updateRequest, RequestOptions.DEFAULT);
                            continue;
                        }
                        IndexRequest indexRequest = new IndexRequest(childTableEntity.getTableName());
                        Long childPkId = (Long)childSaveMap.get(ID);
                        childSaveMap.put(ID, childPkId + "");
                        childSaveMap.put(PID, mainPkId + "");
                        childSaveMap.put(CREATE_USER, childData.get((Object)CREATE_USER));
                        childSaveMap.put(CREATE_TIME, childData.get((Object)CREATE_TIME));
                        indexRequest.id(childPkId + "");
                        indexRequest.source(childSaveMap, XContentType.JSON);
                        IndexResponse response = this.client.index(indexRequest, RequestOptions.DEFAULT);
                        if (response.status().getStatus() == RestStatus.CREATED.getStatus()) continue;
                        this.logger.info("\u5b50\u8868\u540c\u6b65\u5931\u8d25\uff01appCode={},id={},error={}", new Object[]{pageCode, mainPkId, response.toString()});
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.logger.info("\u5b50\u8868\u540c\u6b65\u5931\u8d25\uff01appCode={},id={},error={}", new Object[]{pageCode, mainPkId, e.getMessage()});
                    }
                }
            }
        }
    }

    private BoolQueryBuilder setParam(BoolQueryBuilder boolQuery, Map<String, Parameter> paramMap) {
        for (Map.Entry<String, Parameter> entry : paramMap.entrySet()) {
            Parameter param = entry.getValue();
            if (param.getValue() == null || StringUtils.isBlank((CharSequence)(param.getValue() + ""))) continue;
            if ("eq".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)entry.getKey(), (String)param.getValue().toString()));
                continue;
            }
            if ("like".equals(param.getType())) {
                boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)entry.getKey(), (Object)param.getValue().toString()));
                continue;
            }
            if ("in".equals(param.getType())) {
                Object inParam = param.getValue();
                if (inParam instanceof String) {
                    boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)entry.getKey(), Arrays.asList(inParam.toString().split(","))));
                    continue;
                }
                if (!(inParam instanceof JSONArray)) continue;
                boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)entry.getKey(), (Collection)JSONObject.parseArray((String)JSONObject.toJSONString((Object)inParam), Long.class)));
                continue;
            }
            if ("between".equals(param.getType())) {
                String[] dataArr = param.getValue().toString().split(",");
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).from((Object)dataArr[0]).to((Object)dataArr[1]).includeLower(true).includeUpper(true));
                continue;
            }
            if ("gt".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).gt((Object)param.getValue().toString()));
                continue;
            }
            if ("ge".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).gte((Object)param.getValue().toString()));
                continue;
            }
            if ("lt".equals(param.getType())) {
                boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).lt((Object)param.getValue().toString()));
                continue;
            }
            if (!"le".equals(param.getType())) continue;
            boolQuery.filter().add(QueryBuilders.rangeQuery((String)entry.getKey()).lte((Object)param.getValue().toString()));
        }
        return boolQuery;
    }

    private BoolQueryBuilder parseComplexParams(List<ComplexParam> complexParams) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        for (ComplexParam cp : complexParams) {
            if ("and".equals(cp.getLogic())) {
                if (!cp.getParams().isEmpty()) {
                    boolQuery.must((QueryBuilder)this.setParam(QueryBuilders.boolQuery(), cp.getParams()));
                }
                if (!CollectionUtils.isNotEmpty((Collection)cp.getComplexParams())) continue;
                boolQuery.must((QueryBuilder)this.parseComplexParams(cp.getComplexParams()));
                continue;
            }
            if (!cp.getParams().isEmpty()) {
                boolQuery.should((QueryBuilder)this.setParam(QueryBuilders.boolQuery(), cp.getParams()));
            }
            if (!CollectionUtils.isNotEmpty((Collection)cp.getComplexParams())) continue;
            boolQuery.should((QueryBuilder)this.parseComplexParams(cp.getComplexParams()));
        }
        return boolQuery;
    }

    private IPage<JSONObject> queryPage(Map<String, Parameter> paramMap, SearchRequest searchRequest) throws IOException {
        Page page = new Page();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        SearchResponse response = this.client.search(searchRequest, RequestOptions.DEFAULT);
        for (SearchHit hit : response.getHits()) {
            Map source = hit.getSourceAsMap();
            Map highlightFields = hit.getHighlightFields();
            for (Map.Entry highlightEntry : highlightFields.entrySet()) {
                HighlightField nameField;
                Parameter parameter;
                if (!paramMap.containsKey(highlightEntry.getKey()) || !StringUtils.isNotBlank((CharSequence)((parameter = paramMap.get(highlightEntry.getKey())).getValue() + "")) || (nameField = (HighlightField)highlightEntry.getValue()) == null) continue;
                Text[] fragments = nameField.fragments();
                StringBuilder nameTmp = new StringBuilder();
                for (Text text : fragments) {
                    nameTmp.append(text);
                }
                source.put(highlightEntry.getKey(), nameTmp.toString());
            }
        }
        SearchHits hits = response.getHits();
        for (SearchHit hit : hits) {
            list.add(new JSONObject(hit.getSourceAsMap()));
        }
        page.setRecords(list);
        page.setTotal(hits.getTotalHits().value);
        return page;
    }
}

