package com.ejianc.foundation.cfs.controller;

import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.bpm.vo.BpmApproveHistoryInfo;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomDataEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomDataService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.foundation.cfs.util.BillStateEnum;
import com.ejianc.foundation.cfs.util.ExcelExportUtil;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.mongodb.template.MongodbCrudTemplate;
import com.ejianc.support.idworker.util.IdWorker;

@RestController
@RequestMapping("custom/table")
public class CustomTableMongoController implements Serializable {
    private static final long serialVersionUID = 8717661796833595475L;

    private Logger logger = LoggerFactory.getLogger(getClass());
    private final static String ID = "id";
    private final static String DEL = "del";
    private final static String PID = "pid";
    private final static String ORG_ID = "orgId";
    private final static String CREATE_USER = "createUser";
    private final static String CREATE_TIME = "createTime";
    private final static String BILL_STATE = "billState";

    @Autowired
    private ICustomAppService customAppService;
    @Autowired
    private ICustomTableService customTableService;
    @Autowired
    private ICustomColumnService customColumnService;
    @Autowired
    private ICustomDataService iCustomDataService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private MongodbCrudTemplate mongoTemplate;
    @Autowired
	private IBpmApi bpmApi;

    /**
     * 保存或修改
     *
     * @param pageCode
     * @param saveData
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/{pageCode}/save", method = RequestMethod.POST)
    public CommonResponse<JSONObject> save(@PathVariable String pageCode, @RequestBody JSONObject saveData) throws IOException {
        if (StringUtils.isBlank(pageCode)) {
            logger.error("应用编号不能为空！");
            return CommonResponse.error("应用编号不能为空！");
        }
        //根据应用编号查询应用
        CustomAppEntity app = customAppService.queryCustomAppByCode(pageCode);
        //根据appid查询主表信息
        CustomTableEntity mainTableEntity = customTableService.queryMainTableByAppId(app.getId());
        //根据主表ID查询所有主数据列
        List<CustomColumnEntity> mainColumnEntities = customColumnService.queryColumnsByTableId(mainTableEntity.getId());
        //
        if (saveData != null) {
            if (mainColumnEntities != null && mainColumnEntities.size() > 0) {
                for (CustomColumnEntity col : mainColumnEntities) {
                    /** 数据唯一性校验 */
                    if (col.getUniqued() != null && col.getUniqued()) {
                        String v = saveData.getString(col.getProperty());
                        if (StringUtils.isNotEmpty(v)) {
                            QueryParam queryParam = new QueryParam();
                            queryParam.getParams().put(col.getProperty(), new Parameter(QueryParam.EQ, v));
                            IPage<JSONObject> pages = getPageListData(app, queryParam, InvocationInfoProxy.getOrgId());
                            /** 新增唯一性 */
                            if (StringUtils.isBlank(saveData.getString(ID))) {
                                if (pages.getTotal() > 0) {
                                    return CommonResponse.error(col.getColumnName() + "重复，请重新输入！");
                                }
                            } else {
                                /** 修改唯一性 */
                                if (pages.getTotal() > 1) {
                                    return CommonResponse.error(col.getColumnName() + "重复，请重新输入！");
                                } else if (pages.getTotal() == 1) {
                                    if (!saveData.getString(ID).equals(pages.getRecords().get(0).getString(ID))) {
                                        return CommonResponse.error(col.getColumnName() + "重复，请重新输入！");
                                    }
                                }
                            }
                        }
                    }
                }
                for (CustomColumnEntity customColumnEntity : mainColumnEntities) {
                    if (ID.equals(customColumnEntity.getProperty())) {
                        String value = saveData.getString(customColumnEntity.getProperty());
                        if (StringUtils.isNotBlank(value)) {
                        	saveData.put(customColumnEntity.getProperty(), saveData.getString(customColumnEntity.getProperty()));
                        }else{
                        	saveData.remove(customColumnEntity.getProperty());
                        }
                    } else {
                    	if ("refer".equals(customColumnEntity.getType())) {
                            if (saveData.getJSONObject(customColumnEntity.getProperty()) != null) {
                            	saveData.put(customColumnEntity.getProperty(), saveData.getJSONObject(customColumnEntity.getProperty()).toJSONString());
                            }
                        } else if ("date".equals(customColumnEntity.getType())) {
                            if (StringUtils.isNotEmpty(saveData.getString(customColumnEntity.getProperty()))) {
                                String dateString = saveData.getString(customColumnEntity.getProperty());
                                String val = customColumnEntity.getVal();
                                if(StringUtils.isNotEmpty(val)){
                                    JSONObject col = JSONObject.parseObject(val);
                                    if(StringUtils.isNotEmpty(col.getString("format")) && col.getString("format").length()!=dateString.length()){
                                        if (dateString.length() == 10 && col.getString("format").length() == 19) {
                                            dateString = dateString + " 00:00:00";
                                        }
                                        if (dateString.length() == 19 && col.getString("format").length() == 10) {
                                            dateString = dateString.substring(0,10);
                                        }
                                    }
                                }
                                saveData.put(customColumnEntity.getProperty(), dateString);
                            }
                        } else {
                            if (StringUtils.isNotEmpty(saveData.getString(customColumnEntity.getProperty()))) {
                            	saveData.put(customColumnEntity.getProperty(), saveData.getString(customColumnEntity.getProperty()));
                            }
                        }
                    }
                }
            }

            Long mainPkId = 0L;
            if (!saveData.containsKey(ID)) {
                mainPkId = IdWorker.getId();
                saveData.put(ID, mainPkId + "");
                saveData.put(ORG_ID, InvocationInfoProxy.getOrgId() + "");
                saveData.put(BILL_STATE, 0);
                saveData.put(CREATE_USER, InvocationInfoProxy.getUserid() + "");
                
            }else{
            	mainPkId = saveData.getLong("id");
            	saveData.put(BILL_STATE, Integer.parseInt(saveData.getString(BILL_STATE)));
            }
            //查询子表
            List<CustomTableEntity> childTableEntities = customTableService.queryChildTablesByMainTableId(mainTableEntity.getId());
            if (ListUtil.isNotEmpty(childTableEntities)) {
                for (CustomTableEntity childTableEntity : childTableEntities) {
                    //查询子表所有列
                    List<CustomColumnEntity> childColumnEntities = customColumnService.queryColumnsByTableId(childTableEntity.getId());

                    if (ListUtil.isNotEmpty(childColumnEntities)) {
                        JSONArray childDatas = saveData.getJSONArray(childTableEntity.getUiKey());
                        JSONArray saveChildData = new JSONArray();
                        if (ListUtil.isNotEmpty(childDatas)) {
                            for (int i = 0; i < childDatas.size(); i++) {
                                JSONObject childData = childDatas.getJSONObject(i);
                                childData.put("rowIndex", i);
                                String rowState = childData.getString("rowState");
                                if (DEL.equals(rowState) && StringUtils.isNotEmpty(childData.getString(ID))) {} else {
                                    for (CustomColumnEntity childColumnEntity : childColumnEntities) {
                                        if (ID.equals(childColumnEntity.getProperty())) {
                                            String value = childData.getString(childColumnEntity.getProperty());
                                            if (StringUtils.isNotBlank(value)) {
                                            	childData.put(childColumnEntity.getProperty(), childData.getString(childColumnEntity.getProperty()));
                                            }else{
                                            	childData.remove(childColumnEntity.getProperty());
                                            }
                                        } else {
                                        	if ("refer".equals(childColumnEntity.getType())) {
                                                if (saveData.getJSONObject(childColumnEntity.getProperty()) != null) {
                                                	saveData.put(childColumnEntity.getProperty(), saveData.getJSONObject(childColumnEntity.getProperty()).toJSONString());
                                                }
                                            } else if ("date".equals(childColumnEntity.getType())) {
                                                if (StringUtils.isNotEmpty(childData.getString(childColumnEntity.getProperty()))) {
                                                    String dateString = childData.getString(childColumnEntity.getProperty());
                                                    String val = childColumnEntity.getVal();
                                                    if(StringUtils.isNotEmpty(val)){
                                                        JSONObject col = JSONObject.parseObject(val);
                                                        if(StringUtils.isNotEmpty(col.getString("format")) && col.getString("format").length()!=dateString.length()){
                                                            if (dateString.length() == 10 && col.getString("format").length() == 19) {
                                                                dateString = dateString + " 00:00:00";
                                                            }
                                                            if (dateString.length() == 19 && col.getString("format").length() == 10) {
                                                                dateString = dateString.substring(0,10);
                                                            }
                                                        }
                                                    }
                                                    childData.put(childColumnEntity.getProperty(), dateString);
                                                }
                                            } else {
                                                childData.put(childColumnEntity.getProperty(), childData.getString(childColumnEntity.getProperty()));
                                            }
                                        }
                                    }
                                    logger.info("childData i={},数据：{}", i, JSONObject.toJSONString(childData));
                                    Long childPkId;
                                    if (childData.containsKey(ID)) {
                                        childPkId = childData.getLong(ID);
                                    } else {
                                        childPkId = IdWorker.getId();
                                        
                                        childData.put(ID, childPkId + "");
                                        childData.put(PID, mainPkId + "");
                                        childData.put(CREATE_USER, InvocationInfoProxy.getUserid() + "");
                                        childData.put(CREATE_TIME, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                        childData.put("rowState", null);
                                    }
                                    /** 处理子表附件 */
                                    List<Long> attachIds = new ArrayList<>();
                                    JSONArray array = childData.getJSONArray("attachIds");
                                    if (array != null && array.size() > 0) {
                                        for (int j = 0; j < array.size(); j++) {
                                            Long attrId = array.getLong(j);
                                            attachIds.add(attrId);
                                        }
                                    }
                                    logger.info("处理子表附件 attachIds----{}" ,JSONObject.toJSONString(attachIds));
                                    if (ListUtil.isNotEmpty(attachIds)) {
                                        CommonResponse<String> res = attachmentApi.updateAttachRef(childPkId, attachIds);
                                        logger.info("处理子表附件 attachIds----CommonResponse {}" ,JSONObject.toJSONString(res));
                                    }
                                    saveChildData.add(childData);
                                }
                            }
                        }
                        saveData.put(childTableEntity.getUiKey(), saveChildData);
                    }
                }
            }

            /** 处理附件 */
            List<Long> attachIds = new ArrayList<>();
            JSONArray array = saveData.getJSONArray("attachIds");
            if (array != null && array.size() > 0) {
                for (int i = 0; i < array.size(); i++) {
                    Long attrId = array.getLong(i);
                    attachIds.add(attrId);
                }
            }
            logger.info("attachIds----{}" ,JSONObject.toJSONString(attachIds));
            if (ListUtil.isNotEmpty(attachIds)) {
                CommonResponse<String> res = attachmentApi.updateAttachRef(mainPkId, attachIds);
                logger.info("attachIds----CommonResponse {}" ,JSONObject.toJSONString(res));
            }
            /** 持久化到数据库 */
            QueryParam dataParam = new QueryParam();
            dataParam.getParams().put("mainId", new Parameter(QueryParam.EQ, mainPkId));
            List<CustomDataEntity> dataEntityList = iCustomDataService.queryList(dataParam, false);
            CustomDataEntity customDataEntity = null;
            if (ListUtil.isEmpty(dataEntityList)) {
                customDataEntity = new CustomDataEntity();
                customDataEntity.setMainId(mainPkId);
                customDataEntity.setAppCode(pageCode);
            } else {
                customDataEntity = dataEntityList.get(0);
            }
            customDataEntity.setData(saveData.toJSONString());
            
            mongoTemplate.insertOrUpdate(saveData, mainTableEntity.getTableName());
            iCustomDataService.saveOrUpdate(customDataEntity, false);
        }
        return CommonResponse.success("保存成功", saveData);
    }

    public static void main(String[] args) {
        String s ="2023-01-05 00:00:00";
        System.out.println(s.substring(0,10));
    }
    /**
     * 查询列表
     *
     * @param pageCode
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/{pageCode}/pageList", method = RequestMethod.POST)
    public CommonResponse<IPage<JSONObject>> pageList(@PathVariable String pageCode, @RequestBody QueryParam queryParam) {
        Long orgId = InvocationInfoProxy.getOrgId();
        //根据应用编号查询应用
        CustomAppEntity app = customAppService.queryCustomAppByCode(pageCode);

        return CommonResponse.success(getPageListData(app, queryParam, orgId));
    }
    /**
     * 导出查询结果
     *
     * @param pageCode
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/{pageCode}/export", method = RequestMethod.POST)
    @ResponseBody
    public void export(@PathVariable String pageCode, @RequestBody QueryParam queryParam,
                                                    HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long orgId = InvocationInfoProxy.getOrgId();
        //根据应用编号查询应用
        CustomAppEntity app = customAppService.queryCustomAppByCode(pageCode);
        IPage<JSONObject> pageData = getPageListData(app, queryParam, orgId);
        ExcelExportUtil excelExport = new ExcelExportUtil();
        List<JSONObject> res = getExportData(pageData.getRecords(),app.getId());
        if(ListUtil.isEmpty(res)){
            return;
        }
        CustomTableEntity mainTableEntity = customTableService.queryMainTableByAppId(app.getId());
        excelExport.setData(res);

        List<String> properties = new ArrayList<>();
        List<String> titleList = new ArrayList<>();

        QueryParam param = new QueryParam();
        param.getParams().put("customTableId", new Parameter(QueryParam.EQ, mainTableEntity.getId()));
        List<CustomColumnEntity> list = customColumnService.queryList(param,false);
        if(ListUtil.isNotEmpty(list)){
            for (CustomColumnEntity customListEntity : list) {
                if(!(Objects.equals(customListEntity.getProperty(),"createUser") ||
                        Objects.equals(customListEntity.getProperty(),"orgId") ||
                        Objects.equals(customListEntity.getProperty(),"id"))){
                    properties.add(customListEntity.getProperty());
                    titleList.add(customListEntity.getColumnName());
                }
            }
        }
        if(properties.size() > 0) {
            excelExport.setHeardKey(properties.toArray(new String[properties.size()]));
            excelExport.setFontSize(12);
            excelExport.setSheetName(app.getAppName());
            excelExport.setTitle(app.getAppName());
            excelExport.setHeardList(titleList.toArray(new String[titleList.size()]));
            excelExport.exportExport(response);
        }
    }

    private List<JSONObject> getExportData(List<JSONObject> list,Long appId){
        List<JSONObject> res = new ArrayList<>();
        //根据appid查询主表信息
        CustomTableEntity mainTableEntity = customTableService.queryMainTableByAppId(appId);
        /** 主表字段 */
        List<CustomColumnEntity> mainCols = customColumnService.queryColumnsByTableId(mainTableEntity.getId());
        if(ListUtil.isNotEmpty(list)){
            for (JSONObject mainDetail : list) {
                for (CustomColumnEntity col:mainCols){
                    if("refer".equals(col.getType())){
                        if(StringUtils.isNotEmpty(mainDetail.getString(col.getProperty()))){
                            mainDetail.put(col.getProperty(),JSONObject.parseObject(mainDetail.getString(col.getProperty())).getString("name"));
                        }
                    }
                    if("select".equals(col.getType())){
                        if(StringUtils.isNotEmpty(mainDetail.getString(col.getProperty()))){
                            mainDetail.put(col.getProperty(),JSONObject.parseObject(mainDetail.getString(col.getProperty())).getString("text"));
                        }
                    }
                    if("billState".equals(col.getProperty())){
                        if(StringUtils.isNotEmpty(mainDetail.getString(col.getProperty()))){
                            mainDetail.put(col.getProperty(), BillStateEnum.getEnumByStateCode(mainDetail.getInteger(col.getProperty())).getDescription());
                        }
                    }
                    if("integer".equals(col.getType()) && !"billState".equals(col.getProperty())){
                        String[] names = StringUtils.isNotEmpty(col.getVal())?col.getVal().split(","):new String[]{"是","否"};
                        if("1".equals(mainDetail.getString(col.getProperty()))){
                            mainDetail.put(col.getProperty(),names[0]);
                        }else {
                            mainDetail.put(col.getProperty(),names[1]);
                        }
                    }
                }
                res.add(mainDetail);
            }
        }
        return res;
    }

    private IPage<JSONObject> getPageListData(CustomAppEntity app, QueryParam queryParam, Long orgId) {
        if (app.getQueryRange() == 0 || //设置本下
                (app.getQueryRange() == 1 && queryParam.getParams().get("createUser") == null)//设置查询个人又未选择个人默认本下
        ) {//本下
            CommonResponse<List<OrgVO>> orgVoResponse = orgApi.findChildrenByParentId(orgId);
            if (orgVoResponse.isSuccess()) {
                List<OrgVO> orgVos = orgVoResponse.getData();
                StringBuffer orgIdBuffer = new StringBuffer();
                for (OrgVO orgVo : orgVos) {
                    orgIdBuffer.append(orgVo.getId()).append(",");
                }
                queryParam.getParams().put("orgId", new Parameter(QueryParam.IN, orgIdBuffer.substring(0, orgIdBuffer.length() - 1)));
            }
        }

        //根据appid查询主表信息
        CustomTableEntity mainTableEntity = customTableService.queryMainTableByAppId(app.getId());

        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        IPage<JSONObject> page = mongoTemplate.queryPage(queryParam, mainTableEntity.getTableName());
        return page;
    }

    @PostMapping(value = "/pageList/{appId}")
    public CommonResponse<JSONObject> pageListByAppId(@PathVariable Long appId, @RequestBody QueryParam queryParam) {
        JSONObject resp = new JSONObject();
        JSONObject appJson = new JSONObject();
        Long orgId = InvocationInfoProxy.getOrgId();
        //根据应用编号查询应用
        CustomAppEntity app = customAppService.selectById(appId);
        if (null == app) {
            return CommonResponse.error("查询自定义应用数据失败，无匹配的应用信息！");
        }
        IPage<JSONObject> page = getPageListData(app, queryParam, orgId);

        if (ListUtil.isNotEmpty(page.getRecords())) {
            //根据appid查询主表信息
            CustomTableEntity mainTableEntity = customTableService.queryMainTableByAppId(app.getId());
            //根据主表ID查询所有主数据列
            List<CustomColumnEntity> mainColumnEntities = customColumnService.queryColumnsByTableId(mainTableEntity.getId());
            page.getRecords().forEach(o -> mainColumnEntities.forEach(col -> {
                if ("refer".equals(col.getType()) || "select".equals(col.getType())) {
                    if (o.get(col.getProperty()) != null) {
                        JSONObject data = JSONObject.parseObject(o.getString(col.getProperty()));
                        if (StringUtils.isNotEmpty(data.getString("name"))) {
                            o.put(col.getProperty(), data.getString("name"));
                        } else if (StringUtils.isNotEmpty(data.getString("text"))) {
                            o.put(col.getProperty(), data.getString("text"));
                        }
                    }
                }
                if ("billState".equals(col.getProperty())) {
                    o.put(col.getProperty(), BillStateEnum.getEnumByStateCode(o.getInteger(col.getProperty())).getDescription());
                }
            }));
        }

        appJson.put("count", page.getTotal());
        appJson.put("dbType", "0");
        appJson.put("isList", "1");
        appJson.put("isPage", "1");
        appJson.put("linkList", null);
        appJson.put("expData", new JSONObject());
        appJson.put("list", page.getRecords());
        appJson.put("total", page.getPages());

        resp.put(app.getAppCode(), appJson);

        return CommonResponse.success(resp);
    }

    /**
     * 根据主键IDS进行删除
     *
     * @param pageCode 应用编号
     * @param ids
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/{pageCode}/delete", method = RequestMethod.POST)
    public CommonResponse<String> delete(@PathVariable String pageCode, @RequestBody List<String> ids) throws IOException {
        //根据应用编号查询应用
        CustomAppEntity app = customAppService.queryCustomAppByCode(pageCode);
        //根据appid查询主表信息
        CustomTableEntity mainTableEntity = customTableService.queryMainTableByAppId(app.getId());

        for (String id : ids) {
            //删除主表数据
        	mongoTemplate.deleteById(id, mainTableEntity.getTableName());
            /** 删除持久化数据 */
            QueryParam dataParam = new QueryParam();
            dataParam.getParams().put("mainId", new Parameter(QueryParam.EQ, id));
            List<CustomDataEntity> dataEntityList = iCustomDataService.queryList(dataParam, false);
            if (ListUtil.isNotEmpty(dataEntityList)) {
                iCustomDataService.removeById(dataEntityList.get(0).getId(), false);
            }
        }
        return CommonResponse.success("删除成功");
    }

    /**
     * 根据主键ID进行查询
     *
     * @param pageCode 页面编号
     * @param id
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/{pageCode}/queryDetail", method = RequestMethod.GET)
    public CommonResponse<JSONObject> queryDetail(@PathVariable String pageCode, @RequestParam String id) throws IOException {
    	CustomAppEntity app = customAppService.queryCustomAppByCode(pageCode);
		//根据appid查询主表信息
		CustomTableEntity mainTableEntity = customTableService.queryMainTableByAppId(app.getId());
		
		JSONObject jsonObject = mongoTemplate.selectById(id, mainTableEntity.getTableName());
		
        return CommonResponse.success(jsonObject);
    }

    /**
     * 根据主键ID进行查询
     *
     * @param pageCode 页面编号
     * @param id
     * @return
     * @throws IOException
     */
    @RequestMapping(value = "/{pageCode}/queryPrintDetail", method = RequestMethod.GET)
    public CommonResponse<JSONObject> queryPrintDetail(@PathVariable String pageCode, @RequestParam String id) throws IOException {
    	//根据应用编号查询应用
		CustomAppEntity app = customAppService.queryCustomAppByCode(pageCode);
		//根据appid查询主表信息
		CustomTableEntity mainTableEntity = customTableService.queryMainTableByAppId(app.getId());
		/** 主表字段 */
		List<CustomColumnEntity> mainCols = customColumnService.queryColumnsByTableId(mainTableEntity.getId());
		
		JSONObject mainDetail = mongoTemplate.selectById(id, mainTableEntity.getTableName());
		
		for (CustomColumnEntity col:mainCols){
			if("refer".equals(col.getType())){
				if(StringUtils.isNotEmpty(mainDetail.getString(col.getProperty()))){
					mainDetail.put(col.getProperty(),JSONObject.parseObject(mainDetail.getString(col.getProperty())).getString("name"));
				}
			}
			if("select".equals(col.getType())){
				if(StringUtils.isNotEmpty(mainDetail.getString(col.getProperty()))){
					mainDetail.put(col.getProperty(),JSONObject.parseObject(mainDetail.getString(col.getProperty())).getString("text"));
				}
			}
			if("billState".equals(col.getProperty())){
				if(StringUtils.isNotEmpty(mainDetail.getString(col.getProperty()))){
					mainDetail.put(col.getProperty(), BillStateEnum.getEnumByStateCode(mainDetail.getInteger(col.getProperty())).getDescription());
				}
			}
			if("integer".equals(col.getType()) && !"billState".equals(col.getProperty())){
				String[] names = StringUtils.isNotEmpty(col.getVal())?col.getVal().split(","):new String[]{"是","否"};
				if("1".equals(mainDetail.getString(col.getProperty()))){
					mainDetail.put(col.getProperty(),names[0]);
				}else {
					mainDetail.put(col.getProperty(),names[1]);
				}
			}
		}
		
		//查询子表
		List<CustomTableEntity> childTableEntities = customTableService.queryChildTablesByMainTableId(mainTableEntity.getId());
		if(childTableEntities != null && childTableEntities.size() > 0) {
			for(CustomTableEntity childTableEntity:childTableEntities) {
				/** 子表字段 */
				List<CustomColumnEntity> subCols = customColumnService.queryColumnsByTableId(childTableEntity.getId());

				JSONArray subTbsData = new JSONArray();
				try {
					JSONArray detailObjs = mainDetail.getJSONArray(childTableEntity.getUiKey());
					for (int i=0; i< detailObjs.size(); i++) {
						JSONObject subDetail = detailObjs.getJSONObject(i);
						for (CustomColumnEntity col:subCols){
							if("refer".equals(col.getType())){
								if(StringUtils.isNotEmpty(subDetail.getString(col.getProperty()))){
									subDetail.put(col.getProperty(),JSONObject.parseObject(subDetail.getString(col.getProperty())).getString("name"));
								}
							}
							if("select".equals(col.getType())){
								if(StringUtils.isNotEmpty(subDetail.getString(col.getProperty()))){
									subDetail.put(col.getProperty(),JSONObject.parseObject(subDetail.getString(col.getProperty())).getString("text"));
								}
							}
							if("integer".equals(col.getType())){
								String[] names = StringUtils.isNotEmpty(col.getVal())?col.getVal().split(","):new String[]{"是","否"};
								if("1".equals(subDetail.getString(col.getProperty()))){
									subDetail.put(col.getProperty(),names[0]);
								}else {
									subDetail.put(col.getProperty(),names[1]);
								}
							}
						}
						subTbsData.add(subDetail);
					}
					mainDetail.put(childTableEntity.getUiKey(), subTbsData);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		
		//自由态，直接提交，审批不通过---不查询审批历史
		CommonResponse<List<BpmApproveHistoryInfo>> approveList = bpmApi.queryHistoryById(Long.parseLong(id));
		mainDetail.put("ApproveInfo", approveList.getData());
    			
        return CommonResponse.success(mainDetail);
    }

    /**
     * 同步数据到mongo
     *
     * @param pageCode
     * @return
     */
    @RequestMapping(value = "/syncToMongo", method = RequestMethod.GET)
    public CommonResponse<String> syncToMongo(@RequestParam String pageCode) {

        Thread runnable = new Thread(() -> {
            QueryParam dataParam = new QueryParam();
            dataParam.getParams().put("appCode", new Parameter(QueryParam.EQ, pageCode));
            int index = 1;
            dataParam.setPageIndex(index);
            dataParam.setPageSize(500);
            IPage<CustomDataEntity> page = iCustomDataService.queryPage(dataParam, false);
            while (ListUtil.isNotEmpty(page.getRecords())) {
                saveToMongo(page.getRecords(), pageCode);
                index++;
                dataParam.setPageIndex(index);
                page = iCustomDataService.queryPage(dataParam, false);
            }
        });
        runnable.start();
        return CommonResponse.success("同步任务已提交，系统在后台处理中...");
    }

    private void saveToMongo(List<CustomDataEntity> entities, String pageCode) {
        //根据应用编号查询应用
        CustomAppEntity app = customAppService.queryCustomAppByCode(pageCode);
        //根据appid查询主表信息
        CustomTableEntity mainTableEntity = customTableService.queryMainTableByAppId(app.getId());
        //根据主表ID查询所有主数据列
        List<CustomColumnEntity> mainColumnEntities = customColumnService.queryColumnsByTableId(mainTableEntity.getId());
        for (CustomDataEntity entity : entities) {
            JSONObject saveData = JSONObject.parseObject(entity.getData());

            for (CustomColumnEntity customColumnEntity : mainColumnEntities) {
                if (ID.equals(customColumnEntity.getProperty())) {
                    String value = saveData.getString(customColumnEntity.getProperty());
                    if (StringUtils.isNotBlank(value)) {
                    	saveData.put(customColumnEntity.getProperty(), saveData.getString(customColumnEntity.getProperty()));
                    }else{
                    	saveData.remove(customColumnEntity.getProperty());
                    }
                } else {
                	if ("refer".equals(customColumnEntity.getType())) {
                        if (saveData.getJSONObject(customColumnEntity.getProperty()) != null) {
                        	saveData.put(customColumnEntity.getProperty(), saveData.getJSONObject(customColumnEntity.getProperty()).toJSONString());
                        }
                    } else if ("date".equals(customColumnEntity.getType())) {
                        if (StringUtils.isNotEmpty(saveData.getString(customColumnEntity.getProperty()))) {
                            String dateString = saveData.getString(customColumnEntity.getProperty());
                            String val = customColumnEntity.getVal();
                            if(StringUtils.isNotEmpty(val)){
                                JSONObject col = JSONObject.parseObject(val);
                                if(StringUtils.isNotEmpty(col.getString("format")) && col.getString("format").length()!=dateString.length()){
                                    if (dateString.length() == 10 && col.getString("format").length() == 19) {
                                        dateString = dateString + " 00:00:00";
                                    }
                                    if (dateString.length() == 19 && col.getString("format").length() == 10) {
                                        dateString = dateString.substring(0,10);
                                    }
                                }
                            }
                            saveData.put(customColumnEntity.getProperty(), dateString);
                        }
                    } else {
                        if (StringUtils.isNotEmpty(saveData.getString(customColumnEntity.getProperty()))) {
                        	saveData.put(customColumnEntity.getProperty(), saveData.getString(customColumnEntity.getProperty()));
                        }
                    }
                }
            }
        
            Long mainPkId = 0L;
	        if (!saveData.containsKey(ID)) {
	            mainPkId = IdWorker.getId();
	            saveData.put(ID, mainPkId + "");
	            saveData.put(ORG_ID, InvocationInfoProxy.getOrgId() + "");
	            saveData.put(BILL_STATE, 0);
	            saveData.put(CREATE_USER, InvocationInfoProxy.getUserid() + "");
	        }else{
            	mainPkId = saveData.getLong("id");
            	saveData.put(BILL_STATE, Integer.parseInt(saveData.getString(BILL_STATE)));
            }
	        //查询子表
	        List<CustomTableEntity> childTableEntities = customTableService.queryChildTablesByMainTableId(mainTableEntity.getId());
	        if (ListUtil.isNotEmpty(childTableEntities)) {
	            for (CustomTableEntity childTableEntity : childTableEntities) {
	                //查询子表所有列
	                List<CustomColumnEntity> childColumnEntities = customColumnService.queryColumnsByTableId(childTableEntity.getId());
	
	                if (ListUtil.isNotEmpty(childColumnEntities)) {
	                    JSONArray childDatas = saveData.getJSONArray(childTableEntity.getUiKey());
	                    JSONArray saveChildData = new JSONArray();
	                    if (ListUtil.isNotEmpty(childDatas)) {
	                        for (int i = 0; i < childDatas.size(); i++) {
	                            JSONObject childData = childDatas.getJSONObject(i);
	                            childData.put("rowIndex", i);
	                            String rowState = childData.getString("rowState");
	                            if (DEL.equals(rowState) && StringUtils.isNotEmpty(childData.getString(ID))) {} else {
	                                for (CustomColumnEntity childColumnEntity : childColumnEntities) {
	                                    if (ID.equals(childColumnEntity.getProperty())) {
	                                        String value = childData.getString(childColumnEntity.getProperty());
	                                        if (StringUtils.isNotBlank(value)) {
	                                        	childData.put(childColumnEntity.getProperty(), childData.getString(childColumnEntity.getProperty()));
	                                        }else{
	                                        	childData.remove(childColumnEntity.getProperty());
	                                        }
	                                    } else {
	                                    	if ("refer".equals(childColumnEntity.getType())) {
                                                if (saveData.getJSONObject(childColumnEntity.getProperty()) != null) {
                                                	saveData.put(childColumnEntity.getProperty(), saveData.getJSONObject(childColumnEntity.getProperty()).toJSONString());
                                                }
                                            } else if ("date".equals(childColumnEntity.getType())) {
	                                            if (StringUtils.isNotEmpty(childData.getString(childColumnEntity.getProperty()))) {
	                                                String dateString = childData.getString(childColumnEntity.getProperty());
	                                                String val = childColumnEntity.getVal();
	                                                if(StringUtils.isNotEmpty(val)){
	                                                    JSONObject col = JSONObject.parseObject(val);
	                                                    if(StringUtils.isNotEmpty(col.getString("format")) && col.getString("format").length()!=dateString.length()){
	                                                        if (dateString.length() == 10 && col.getString("format").length() == 19) {
	                                                            dateString = dateString + " 00:00:00";
	                                                        }
	                                                        if (dateString.length() == 19 && col.getString("format").length() == 10) {
	                                                            dateString = dateString.substring(0,10);
	                                                        }
	                                                    }
	                                                }
	                                                childData.put(childColumnEntity.getProperty(), dateString);
	                                            }
	                                        } else {
	                                            childData.put(childColumnEntity.getProperty(), childData.getString(childColumnEntity.getProperty()));
	                                        }
	                                    }
	                                }
	                                logger.info("childData i={},数据：{}", i, JSONObject.toJSONString(childData));
	                                if (childData.containsKey(ID)) {
	                                    saveChildData.add(childData);
	                                } else {
	                                    Long childPkId = IdWorker.getId();
	                                    
	                                    childData.put(ID, childPkId + "");
	                                    childData.put(PID, mainPkId + "");
	                                    childData.put(CREATE_USER, InvocationInfoProxy.getUserid() + "");
	                                    childData.put(CREATE_TIME, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
	                                    childData.put("rowState", null);
	                                    saveChildData.add(childData);
	                                }
	                            }
	                        }
	                    }
	                    saveData.put(childTableEntity.getUiKey(), saveChildData);
	                }
	            }
	        }
	        mongoTemplate.insertOrUpdate(saveData, mainTableEntity.getTableName());
        }
    }
}
