package com.ejianc.foundation.cfs.service.impl;

import java.util.List;
import java.util.stream.Collectors;

import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.mapper.CustomAppMapper;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.vo.CustomAppVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CustomAppServiceImpl extends BaseServiceImpl<CustomAppMapper, CustomAppEntity> implements ICustomAppService {

	@Autowired
	private CustomAppMapper customAppMapper;
	@Autowired
	private ICustomTableService customTableService;
	
	@Override
	public CustomAppEntity queryCustomAppByCode(String appCode) {
		QueryWrapper<CustomAppEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("app_code", appCode);
		CustomAppEntity customAppEntity = super.getOne(queryWrapper);
		return customAppEntity;
	}

	@Override
	public String getPageInitData(String pageName,String pageCode) {
		String data = "{" +
				"  \"uikey\": \"CfsCardPage\"," +
				"  \"uititle\": \""+pageName+"-卡片\"," +
				"  \"uitype\": \"EJCPage\"," +
				"  \"pageName\": \""+pageName+"\"," +
				"  \"children\": [" +
				"    {" +
				"      \"uititle\": \"面包屑\"," +
				"      \"uitype\": \"EJCBreadcrumb\"," +
				"      \"nid\": \"nid_1591858426687_5158\"," +
				"      \"children\": [" +
				"        {" +
				"          \"uitype\": \"EJCBreadcrumbItem\"," +
				"          \"uititle\": \""+pageName+"\"," +
				"          \"key\": 1591858271953," +
				"          \"uikey\": \"K"+System.currentTimeMillis()+"\"," +
				"          \"children\": \""+pageName+"\"," +
				"          \"nid\": \"nid_1591858426687_5156\"" +
				"        }," +
				"        {" +
				"          \"uitype\": \"EJCBreadcrumbItem\"," +
				"          \"uititle\": \"详情\"," +
				"          \"key\": 1591858273111," +
				"          \"uikey\": \"K"+System.currentTimeMillis()+"\"," +
				"          \"children\": \"详情\"," +
				"          \"nid\": \"nid_1591858426687_5157\"" +
				"        }" +
				"      ]," +
				"      \"uikey\": \"K"+System.currentTimeMillis()+"\"," +
				"      \"separator\": \">\"" +
				"    }," +
				"{"+
					"\"uititle\":\"右侧审批面板\","+
					"\"uitype\":\"EJCRightBpmPanel\","+
					"\"id\":\"nid_1647664365234_6790\","+
					"\"uikey\":\"rightBpmPanel\","+
					"      \"children\": [" +
				"    {" +
				"      \"uititle\": \"工具栏\"," +
				"      \"uitype\": \"EJCToolbar\"," +
				"      \"align\": \"right\"," +
				"      \"nid\": \"nid_1589191189933_125\"," +
				"      \"children\": [" +
				"        {" +
				"          \"uititle\": \"保存\"," +
				"          \"uitype\": \"EJCButton\"," +
				"          \"nid\": \"nid_1589191195164_126\"," +
				"          \"children\": \"保存\"," +
				"          \"uikey\": \"saveBtn\"," +
				"          \"type\": \"primary\"," +
				"          \"icon\": \"book\"," +
				"          \"visible\": false" +
				"        }," +
				"        {" +
				"          \"uititle\": \"取消\"," +
				"          \"uitype\": \"EJCButton\"," +
				"          \"nid\": \"nid_1590579221135_1157\"," +
				"          \"children\": \"取消\"," +
				"          \"uikey\": \"cancelBtn\"," +
				"          \"type\": \"primary\"," +
				"          \"ghost\": true," +
				"          \"icon\": \"cross-circle-o\"," +
				"          \"visible\": false" +
				"        }," +
				"        {" +
				"          \"uititle\": \"修改\"," +
				"          \"uitype\": \"EJCButton\"," +
				"          \"nid\": \"nid_1589191213644_129\"," +
				"          \"children\": \"修改\"," +
				"          \"uikey\": \"editBtn\"," +
				"          \"type\": \"primary\"," +
				"          \"ghost\": true," +
				"          \"icon\": \"edit\"," +
				"          \"visible\": false" +
				"        }," +
				"        {" +
				"          \"uititle\": \"打印\"," +
				"          \"uitype\": \"EJCPrintButton\"," +
				"          \"nid\": \"nid_1589191215172_130\"," +
				"          \"uikey\": \"printBtn\"," +
				"          \"ghost\": true," +
				"          \"type\": \"primary\"," +
				"          \"enableOrg\": true," +
				"          \"title\": \"打印\"," +
				"          \"billName\": \""+pageName+"\"," +
				"          \"billType\": \""+pageCode+"\"" +
				"        }," +
//				"        {" +
//				"          \"uititle\": \"审批相关\"," +
//				"          \"uitype\": \"BpmApproveWidget\"," +
//				"          \"nid\": \"nid_1589438757381_119\"," +
//				"          \"uikey\": \"bpmApprove\"," +
//				"          \"ghost\": true," +
//				"          \"enableUser\": true," +
//				"          \"enableOrg\": true," +
//				"          \"type\": \"primary\"," +
//				"          \"visible\": false," +
//				"          \"billName\": \""+pageName+"\"," +
//				"          \"billTypeId\": \""+pageCode+"\"," +
//				"          \"billId\": \""+pageCode+"\"" +
//				"        }," +
				"        {" +
				"          \"uititle\": \"附件管理\"," +
				"          \"uitype\": \"AttachMgrWidget\"," +
				"          \"nid\": \"nid_1589427237973_8243\"," +
				"          \"uikey\": \"attachMgr\"," +
				"          \"align\": \"right\"," +
				"          \"btnType\": \"primary\"," +
				"          \"btnGhost\": true," +
				"          \"fileLengthVisible\": true," +
				"          \"multiple\": true," +
				"          \"sourceType\": \"attachMgr\"," +
				"          \"billTypeId\": \""+pageCode+"\"," +
				"          \"billTypeName\": \""+pageName+"\"," +
				"          \"billType\": \""+pageCode+"\"" +
				"        }," +
				"        {" +
				"          \"uititle\": \"提交\"," +
				"          \"uitype\": \"BpmSubmitButton\"," +
				"          \"nid\": \"nid_1590498792684_313\"," +
				"          \"uikey\": \"bpmSubmitBtn\"," +
				"          \"enableUser\": true," +
				"          \"type\": \"primary\"," +
				"          \"ghost\": true," +
				"          \"orgField\": \"orgId\"," +
				"          \"visible\": false," +
				"          \"billName\": \""+pageName+"\"," +
				"          \"billRefId\": \""+pageCode+"\"," +
				"          \"billTypeId\": \""+pageCode+"\"" +
				"        }," +
				"        {" +
				"          \"uititle\": \"删除\"," +
				"          \"uitype\": \"EJCButton\"," +
				"          \"nid\": \"nid_1591188372391_153\"," +
				"          \"children\": \"删除\"," +
				"          \"uikey\": \"removeBtn\"," +
				"          \"type\": \"error\"," +
				"          \"icon\": \"delete\"," +
				"          \"ghost\": true," +
				"          \"visible\": false" +
				"        }," +
				"        {" +
				"          \"uititle\": \"撤回\"," +
				"          \"uitype\": \"EJCButton\"," +
				"          \"nid\": \"nid_1590543100452_478\"," +
				"          \"children\": \"撤回\"," +
				"          \"uikey\": \"callBackBtn\"," +
				"          \"type\": \"primary\"," +
				"          \"ghost\": true," +
				"          \"icon\": \"export\"," +
				"          \"visible\": false" +
				"        }," +
				"        {" +
				"          \"uititle\": \"返回列表\"," +
				"          \"uitype\": \"EJCButton\"," +
				"          \"nid\": \"nid_1589954748539_292\"," +
				"          \"children\": \"返回列表\"," +
				"          \"uikey\": \"goBackBtn\"," +
				"          \"type\": \"primary\"," +
				"          \"ghost\": true," +
				"          \"icon\": \"cross\"," +
				"          \"visible\": false" +
				"        }" +
				"      ]" +
				"    }," +
				"    {" +
				"      \"uititle\": \"基本信息\"," +
				"      \"uitype\": \"EJCPanel\"," +
				"      \"nid\": \"nid_1589427083751_4941\"," +
				"      \"uikey\": \"K"+System.currentTimeMillis()+"\"," +
				"      \"title\": \"基本信息\"," +
				"      \"expandText\": \"收起\"," +
				"      \"collapseText\": \"展开\"," +
				"      \"children\": [" +
				"        {" +
				"          \"uititle\": \"表单-基本信息\"," +
				"          \"uitype\": \"FormWidget\"," +
				"          \"nid\": \"nid_1589427140470_6356\"," +
				"          \"colnumber\": 3," +
				"          \"children\": []," +
				"          \"uikey\": \"baseForm\"," +
				"          \"labelCol\": {" +
				"            \"span\": 6" +
				"          }," +
				"          \"wrapperCol\": {" +
				"            \"span\": 14" +
				"          }," +
				"          \"dataprops\": {}" +
				"        }" +
				"       ]" +
				"      }" +
				"     ]" +
				"  }"+
				" ]," +
				"  \"nid\": \"nid_1589191084200_106\"," +
				"  \"dataprops\": {}," +
				"  \"themeClassName\": \"EJC\"" +
				"}";
		return data;
	}

	@Override
	public List<CustomAppVO> queryUserCustomAppList(String roleIds,String searchText) {
		List<CustomAppVO> customAppVos = customAppMapper.queryUserCustomAppList(roleIds, InvocationInfoProxy.getTenantid(),searchText);
		return customAppVos;
	}

	@Override
	public List<CustomAppVO> queryAllNoAuthCustomApps(String searchText) {
		List<CustomAppVO> customAppVos = customAppMapper.queryAllNoAuthCustomApps(InvocationInfoProxy.getTenantid(),searchText);
		return customAppVos;
	}

	@Override
	@Transactional
	public void deleteApp(List<CustomAppVO> vos) {
		if(ListUtil.isNotEmpty(vos)){
			this.removeByIds(vos.stream().map(CustomAppVO::getId).collect(Collectors.toList()),true);
			vos.forEach(vo->customTableService.clearCustomTable(vo.getId()));
		}
	}

}
