package com.ejianc.foundation.cust.bean;

import java.util.List;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

@TableName("ejc_cfs_custform_busitable")
public class BusinessTableEntity extends BaseEntity {

	private static final long serialVersionUID = 7133169161264968850L;

	@TableField(value = "unique_key")
	private String uniqueKey;

	@TableField(value = "name")
	private String name;

	@TableField(value = "comment")
	private String comment;

	@TableField(value = "group_id")
	private Long groupId;

	@TableField(value = "group_name")
	private String groupName;

	@TableField(exist = false)
	private List<BusinessColumnEntity> columns;

	@TableField(exist = false)
	private boolean createdTable;

	public String getUniqueKey() {
		return uniqueKey;
	}

	public void setUniqueKey(String uniqueKey) {
		this.uniqueKey = uniqueKey;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public Long getGroupId() {
		return groupId;
	}

	public void setGroupId(Long groupId) {
		this.groupId = groupId;
	}

	public String getGroupName() {
		return groupName;
	}

	public void setGroupName(String groupName) {
		this.groupName = groupName;
	}

	/**
	 * <pre>
	 * 直接调用父类
	 * 本来这个类是没啥用的，但是json解析时，它获取不了泛型C，所以我在这里告诉泛型的具体实现
	 * </pre>
	 */
	public void setColumns(List<BusinessColumnEntity> columns) {
		this.columns = columns;
	}

	/**
	 * <pre>
	 * 直接调用父类
	 * 本来这个类是没啥用的，但是json解析时，它获取不了泛型C，所以我在这里告诉泛型的具体实现
	 * </pre>
	 */
	public List<BusinessColumnEntity> getColumns() {
		return columns;
	}

	public boolean isCreatedTable() {
		return createdTable;
	}

	public void setCreatedTable(boolean createdTable) {
		this.createdTable = createdTable;
	}
	
	public BusinessColumnEntity getColumnByKey(String key) {
		for (BusinessColumnEntity column : this.columns) {
			if (key.equals(column.getUniqueKey())) {
				return column;
			}
		}
		return null;
	}

	public BusinessColumnEntity getColumn(String columnName) {
		BusinessColumnEntity columnEntity = null;
		if (columns != null && columns.size() > 0) {
			for (BusinessColumnEntity column : columns) {
				if (column.getName().equals(column)) {
					columnEntity = column;
					break;
				}
			}
		}
		return columnEntity;
	}

}
