package com.ejianc.foundation.cust.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cust.bean.BusinessColumnEntity;
import com.ejianc.foundation.cust.bean.BusinessObjectEntity;
import com.ejianc.foundation.cust.bean.BusinessTableEntity;
import com.ejianc.foundation.cust.bean.BusinessTableRel;
import com.ejianc.foundation.cust.constant.BusColumnCtrlType;
import com.ejianc.foundation.cust.mapper.BusinessObjectMapper;
import com.ejianc.foundation.cust.service.IBusinessObjectService;
import com.ejianc.foundation.cust.service.IBusinessTableService;
import com.ejianc.foundation.cust.util.BusTableRelType;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import cn.hutool.core.collection.CollectionUtil;

@Service
public class BusinessObjectServiceImpl extends BaseServiceImpl<BusinessObjectMapper, BusinessObjectEntity> implements IBusinessObjectService {
	
	@Autowired
	private BusinessObjectMapper businessObjectMapper;
	
	private IBusinessTableService businessTableService;

	@Override
	public BusinessObjectEntity getFilledByKey(String key) {
		QueryWrapper<BusinessObjectEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("uniqueKey", key);
		BusinessObjectEntity businessObject = businessObjectMapper.selectOne(queryWrapper);
		fill(businessObject);
		return businessObject;
	}

	/**
	 * <pre>
	 * 填充businessObject的数据
	 * 将其rel中的table数据都设置进去
	 * table中的ctrl也被填充好
	 * </pre>
	 * 
	 * @param businessObject
	 * @param loadPermission
	 *            是否加载权限
	 */
	private void fill(BusinessObjectEntity businessObject) {
		if (businessObject == null) {
			return;
		}

		for (BusinessTableRel rel : businessObject.getRelation().list()) {
			rel.setTable(businessTableService.getFilledByKey(rel.getTableKey()));
			rel.setBusObj(businessObject);
		}

		handleSetParentRel(businessObject.getRelation());
	}
	
	private void handleSetParentRel(BusinessTableRel rel) {
		for (BusinessTableRel r : rel.getChildren()) {
			r.setParent(rel);
			handleSetParentRel(r);// 递归子节点
		}
	}
	
	@Override
	public void saveBusinessObject(BusinessObjectEntity businessObject) {
		if(businessObject.getId() != null && businessObject.getId() > 0) {
			BusinessObjectEntity uniqueBean = businessObjectMapper.selectById(businessObject.getId());
			uniqueBean.setName(businessObject.getName());
			uniqueBean.setDescription(businessObject.getDescription());
			uniqueBean.setRelationJson(businessObject.getRelationJson());
			uniqueBean.setGroupId(businessObject.getGroupId());
			uniqueBean.setGroupName(businessObject.getGroupName());
			uniqueBean.setPersistenceType(businessObject.getPersistenceType());
			uniqueBean.setPerTypeConfig(businessObject.getPerTypeConfig());
			uniqueBean.setOverallArrangement(businessObject.getOverallArrangement());
			businessObjectMapper.updateById(uniqueBean);
		}else{
			businessObjectMapper.insert(businessObject);
		}
	}

	@Override
	public void updateOverallArrangementByCode(String boCode, String overallArrangement) {
		JSONObject json = JSON.parseObject(overallArrangement);
		if(json.getJSONArray("groupList").isEmpty()) {
			overallArrangement = null;
		}
		businessObjectMapper.updateOverallArrangementByCode(boCode, overallArrangement);
	}

	@Override
	public String getOverallArrangementByCode(String boCode) {
		return businessObjectMapper.getOverallArrangementByCode(boCode);
	}

	@Override
	public List<JSONObject> boTreeData(String boKey) {
		QueryWrapper<BusinessObjectEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("uniqueKey", boKey);
		BusinessObjectEntity businessObject = businessObjectMapper.selectOne(queryWrapper);
		BusinessTableRel busTableRel = businessObject.getRelation();
		List<JSONObject> list = new ArrayList<>();
		hanldeBusTableRel(busTableRel, 0l, list);

		if (CollectionUtil.isNotEmpty(list)) {
			list.get(0).put("alias", boKey);
		}
		return list;
	}
	
	/**
	 * <pre>
	 * 递归构建boTree
	 * </pre>
	 * 
	 * @param busTableRel
	 * @param parentId
	 * @param list
	 */
	private void hanldeBusTableRel(BusinessTableRel busTableRel, Long parentId, List<JSONObject> list) {
		BusinessTableEntity businessTable = businessTableService.getFilledByKey(busTableRel.getTableKey());
		JSONObject root = new JSONObject();
		root.put("id", businessTable.getId());
		root.put("key", businessTable.getUniqueKey());
		root.put("name",businessTable.getComment()+ "(" + BusTableRelType.getByKey(busTableRel.getType()).getDesc()+ "#" + businessTable.getName() + ")");
		root.put("comment",businessTable.getComment());
		root.put("parentId", parentId);
		root.put("nodeType", "table");// 节点类型-表
		root.put("relationType", busTableRel.getType());
		list.add(root);

		for (BusinessColumnEntity businessColumn : businessTable.getColumns()) {
			JSONObject columnJson = new JSONObject();
			columnJson.put("id", businessColumn.getId());
			columnJson.put("key", businessColumn.getUniqueKey());
			columnJson.put("name", businessColumn.getComment());
			columnJson.put("tableKey", businessTable.getUniqueKey());
			columnJson.put("parentId", businessTable.getId());
			
			if (1 == businessColumn.getPrimary() || businessColumn.getCtrl() == null
					||BusColumnCtrlType.HIDDEN.getKey().equals(businessColumn.getCtrl().getType()) ) {
				columnJson.put("isHidden", true);
			}

			columnJson.put("nodeType", "column");// 节点类型-字段
			list.add(columnJson);
		}
		for (BusinessTableRel rel : busTableRel.getChildren()) {
			hanldeBusTableRel(rel, businessTable.getId(), list);
		}
	}
}
