/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomDataEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomDataService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.foundation.cfs.util.ParsePageMetaUtils;
import com.ejianc.foundation.cfs.vo.ColumnVO;
import com.ejianc.foundation.cfs.vo.PageData;
import com.ejianc.foundation.front.api.IFrontApi;
import com.ejianc.foundation.front.vo.IdeModuleVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/no_auth/api/customtable/"})
public class CustomTableIntoMongoApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SESSION_PREFIX = "ICOP_SESSION_USER:";
    private static final Gson gson = new Gson();
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private ICustomAppService customAppService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICustomTableService customTableService;
    @Autowired
    private ICustomColumnService customColumnService;
    @Autowired
    private ICustomDataService iCustomDataService;
    @Autowired
    private IFrontApi iFrontApi;

    @PostMapping(value={"parse"})
    public CommonResponse<String> parse(@RequestBody PageData pageData) throws IOException {
        this.logger.info(pageData.toString());
        String sid = SESSION_PREFIX + pageData.getUserId();
        String userContextStr = this.sessionManager.getSessionCacheAttribute(sid, pageData.getToken());
        if (StringUtils.isBlank((CharSequence)userContextStr)) {
            return CommonResponse.error((String)"\u7528\u6237\u4e0a\u4e0b\u6587\u4e3a\u7a7a\uff0c\u8bf7\u5148\u767b\u5f55\uff01");
        }
        UserContext userContext = (UserContext)gson.fromJson(userContextStr, UserContext.class);
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(pageData.getAppCode());
        if (app != null) {
            if ("1".equals(app.getPublishState())) {
                return CommonResponse.error((String)"\u8be5\u5e94\u7528\u5df2\u53d1\u5e03\uff0c\u4e0d\u80fd\u8fdb\u884c\u8bbe\u8ba1\uff01");
            }
            JSONObject mobileList = this.getInitMobilePage(app, false);
            JSONObject mobileCard = this.getInitMobilePage(app, true);
            JSONArray cardCenter = this.getCardCenter(mobileCard);
            this.logger.info("cardCenter==null?" + (cardCenter == null) + cardCenter);
            ArrayList<JSONObject> mainCols = new ArrayList<JSONObject>();
            mobileList.put("mainCols", mainCols);
            mobileCard.put("mainCols", mainCols);
            HashMap subCols = new HashMap();
            mobileCard.put("subCols", subCols);
            Map<String, List<JSONObject>> pageMetaMap = ParsePageMetaUtils.parse(pageData.getPageMeta());
            List<JSONObject> formWidgetList = pageMetaMap.get("FormWidget");
            List<JSONObject> editTableWidgetList = pageMetaMap.get("EditTableWidget");
            Long mainFormId = IdWorker.getId();
            this.customTableService.clearCustomTable(app.getId());
            if (ListUtil.isNotEmpty(formWidgetList)) {
                CustomTableEntity mainTable = new CustomTableEntity();
                String mainTableName = "formWidget_" + pageData.getAppCode();
                mainTableName = mainTableName.toLowerCase();
                mainTable.setId(mainFormId);
                mainTable.setAppId(app.getId());
                mainTable.setUiKey("mainUiKey");
                mainTable.setTableName(mainTableName);
                mainTable.setTenantId(userContext.getTenantid());
                mainTable.setCreateUserCode(userContext.getUserCode());
                mainTable.setCreateTime(new Date());
                this.customTableService.saveOrUpdate((Object)mainTable);
                List<CustomColumnEntity> entities = this.getPublicCustomColumnEntity(mainFormId, 1);
                entities.forEach(col -> {
                    this.customColumnService.save(col);
                    JSONObject jsonObjectCol = new JSONObject();
                    jsonObjectCol.put("colType", (Object)col.getType());
                    jsonObjectCol.put("property", (Object)col.getProperty());
                    jsonObjectCol.put("val", (Object)col.getVal());
                    jsonObjectCol.put("columnName", (Object)col.getColumnName());
                    mainCols.add(jsonObjectCol);
                });
                for (int i = 0; i < formWidgetList.size(); ++i) {
                    JSONObject form = formWidgetList.get(i);
                    JSONObject ejcPart = this.getInitItem(form.getString("uititle"), "EJCPartNew");
                    ejcPart.put("uititle", (Object)form.getString("uititle"));
                    ejcPart.put("uikey", (Object)("EJCPart" + (i + 1)));
                    ejcPart.put("leftType", (Object)"1");
                    ejcPart.put("backgroundColor", (Object)"#F5F5F5");
                    ejcPart.put("color", (Object)"#999999");
                    ejcPart.put("visible", (Object)"true");
                    cardCenter.add((Object)ejcPart);
                    JSONObject mForm = this.getInitItem(form.getString("uititle"), "EJCFormDev");
                    mForm.put("uikey", (Object)("EJCFormDev" + (i + 1)));
                    mForm.put("dataType", (Object)"object");
                    mForm.put("visible", (Object)true);
                    ejcPart.getJSONArray("children").add((Object)mForm);
                    JSONArray mFormChildren = mForm.getJSONArray("children");
                    JSONArray mainChildren = form.getJSONArray("children");
                    if (mainChildren == null) continue;
                    for (int m = 0; m < mainChildren.size(); ++m) {
                        String uitype;
                        JSONObject mainField = mainChildren.getJSONObject(m);
                        CustomColumnEntity mainCol = new CustomColumnEntity();
                        mainCol.setId(IdWorker.getId());
                        mainCol.setCustomTableId(mainFormId);
                        mainCol.setColumnName(mainField.getString("uititle"));
                        mainCol.setProperty(mainField.getString("uikey"));
                        switch (uitype = mainField.getString("uisubtype")) {
                            case "date": {
                                mainCol.setType("date");
                                mainCol.setVal(mainField.toJSONString());
                                JSONObject date = this.getDate(mainField);
                                mFormChildren.add((Object)date);
                                break;
                            }
                            case "time": {
                                mainCol.setType("date");
                                break;
                            }
                            case "number": {
                                mainCol.setType("number");
                                mainCol.setVal(mainField.toJSONString());
                                JSONObject number = this.getNumber(mainField);
                                mFormChildren.add((Object)number);
                                break;
                            }
                            case "inputrefer": {
                                mainCol.setType("refer");
                                mainCol.setVal(mainField.toJSONString());
                                JSONObject refer = this.getRefer(mainField);
                                mFormChildren.add((Object)refer);
                                break;
                            }
                            case "enumselect": {
                                mainCol.setType("refer");
                                mainCol.setVal(mainField.toJSONString());
                                JSONObject enumselect = this.getEnumselect(mainField);
                                mFormChildren.add((Object)enumselect);
                                break;
                            }
                            case "switch": {
                                mainCol.setType("integer");
                                String name = "";
                                JSONObject mItemY = this.getInitItem("\u662f", "EJCPickerItem");
                                mItemY.put("value", (Object)1);
                                JSONObject mItemN = this.getInitItem("\u5426", "EJCPickerItem");
                                mItemN.put("uikey", (Object)"EJCPickerItem2");
                                mItemN.put("value", (Object)0);
                                if (StringUtils.isNotEmpty((CharSequence)mainField.getString("checkedChildren"))) {
                                    name = name + mainField.getString("checkedChildren") + ",";
                                    mItemY.put("uititle", (Object)mainField.getString("checkedChildren"));
                                } else {
                                    name = name + "\u662f,";
                                }
                                if (StringUtils.isNotEmpty((CharSequence)mainField.getString("unCheckedChildren"))) {
                                    name = name + mainField.getString("unCheckedChildren");
                                    mItemN.put("uititle", (Object)mainField.getString("unCheckedChildren"));
                                } else {
                                    name = name + "\u5426";
                                }
                                mainCol.setVal(name);
                                JSONObject switchSelect = this.getSwitchSelect(mainField, mItemY, mItemN);
                                mFormChildren.add((Object)switchSelect);
                                break;
                            }
                            case "currency": {
                                mainCol.setType("bigdecimal");
                                mainCol.setVal(mainField.toJSONString());
                                JSONObject currency = this.getCurrency(mainField);
                                mFormChildren.add((Object)currency);
                                break;
                            }
                            case "select": {
                                mainCol.setType("select");
                                mainCol.setVal(mainField.toJSONString());
                                JSONObject select = this.getSelect(mainField);
                                mFormChildren.add((Object)select);
                                break;
                            }
                            case "refAutoGrid": {
                                mainCol.setType("refer");
                                mainCol.setVal(mainField.getString("refinfokey"));
                                break;
                            }
                            case "input": {
                                mainCol.setType("string");
                                JSONObject input = this.getInput(mainField);
                                mFormChildren.add((Object)input);
                                break;
                            }
                            case "inputmap": 
                            case "textarea": {
                                mainCol.setType("string");
                                JSONObject textarea = this.getTextarea(mainField);
                                mFormChildren.add((Object)textarea);
                                break;
                            }
                            case "imageupload": {
                                mainCol.setType("string");
                                mainCol.setVal("image");
                                JSONObject imageupload = this.getImageupload(mainField, app);
                                mFormChildren.add((Object)imageupload);
                                break;
                            }
                            default: {
                                mainCol.setType("string");
                            }
                        }
                        if (mainField.get((Object)"unique") != null) {
                            mainCol.setUniqued(mainField.getBoolean("unique"));
                        }
                        mainCol.setSequence(m + 1);
                        this.customColumnService.save((Object)mainCol);
                        JSONObject jsonObjectCol = new JSONObject();
                        jsonObjectCol.put("colType", (Object)mainCol.getType());
                        jsonObjectCol.put("property", (Object)mainCol.getProperty());
                        jsonObjectCol.put("val", (Object)mainCol.getVal());
                        jsonObjectCol.put("columnName", (Object)mainCol.getColumnName());
                        mainCols.add(jsonObjectCol);
                    }
                }
            }
            if (ListUtil.isNotEmpty(editTableWidgetList)) {
                for (int i = 0; i < editTableWidgetList.size(); ++i) {
                    JSONObject editTableWidget = editTableWidgetList.get(i);
                    String childUiKey = editTableWidget.getString("uikey");
                    JSONObject mSubTable = this.getInitItem(editTableWidget.getString("uititle"), "EJCCFSSubTable");
                    mSubTable.put("uikey", (Object)childUiKey);
                    mSubTable.put("showIndex", (Object)false);
                    cardCenter.add((Object)mSubTable);
                    JSONArray tbChildren = mSubTable.getJSONArray("children");
                    Long childPkId = IdWorker.getId();
                    String subTableName = "editTableWidget_" + pageData.getAppCode() + "_" + childUiKey;
                    subTableName = subTableName.toLowerCase();
                    CustomTableEntity subTable = new CustomTableEntity();
                    subTable.setId(childPkId);
                    subTable.setParentId(mainFormId);
                    subTable.setAppId(app.getId());
                    subTable.setUiKey(childUiKey);
                    subTable.setTableName(subTableName);
                    subTable.setTenantId(userContext.getTenantid());
                    subTable.setCreateUserCode(userContext.getUserCode());
                    subTable.setCreateTime(new Date());
                    this.customTableService.saveOrUpdate((Object)subTable);
                    JSONArray childrenArray = editTableWidgetList.get(i).getJSONArray("children");
                    List<CustomColumnEntity> entities = this.getPublicCustomColumnEntity(childPkId, 0);
                    entities.forEach(col -> this.customColumnService.save(col));
                    if (childrenArray == null) continue;
                    for (int m = 0; m < childrenArray.size(); ++m) {
                        JSONObject childField = childrenArray.getJSONObject(m);
                        JSONObject showCol = this.getInitItem(childField.getString("uititle"), "EJCListTableShowCol");
                        showCol.put("showType", (Object)"both");
                        showCol.put("lineType", (Object)"left");
                        showCol.put("width", (Object)"2");
                        showCol.put("editable", (Object)"true");
                        showCol.put("clickable", (Object)"true");
                        showCol.put("visible", (Object)"true");
                        showCol.put("uikey", (Object)childField.getString("uikey"));
                        showCol.put("key", (Object)childField.getString("uikey"));
                        CustomColumnEntity subCol = new CustomColumnEntity();
                        subCol.setId(IdWorker.getId());
                        subCol.setCustomTableId(childPkId);
                        subCol.setColumnName(childField.getString("uititle"));
                        subCol.setProperty(childField.getString("uikey"));
                        subCol.setSequence(m);
                        String uitype = childField.getString("uisubtype");
                        showCol.put("required", (Object)childField.getString("required"));
                        showCol.put("defaultValueType", (Object)childField.getString("defaultValueType"));
                        switch (uitype) {
                            case "date": {
                                subCol.setType("date");
                                showCol.put("dataType", (Object)uitype);
                                break;
                            }
                            case "number": {
                                subCol.setType("number");
                                showCol.put("dataType", (Object)"num");
                                break;
                            }
                            case "inputrefer": {
                                subCol.setType("refer");
                                subCol.setVal(childField.getString("refinfokey"));
                                showCol.put("dataType", (Object)"refer");
                                showCol.put("referCode", (Object)childField.getString("refinfokey"));
                                showCol.put("required", (Object)childField.getString("required"));
                                showCol.put("referName", (Object)childField.getString("refinfokey"));
                                break;
                            }
                            case "enumselect": {
                                subCol.setType("enumselect");
                                subCol.setVal(childField.getString("refinfokey"));
                                showCol.put("dataType", (Object)"enumselect");
                                JSONObject source = new JSONObject();
                                source.put("code", (Object)childField.getString("code"));
                                showCol.put("source", (Object)source);
                                showCol.put("field", (Object)childField.getString("uikey"));
                                showCol.put("refName", (Object)childField.getString("refName"));
                                showCol.put("refId", (Object)childField.getString("refId"));
                                showCol.put("valueType", (Object)childField.getString("valueType"));
                                showCol.put("valueKey", (Object)childField.getString("valueKey"));
                                showCol.put("visible", (Object)true);
                                break;
                            }
                            case "switch": {
                                showCol.put("showType", (Object)"hide");
                                subCol.setType("integer");
                                String name = "";
                                name = StringUtils.isNotEmpty((CharSequence)childField.getString("checkedChildren")) ? name + childField.getString("checkedChildren") + "," : name + "\u662f,";
                                name = StringUtils.isNotEmpty((CharSequence)childField.getString("unCheckedChildren")) ? name + childField.getString("unCheckedChildren") : name + "\u5426";
                                subCol.setVal(name);
                                showCol.put("dataType", (Object)uitype);
                                showCol.put("checkedChildren", (Object)childField.getString("checkedChildren"));
                                showCol.put("unCheckedChildren", (Object)childField.getString("unCheckedChildren"));
                                break;
                            }
                            case "currency": {
                                subCol.setType("bigdecimal");
                                showCol.put("dataType", (Object)"money");
                                break;
                            }
                            case "select": {
                                subCol.setType("select");
                                showCol.put("dataType", (Object)uitype);
                                showCol.put("type", (Object)"1");
                                showCol.put("field", (Object)childField.getString("uikey"));
                                if (childField.getJSONArray("children") != null) {
                                    JSONArray selectChildren = new JSONArray();
                                    for (Object o : childField.getJSONArray("children")) {
                                        JSONObject object = (JSONObject)o;
                                        JSONObject child = new JSONObject();
                                        child.put("uitype", (Object)"EJCPickerItem");
                                        child.put("uikey", (Object)object.getString("uikey"));
                                        child.put("uititle", (Object)object.getString("text"));
                                        child.put("value", (Object)object.getString("value"));
                                        child.put("key", (Object)object.getString("uikey"));
                                        child.put("nid", (Object)object.getString("nid"));
                                        selectChildren.add((Object)child);
                                    }
                                    showCol.put("children", (Object)selectChildren);
                                }
                                showCol.put("defaultValue", (Object)childField.getJSONObject("defaultValue"));
                                break;
                            }
                            case "textarea": {
                                subCol.setType("textarea");
                                showCol.put("dataType", (Object)uitype);
                                break;
                            }
                            case "attachupload": {
                                subCol.setType("attachupload");
                                showCol.put("showType", (Object)"hide");
                                showCol.put("dataType", (Object)uitype);
                                showCol.put("sourceType", (Object)childField.getString("sourceType"));
                                showCol.put("billType", (Object)childField.getString("billType"));
                                break;
                            }
                            default: {
                                subCol.setType("string");
                                showCol.put("dataType", (Object)"string");
                            }
                        }
                        subCol.setVal(childField.toJSONString());
                        this.customColumnService.save((Object)subCol);
                        tbChildren.add((Object)showCol);
                    }
                }
            }
            JSONObject attachMgr = this.getAttachMgr(app);
            cardCenter.add((Object)attachMgr);
            this.saveMobilePage(app, false, mobileList);
            this.saveMobilePage(app, true, mobileCard);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        return CommonResponse.error((String)"\u5e94\u7528\u7f16\u7801\u67e5\u8be2\u5931\u8d25\u3002");
    }

    private JSONObject getAttachMgr(CustomAppEntity app) {
        JSONObject attachMgr = this.getInitItem("\u9644\u4ef6\u7ba1\u7406", "EJCAttachFilePick");
        attachMgr.put("uikey", (Object)"attachMgr");
        attachMgr.put("sourceType", (Object)"attachMgr");
        attachMgr.put("partName", (Object)"\u9644\u4ef6\u7ba1\u7406");
        JSONObject billType = new JSONObject();
        billType.put("id", (Object)app.getId());
        billType.put("billCode", (Object)app.getAppCode());
        billType.put("billName", (Object)app.getAppName());
        billType.put("metadataName", (Object)app.getAppName());
        attachMgr.put("billType", (Object)billType);
        JSONObject source = new JSONObject();
        source.put("id", (Object)app.getId());
        source.put("code", (Object)app.getAppCode());
        source.put("name", (Object)app.getAppName());
        source.put("sourceType", (Object)"attachMgr");
        source.put("billType", (Object)app.getAppCode());
        attachMgr.put("source", (Object)source);
        return attachMgr;
    }

    private JSONObject getDate(JSONObject mainField) {
        JSONObject date = this.getInitItem(mainField.getString("uititle"), "EJCDatePicker");
        date.put("uikey", (Object)mainField.getString("uikey"));
        date.put("field", (Object)mainField.getString("uikey"));
        date.put("label", (Object)mainField.getString("uititle"));
        date.put("mode", (Object)"date");
        date.put("required", (Object)(mainField.getBoolean("required") != null && mainField.getBoolean("required") != false ? 1 : 0));
        date.put("disabled", (Object)(mainField.getBoolean("disabled") != null && mainField.getBoolean("disabled") == false ? 1 : 0));
        date.put("extra", (Object)("\u8bf7\u9009\u62e9" + mainField.getString("uititle")));
        date.put("format", (Object)mainField.getString("format"));
        date.put("defaultValueType", (Object)mainField.getString("defaultValueType"));
        date.put("arrow", (Object)"horizontal");
        return date;
    }

    private JSONObject getNumber(JSONObject mainField) {
        JSONObject number = this.getInitItem(mainField.getString("uititle"), "EJCInput");
        number.put("uikey", (Object)mainField.getString("uikey"));
        number.put("field", (Object)mainField.getString("uikey"));
        number.put("type", (Object)"number");
        number.put("placeholder", (Object)("\u8bf7\u8f93\u5165" + mainField.getString("uititle")));
        number.put("labelNumber", (Object)7);
        number.put("decimal", (Object)2);
        number.put("comma", (Object)true);
        number.put("required", (Object)(mainField.getBoolean("required") != null && mainField.getBoolean("required") != false ? 1 : 0));
        number.put("editable", (Object)(mainField.getBoolean("disabled") == null || mainField.getBoolean("disabled") == false ? 1 : 0));
        number.put("clear", (Object)true);
        number.put("visible", (Object)true);
        return number;
    }

    private JSONObject getRefer(JSONObject mainField) {
        JSONObject refer = this.getInitItem(mainField.getString("uititle"), "EJCRefer");
        refer.put("uikey", (Object)mainField.getString("uikey"));
        refer.put("referName", (Object)mainField.getString("uikey"));
        refer.put("treeDisplayField", (Object)"name");
        refer.put("showField", (Object)"name");
        refer.put("id", (Object)"id");
        JSONObject referCode = new JSONObject();
        referCode.put("refCode", (Object)mainField.getString("refinfokey"));
        referCode.put("code", (Object)mainField.getString("refinfokey"));
        referCode.put("name", (Object)mainField.getString("refName"));
        referCode.put("id", (Object)mainField.getString("refId"));
        refer.put("referCode", (Object)referCode);
        refer.put("labelNumber", (Object)7);
        refer.put("required", (Object)(mainField.getBoolean("required") != null && mainField.getBoolean("required") != false ? 1 : 0));
        refer.put("disabled", (Object)(mainField.getBoolean("disabled") != null && mainField.getBoolean("disabled") == false ? 1 : 0));
        refer.put("visible", (Object)true);
        refer.put("defaultValueType", (Object)mainField.getString("defaultValueType"));
        return refer;
    }

    private JSONObject getEnumselect(JSONObject mainField) {
        JSONObject enumselect = this.getInitItem(mainField.getString("uititle"), "EJCPicker");
        enumselect.put("uikey", (Object)mainField.getString("uikey"));
        enumselect.put("field", (Object)mainField.getString("uikey"));
        enumselect.put("label", (Object)mainField.getString("uititle"));
        enumselect.put("extra", (Object)("\u8bf7\u9009\u62e9" + mainField.getString("uititle")));
        enumselect.put("okText", (Object)"\u786e\u5b9a");
        enumselect.put("dismissText", (Object)"\u53d6\u6d88");
        enumselect.put("cols", (Object)1);
        enumselect.put("type", (Object)"2");
        enumselect.put("subType", (Object)"enumselect");
        enumselect.put("defDocType", (Object)"2");
        enumselect.put("arrow", (Object)"horizontal");
        enumselect.put("required", (Object)(mainField.getBoolean("required") != null && mainField.getBoolean("required") != false ? 1 : 0));
        enumselect.put("disabled", (Object)(mainField.getBoolean("disabled") != null && mainField.getBoolean("disabled") == false ? 1 : 0));
        enumselect.put("visible", (Object)true);
        JSONObject defDocCode = new JSONObject();
        defDocCode.put("id", (Object)mainField.getString("refId"));
        defDocCode.put("code", (Object)mainField.getString("code"));
        defDocCode.put("name", (Object)mainField.getString("refName"));
        enumselect.put("defDocCode", (Object)defDocCode);
        enumselect.put("source", (Object)defDocCode);
        return enumselect;
    }

    private JSONObject getSwitchSelect(JSONObject mainField, JSONObject mItemY, JSONObject mItemN) {
        JSONObject switchSelect = this.getInitItem(mainField.getString("uititle"), "EJCPicker");
        switchSelect.put("uikey", (Object)mainField.getString("uikey"));
        switchSelect.put("field", (Object)mainField.getString("uikey"));
        switchSelect.put("label", (Object)mainField.getString("uititle"));
        switchSelect.put("extra", (Object)("\u8bf7\u9009\u62e9" + mainField.getString("uititle")));
        switchSelect.put("okText", (Object)"\u786e\u5b9a");
        switchSelect.put("dismissText", (Object)"\u53d6\u6d88");
        switchSelect.put("cols", (Object)1);
        switchSelect.put("type", (Object)"1");
        switchSelect.put("subType", (Object)"switch");
        switchSelect.put("defDocType", (Object)"2");
        switchSelect.put("arrow", (Object)"horizontal");
        switchSelect.put("required", (Object)(mainField.getBoolean("required") != null && mainField.getBoolean("required") != false ? 1 : 0));
        switchSelect.put("disabled", (Object)(mainField.getBoolean("disabled") != null && mainField.getBoolean("disabled") == false ? 1 : 0));
        switchSelect.put("visible", (Object)true);
        JSONArray switchSelectChildren = new JSONArray();
        switchSelectChildren.add((Object)mItemY);
        switchSelectChildren.add((Object)mItemN);
        switchSelect.put("children", (Object)switchSelectChildren);
        return switchSelect;
    }

    private JSONObject getCurrency(JSONObject mainField) {
        JSONObject currency = this.getInitItem(mainField.getString("uititle"), "EJCInput");
        currency.put("uikey", (Object)mainField.getString("uikey"));
        currency.put("field", (Object)mainField.getString("uikey"));
        currency.put("type", (Object)"money");
        currency.put("placeholder", (Object)("\u8bf7\u8f93\u5165" + mainField.getString("uititle")));
        currency.put("labelNumber", (Object)7);
        currency.put("decimal", (Object)mainField.getInteger("decimal"));
        currency.put("required", (Object)(mainField.getBoolean("required") != null && mainField.getBoolean("required") != false ? 1 : 0));
        currency.put("comma", (Object)(mainField.getBoolean("commaVisible") == null || mainField.getBoolean("commaVisible") != false ? 1 : 0));
        currency.put("editable", (Object)(mainField.getBoolean("disabled") == null || mainField.getBoolean("disabled") == false ? 1 : 0));
        currency.put("clear", (Object)true);
        currency.put("visible", (Object)true);
        return currency;
    }

    private JSONObject getSelect(JSONObject mainField) {
        JSONObject select = this.getInitItem(mainField.getString("uititle"), "EJCPicker");
        select.put("uikey", (Object)mainField.getString("uikey"));
        select.put("field", (Object)mainField.getString("uikey"));
        select.put("label", (Object)mainField.getString("uititle"));
        select.put("extra", (Object)("\u8bf7\u9009\u62e9" + mainField.getString("uititle")));
        select.put("okText", (Object)"\u786e\u5b9a");
        select.put("dismissText", (Object)"\u53d6\u6d88");
        select.put("cols", (Object)1);
        select.put("type", (Object)"1");
        select.put("subType", (Object)"select");
        select.put("defDocType", (Object)"2");
        select.put("arrow", (Object)"horizontal");
        select.put("required", (Object)(mainField.getBoolean("required") != null && mainField.getBoolean("required") != false ? 1 : 0));
        select.put("disabled", (Object)(mainField.getBoolean("disabled") != null && mainField.getBoolean("disabled") == false ? 1 : 0));
        select.put("visible", (Object)true);
        JSONArray selectChildren = new JSONArray();
        JSONArray pcSelectChildren = mainField.getJSONArray("children");
        if (pcSelectChildren != null && pcSelectChildren.size() > 0) {
            for (int j = 0; j < pcSelectChildren.size(); ++j) {
                JSONObject pcItem = pcSelectChildren.getJSONObject(j);
                JSONObject mItem = this.getInitItem(pcItem.getString("uititle"), "EJCPickerItem");
                mItem.put("uikey", (Object)pcItem.getString("value"));
                mItem.put("value", (Object)pcItem.getString("value"));
                selectChildren.add((Object)mItem);
            }
        }
        select.put("children", (Object)selectChildren);
        select.put("defaultValue", (Object)mainField.getJSONObject("defaultValue"));
        return select;
    }

    private JSONObject getInput(JSONObject mainField) {
        JSONObject input = this.getInitItem(mainField.getString("uititle"), "EJCInput");
        input.put("uikey", (Object)mainField.getString("uikey"));
        input.put("field", (Object)mainField.getString("uikey"));
        input.put("type", (Object)"text");
        input.put("placeholder", (Object)("\u8bf7\u8f93\u5165" + mainField.getString("uititle")));
        input.put("labelNumber", (Object)7);
        input.put("decimal", (Object)2);
        input.put("comma", (Object)true);
        input.put("required", (Object)(mainField.getBoolean("required") != null && mainField.getBoolean("required") != false ? 1 : 0));
        input.put("editable", (Object)(mainField.getBoolean("disabled") == null || mainField.getBoolean("disabled") == false ? 1 : 0));
        input.put("clear", (Object)true);
        input.put("visible", (Object)true);
        input.put("defaultValueType", (Object)mainField.getString("defaultValueType"));
        return input;
    }

    private JSONObject getTextarea(JSONObject mainField) {
        JSONObject textarea = this.getInitItem(mainField.getString("uititle"), "EJCTextareaItem");
        textarea.put("uikey", (Object)mainField.getString("uikey"));
        textarea.put("field", (Object)mainField.getString("uikey"));
        textarea.put("label", (Object)mainField.getString("uititle"));
        textarea.put("direction", (Object)"inside");
        textarea.put("rows", (Object)5);
        textarea.put("count", (Object)200);
        textarea.put("placeholder", (Object)("\u8bf7\u8f93\u5165" + mainField.getString("uititle")));
        textarea.put("labelNumber", (Object)7);
        textarea.put("required", (Object)(mainField.getBoolean("required") != null && mainField.getBoolean("required") != false ? 1 : 0));
        textarea.put("disabled", (Object)(mainField.getBoolean("disabled") != null && mainField.getBoolean("disabled") != false ? 1 : 0));
        textarea.put("clear", (Object)true);
        textarea.put("visible", (Object)true);
        return textarea;
    }

    private JSONObject getImageupload(JSONObject mainField, CustomAppEntity app) {
        JSONObject imageupload = this.getInitItem(mainField.getString("uititle"), "EJCImagePicker");
        imageupload.put("uikey", (Object)mainField.getString("uikey"));
        imageupload.put("sourceType", (Object)mainField.getString("uikey"));
        imageupload.put("label", (Object)mainField.getString("uititle"));
        imageupload.put("maxSize", (Object)mainField.getInteger("maxCount"));
        imageupload.put("required", (Object)(mainField.getBoolean("required") != null && mainField.getBoolean("required") != false ? 1 : 0));
        imageupload.put("disabled", (Object)(mainField.getBoolean("disabled") != null && mainField.getBoolean("disabled") != false ? 1 : 0));
        imageupload.put("clear", (Object)true);
        imageupload.put("visible", (Object)true);
        JSONObject billType = new JSONObject();
        billType.put("id", (Object)app.getId());
        billType.put("code", (Object)app.getAppCode());
        billType.put("name", (Object)app.getAppName());
        imageupload.put("billType", (Object)billType);
        JSONObject source = new JSONObject();
        source.put("id", (Object)app.getId());
        source.put("code", (Object)app.getAppCode());
        source.put("name", (Object)app.getAppName());
        source.put("sourceType", (Object)mainField.getString("uikey"));
        source.put("billType", (Object)app.getAppCode());
        imageupload.put("source", (Object)source);
        return imageupload;
    }

    private JSONArray getCardCenter(JSONObject card) {
        JSONArray cardCenter = card.getJSONArray("children").getJSONObject(0).getJSONArray("children").getJSONObject(1).getJSONArray("children");
        return cardCenter;
    }

    private JSONObject getInitMobilePage(CustomAppEntity app, boolean card) {
        JSONObject page = new JSONObject();
        page.put("uikey", (Object)(app.getAppCode() + "list"));
        page.put("uititle", (Object)app.getAppName());
        page.put("uitype", (Object)"EJCPage");
        page.put("cfsAppInfo", (Object)app);
        page.put("nid", (Object)("nid_" + IdWorker.getId()));
        JSONArray pageChildren = new JSONArray();
        if (card) {
            page.put("uikey", (Object)(app.getAppCode() + "card"));
            page.put("uititle", (Object)(app.getAppName() + "\u8be6\u60c5"));
            page.put("children", (Object)pageChildren);
            JSONObject layout = this.getInitItem("\u4e0a\u4e2d\u4e0b\u5e03\u5c40", "EJCLayout");
            pageChildren.add((Object)layout);
            JSONArray layoutChildren = layout.getJSONArray("children");
            JSONObject head = this.getInitItem("\u5934\u90e8", "EJCLayoutPanel");
            head.put("visible", (Object)false);
            head.put("position", (Object)"top");
            head.put("height", (Object)"0px");
            JSONObject center = this.getInitItem("\u4e2d\u90e8", "EJCLayoutPanel");
            center.put("uikey", (Object)"EJCLayoutPanel2");
            center.put("position", (Object)"center");
            center.put("visible", (Object)true);
            center.put("height", (Object)"calc(100% - 45px)");
            JSONObject bottom = this.getInitItem("\u5e95\u90e8", "EJCLayoutPanel");
            bottom.put("uikey", (Object)"EJCLayoutPanel3");
            bottom.put("position", (Object)"bottom");
            bottom.put("visible", (Object)true);
            bottom.put("height", (Object)"45px");
            layoutChildren.add((Object)head);
            layoutChildren.add((Object)center);
            layoutChildren.add((Object)bottom);
            JSONArray bottomChildren = bottom.getJSONArray("children");
            JSONObject bottomBar = this.getInitItem("\u5e95\u90e8\u6309\u94ae\u7ec4", "EJCButtonBar");
            bottomChildren.add((Object)bottomBar);
            JSONArray bottomBarChildren = bottomBar.getJSONArray("children");
            JSONObject del = this.getInitItem("\u5220\u9664", "EJCButton");
            del.put("uikey", (Object)"removeBtn");
            del.put("size", (Object)"large");
            del.put("radius", (Object)false);
            del.put("visible", (Object)false);
            del.put("type", (Object)"warning");
            JSONObject saveBtn = this.getInitItem("\u4fdd\u5b58", "EJCButton");
            saveBtn.put("uikey", (Object)"saveBtn");
            saveBtn.put("size", (Object)"large");
            saveBtn.put("radius", (Object)false);
            saveBtn.put("visible", (Object)false);
            saveBtn.put("type", (Object)"ghost");
            JSONObject callBackBtn = this.getInitItem("\u6536\u56de", "EJCButton");
            callBackBtn.put("uikey", (Object)"callBackBtn");
            callBackBtn.put("size", (Object)"large");
            callBackBtn.put("radius", (Object)false);
            callBackBtn.put("visible", (Object)false);
            JSONObject EJCApproveSubmitBtn = this.getInitItem("\u63d0\u4ea4", "EJCApproveSubmitBtn");
            EJCApproveSubmitBtn.put("uikey", (Object)"EJCApproveSubmitBtn");
            EJCApproveSubmitBtn.put("size", (Object)"large");
            EJCApproveSubmitBtn.put("radius", (Object)false);
            EJCApproveSubmitBtn.put("visible", (Object)false);
            EJCApproveSubmitBtn.put("orgField", (Object)"orgId");
            EJCApproveSubmitBtn.put("type", (Object)"primary");
            JSONObject billTypeId = new JSONObject();
            billTypeId.put("billCode", (Object)app.getAppCode());
            billTypeId.put("billName", (Object)app.getAppName());
            billTypeId.put("metadataName", (Object)app.getAppName());
            billTypeId.put("code", (Object)app.getAppCode());
            billTypeId.put("name", (Object)app.getAppName());
            EJCApproveSubmitBtn.put("billTypeId", (Object)billTypeId);
            JSONObject EJCApproveRejectBtn = this.getInitItem("\u9a73\u56de", "EJCApproveRejectBtn");
            EJCApproveRejectBtn.put("uikey", (Object)"EJCApproveRejectBtn");
            EJCApproveRejectBtn.put("size", (Object)"large");
            EJCApproveRejectBtn.put("radius", (Object)false);
            EJCApproveRejectBtn.put("visible", (Object)false);
            EJCApproveRejectBtn.put("type", (Object)"warning");
            EJCApproveSubmitBtn.put("billTypeId", (Object)billTypeId);
            JSONObject EJCApproveAgreeBtn = this.getInitItem("\u540c\u610f", "EJCApproveAgreeBtn");
            EJCApproveAgreeBtn.put("uikey", (Object)"EJCApproveAgreeBtn");
            EJCApproveAgreeBtn.put("size", (Object)"large");
            EJCApproveAgreeBtn.put("radius", (Object)false);
            EJCApproveAgreeBtn.put("visible", (Object)false);
            EJCApproveAgreeBtn.put("type", (Object)"primary");
            JSONObject EJCApproveHistoryBtn = this.getInitItem("\u5ba1\u6279\u5386\u53f2", "EJCApproveHistoryBtn");
            EJCApproveHistoryBtn.put("uikey", (Object)"EJCApproveHistoryBtn");
            EJCApproveHistoryBtn.put("size", (Object)"large");
            EJCApproveHistoryBtn.put("radius", (Object)false);
            EJCApproveHistoryBtn.put("visible", (Object)false);
            EJCApproveHistoryBtn.put("type", (Object)"primary");
            JSONObject saveApproveEditBtn = this.getInitItem("\u786e\u8ba4\u4fee\u6539", "EJCButton");
            saveApproveEditBtn.put("uikey", (Object)"saveApproveEditBtn");
            saveApproveEditBtn.put("size", (Object)"large");
            saveApproveEditBtn.put("radius", (Object)false);
            saveApproveEditBtn.put("visible", (Object)false);
            saveApproveEditBtn.put("type", (Object)"primary");
            bottomBarChildren.add((Object)del);
            bottomBarChildren.add((Object)saveBtn);
            bottomBarChildren.add((Object)callBackBtn);
            bottomBarChildren.add((Object)EJCApproveSubmitBtn);
            bottomBarChildren.add((Object)EJCApproveRejectBtn);
            bottomBarChildren.add((Object)EJCApproveAgreeBtn);
            bottomBarChildren.add((Object)EJCApproveHistoryBtn);
            bottomBarChildren.add((Object)saveApproveEditBtn);
        } else {
            page.put("children", (Object)pageChildren);
            JSONObject layout = this.getInitItem("\u4e0a\u4e2d\u4e0b\u5e03\u5c40", "EJCLayout");
            JSONArray layoutChildren = layout.getJSONArray("children");
            JSONObject head = this.getInitItem("\u5934\u90e8", "EJCLayoutPanel");
            head.put("position", (Object)"top");
            head.put("visible", (Object)true);
            head.put("height", (Object)"45px");
            JSONArray headChildren = head.getJSONArray("children");
            JSONObject searchBar = this.getInitItem("\u641c\u7d22\u680f", "EJCCFSSearchBar");
            searchBar.put("placeholder", (Object)"\u8bf7\u8f93\u5165\u5173\u952e\u5b57\u641c\u7d22");
            headChildren.add((Object)searchBar);
            JSONObject center = this.getInitItem("\u4e2d\u90e8", "EJCLayoutPanel");
            center.put("uikey", (Object)"EJCLayoutPanel2");
            center.put("position", (Object)"center");
            center.put("visible", (Object)true);
            center.put("height", (Object)"calc(100% - 45px)");
            JSONArray centerChildren = center.getJSONArray("children");
            JSONObject cardList = this.getInitItem("\u5361\u7247\u5217\u8868", "EJCCardList");
            centerChildren.add((Object)cardList);
            cardList.put("titleName", (Object)"title");
            cardList.put("thumbName", (Object)"thumb");
            cardList.put("IconSize", (Object)"md");
            cardList.put("firstButtonText", (Object)"\u53d6\u6d88");
            cardList.put("secondButtonText", (Object)"\u5220\u9664");
            cardList.put("header", (Object)"\u5217\u8868\u5934\u90e8");
            cardList.put("footerBefore", (Object)"\u6b63\u5728\u52a0\u8f7d");
            cardList.put("footerAfter", (Object)"\u52a0\u8f7d\u5b8c\u6210");
            cardList.put("cutheight", (Object)"0px");
            cardList.put("initialListSize", (Object)100);
            cardList.put("onEndReachedThreshold", (Object)100);
            cardList.put("pageSize", (Object)30);
            cardList.put("showBottom", (Object)true);
            cardList.put("showFooter", (Object)true);
            cardList.put("disabledFirst", (Object)true);
            cardList.put("disabledSecond", (Object)true);
            JSONArray cardListChildren = cardList.getJSONArray("children");
            JSONObject cardListHead = this.getInitItem("\u5934\u90e8", "EJCCardListTitle");
            JSONObject cardListCenter = this.getInitItem("\u4e2d\u90e8", "EJCCardListContent");
            cardListCenter.put("lineNumber", (Object)2);
            JSONObject cardListBottom = this.getInitItem("\u5e95\u90e8", "EJCCardListBottom");
            cardListBottom.put("approveBtn", (Object)true);
            JSONObject createTime = this.getInitItem("\u521b\u5efa\u65f6\u95f4", "EJCCardListItem");
            createTime.put("uikey", (Object)"createTime");
            createTime.put("itemkey", (Object)"createTime");
            createTime.put("itemType", (Object)"date");
            createTime.put("location", (Object)"left");
            createTime.put("fontSize", (Object)"12px");
            createTime.put("dateType", (Object)"ymdhms");
            cardListBottom.getJSONArray("children").add((Object)createTime);
            cardListChildren.add((Object)cardListHead);
            cardListChildren.add((Object)cardListCenter);
            cardListChildren.add((Object)cardListBottom);
            JSONObject bottom = this.getInitItem("\u5e95\u90e8", "EJCLayoutPanel");
            bottom.put("uikey", (Object)"EJCLayoutPanel3");
            bottom.put("position", (Object)"bottom");
            bottom.put("visible", (Object)false);
            bottom.put("height", (Object)"0");
            layoutChildren.add((Object)head);
            layoutChildren.add((Object)center);
            layoutChildren.add((Object)bottom);
            JSONObject addBtn = this.getInitItem("\u65b0\u589e\u6309\u94ae", "EJCAddButton");
            addBtn.put("type", (Object)"1");
            addBtn.put("leaderPage", (Object)"0");
            pageChildren.add((Object)layout);
            pageChildren.add((Object)addBtn);
        }
        return page;
    }

    private JSONObject getInitItem(String title, String uitype) {
        JSONObject item = new JSONObject();
        item.put("uititle", (Object)title);
        item.put("uitype", (Object)uitype);
        item.put("uikey", (Object)(uitype + "1"));
        item.put("children", (Object)new JSONArray());
        item.put("nid", (Object)("nid_" + IdWorker.getId()));
        return item;
    }

    private void saveMobilePage(CustomAppEntity entity, boolean card, JSONObject data) {
        IdeModuleVO moduleVO = new IdeModuleVO();
        moduleVO.setId(Long.valueOf(IdWorker.getId()));
        if (card) {
            moduleVO.setCode(entity.getAppCode() + "card");
            this.logger.info("\u5373\u5c06\u751f\u6210\u79fb\u52a8\u7aef\u5361\u7247\u6570\u636e\u3002\u3002\u3002\u3002");
        } else {
            this.logger.info("\u5373\u5c06\u751f\u6210\u79fb\u52a8\u7aef\u5217\u8868\u6570\u636e\u3002\u3002\u3002\u3002");
            moduleVO.setCode(entity.getAppCode() + "list");
        }
        moduleVO.setAppId(entity.getId());
        moduleVO.setAppCode(entity.getAppCode());
        moduleVO.setCreateDate(new Date());
        moduleVO.setName(entity.getAppName());
        moduleVO.setClientType("mobile");
        moduleVO.setCreateId(InvocationInfoProxy.getUserid());
        moduleVO.setData(data.toJSONString());
        CommonResponse response = this.iFrontApi.insertNewCfsPage(moduleVO);
        if (card) {
            this.logger.info("\u751f\u6210\u79fb\u52a8\u7aef\u5361\u7247\u6570\u636e" + JSONObject.toJSONString((Object)moduleVO) + "  \u7ed3\u679c\uff1a" + response.isSuccess());
        } else {
            this.logger.info("\u751f\u6210\u79fb\u52a8\u7aef\u5217\u8868\u6570\u636e" + JSONObject.toJSONString((Object)moduleVO) + "  \u7ed3\u679c\uff1a" + response.isSuccess());
        }
        if (!response.isSuccess()) {
            this.iFrontApi.insertNewCfsPage(moduleVO);
        }
    }

    private List<CustomColumnEntity> getPublicCustomColumnEntity(Long mainFormId, int type) {
        ArrayList<CustomColumnEntity> list = new ArrayList<CustomColumnEntity>();
        CustomColumnEntity col = new CustomColumnEntity();
        col.setId(IdWorker.getId());
        col.setCustomTableId(mainFormId);
        col.setColumnName("id");
        col.setProperty("id");
        col.setType("string");
        col.setSequence(-1);
        list.add(col);
        col = new CustomColumnEntity();
        col.setId(IdWorker.getId());
        col.setCustomTableId(mainFormId);
        col.setType("date");
        col.setColumnName("\u521b\u5efa\u65f6\u95f4");
        col.setProperty("createTime");
        col.setSequence(0);
        list.add(col);
        col = new CustomColumnEntity();
        col.setId(IdWorker.getId());
        col.setCustomTableId(mainFormId);
        col.setType("string");
        col.setColumnName("\u521b\u5efa\u4ebaid");
        col.setProperty("createUser");
        col.setSequence(0);
        list.add(col);
        col = new CustomColumnEntity();
        col.setId(IdWorker.getId());
        col.setCustomTableId(mainFormId);
        col.setType("string");
        col.setColumnName("\u521b\u5efa\u4eba\u540d\u79f0");
        col.setProperty("creatorName");
        col.setSequence(0);
        list.add(col);
        if (type == 1) {
            col = new CustomColumnEntity();
            col.setId(IdWorker.getId());
            col.setCustomTableId(mainFormId);
            col.setType("integer");
            col.setColumnName("\u5355\u636e\u72b6\u6001");
            col.setProperty("billState");
            col.setSequence(0);
            list.add(col);
            col = new CustomColumnEntity();
            col.setId(IdWorker.getId());
            col.setCustomTableId(mainFormId);
            col.setType("string");
            col.setColumnName("\u7ec4\u7ec7id");
            col.setProperty("orgId");
            col.setSequence(0);
            list.add(col);
            col = new CustomColumnEntity();
            col.setId(IdWorker.getId());
            col.setCustomTableId(mainFormId);
            col.setType("string");
            col.setColumnName("\u7ec4\u7ec7\u540d\u79f0");
            col.setProperty("orgName");
            col.setSequence(0);
            list.add(col);
        } else {
            col = new CustomColumnEntity();
            col.setId(IdWorker.getId());
            col.setCustomTableId(mainFormId);
            col.setType("string");
            col.setColumnName("\u4e3b\u8868id");
            col.setProperty("pid");
            col.setSequence(0);
            list.add(col);
            col = new CustomColumnEntity();
            col.setId(IdWorker.getId());
            col.setCustomTableId(mainFormId);
            col.setType("integer");
            col.setColumnName("rowIndex");
            col.setProperty("rowIndex");
            col.setSequence(0);
            list.add(col);
        }
        return list;
    }

    @RequestMapping(value={"queryColumnList"}, method={RequestMethod.GET})
    public CommonResponse<List<ColumnVO>> queryColumnList(@RequestParam(value="appCode", required=true) String appCode, @RequestParam(value="range", required=true) String range) {
        ArrayList<ColumnVO> resultList = new ArrayList<ColumnVO>();
        CustomAppEntity app = this.customAppService.queryCustomAppByCode(appCode);
        if (app != null) {
            QueryWrapper childWrapper = new QueryWrapper();
            childWrapper.eq((Object)"app_id", (Object)app.getId());
            childWrapper.eq((Object)"dr", (Object)0);
            List childCustomTableEntities = this.customTableService.list((Wrapper)childWrapper);
            Long mainId = null;
            ArrayList<CustomTableEntity> childrenCustomTables = new ArrayList<CustomTableEntity>();
            if (childCustomTableEntities != null && childCustomTableEntities.size() > 0) {
                for (CustomTableEntity entity : childCustomTableEntities) {
                    if (entity.getParentId() != null) {
                        childrenCustomTables.add(entity);
                        continue;
                    }
                    mainId = entity.getId();
                }
                if (mainId != null) {
                    QueryWrapper mainWrapper = new QueryWrapper();
                    mainWrapper.eq((Object)"custom_table_id", (Object)mainId);
                    mainWrapper.eq((Object)"dr", (Object)0);
                    List mainColumnList = this.customColumnService.list((Wrapper)mainWrapper);
                    for (CustomColumnEntity customColumnEntity : mainColumnList) {
                        ColumnVO vo = new ColumnVO();
                        vo.setId(customColumnEntity.getId());
                        vo.setName(customColumnEntity.getColumnName() + "(" + customColumnEntity.getProperty() + ")");
                        vo.setCode(customColumnEntity.getProperty());
                        vo.setDataType(customColumnEntity.getType());
                        vo.setDisplayName(customColumnEntity.getColumnName());
                        resultList.add(vo);
                    }
                    if ("children".equals(range) && childrenCustomTables != null && childrenCustomTables.size() > 0) {
                        for (CustomTableEntity customTableEntity : childrenCustomTables) {
                            QueryWrapper childrenWrapper = new QueryWrapper();
                            childrenWrapper.eq((Object)"custom_table_id", (Object)customTableEntity.getId());
                            childrenWrapper.eq((Object)"dr", (Object)0);
                            ColumnVO cvo = new ColumnVO();
                            cvo.setId(customTableEntity.getId());
                            cvo.setName(customTableEntity.getTableName());
                            cvo.setCode(customTableEntity.getUiKey());
                            cvo.setMainAttributeField(customTableEntity.getUiKey());
                            cvo.setDisplayName(customTableEntity.getTableName());
                            resultList.add(cvo);
                            List childrenColumnList = this.customColumnService.list((Wrapper)childrenWrapper);
                            if (childrenColumnList == null || childrenColumnList.size() <= 0) continue;
                            for (CustomColumnEntity columnentity : childrenColumnList) {
                                ColumnVO vo = new ColumnVO();
                                vo.setId(columnentity.getId());
                                vo.setName(columnentity.getColumnName() + "(" + columnentity.getProperty() + ")");
                                vo.setCode(columnentity.getProperty());
                                vo.setDisplayName(columnentity.getColumnName());
                                vo.setDataType(columnentity.getType());
                                vo.setParentId(customTableEntity.getId());
                                vo.setMainAttributeField(customTableEntity.getUiKey());
                                resultList.add(vo);
                            }
                        }
                    }
                }
            }
        }
        return CommonResponse.success(resultList);
    }

    @RequestMapping(value={"updateBillState"}, method={RequestMethod.GET})
    public CommonResponse<Boolean> updateBillState(@RequestParam(value="appCode", required=true) String appCode, @RequestParam(value="id", required=true) Long id, @RequestParam(value="billState", required=true) Integer billState) throws IOException {
        CommonResponse<JSONObject> response = this.customTableService.queryDetail(appCode, id);
        if (response.isSuccess()) {
            CustomAppEntity app = this.customAppService.queryCustomAppByCode(appCode);
            CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
            JSONObject entity = (JSONObject)response.getData();
            entity.put("billState", (Object)billState);
            UpdateRequest updateRequest = new UpdateRequest(mainTableEntity.getTableName(), id.toString());
            updateRequest.doc((Map)entity, XContentType.JSON);
            UpdateResponse update = this.client.update(updateRequest, RequestOptions.DEFAULT);
            if (update.status().getStatus() != RestStatus.OK.getStatus()) {
                this.logger.error(response.toString());
                return CommonResponse.error((String)"\u66f4\u65b0\u5931\u8d25");
            }
            QueryParam dataParam = new QueryParam();
            dataParam.getParams().put("mainId", new Parameter("eq", (Object)id));
            List dataEntityList = this.iCustomDataService.queryList(dataParam, false);
            if (ListUtil.isNotEmpty((List)dataEntityList)) {
                CustomDataEntity customDataEntity = (CustomDataEntity)((Object)dataEntityList.get(0));
                JSONObject saveData = JSONObject.parseObject((String)customDataEntity.getData());
                saveData.put("billState", (Object)billState);
                customDataEntity.setData(saveData.toJSONString());
                this.iCustomDataService.saveOrUpdate((Object)customDataEntity, false);
            }
            return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f\uff01", (Object)true);
        }
        return CommonResponse.error((String)"\u66f4\u65b0\u5931\u8d25");
    }

    @RequestMapping(value={"queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> queryDetail(@RequestParam(value="appCode", required=true) String appCode, @RequestParam(value="id", required=true) Long id) throws IOException {
        return this.customTableService.queryDetail(appCode, id);
    }

    @RequestMapping(value={"queryPrintDetail"}, method={RequestMethod.GET})
    public CommonResponse<JSONObject> queryPrintDetail(@RequestParam(value="appCode", required=true) String appCode, @RequestParam(value="id", required=true) Long id) throws IOException {
        return this.customTableService.queryPrintDetail(appCode, id);
    }
}

