/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cust.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.cust.bean.BusinessColumnEntity;
import com.ejianc.foundation.cust.bean.BusinessObjectEntity;
import com.ejianc.foundation.cust.bean.BusinessTableEntity;
import com.ejianc.foundation.cust.bean.BusinessTableRel;
import com.ejianc.foundation.cust.constant.BusColumnCtrlType;
import com.ejianc.foundation.cust.mapper.BusinessObjectMapper;
import com.ejianc.foundation.cust.service.IBusinessObjectService;
import com.ejianc.foundation.cust.service.IBusinessTableService;
import com.ejianc.foundation.cust.util.BusTableRelType;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessObjectServiceImpl
extends BaseServiceImpl<BusinessObjectMapper, BusinessObjectEntity>
implements IBusinessObjectService {
    @Autowired
    private BusinessObjectMapper businessObjectMapper;
    private IBusinessTableService businessTableService;

    @Override
    public BusinessObjectEntity getFilledByKey(String key) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uniqueKey", (Object)key);
        BusinessObjectEntity businessObject = (BusinessObjectEntity)((Object)this.businessObjectMapper.selectOne((Wrapper)queryWrapper));
        this.fill(businessObject);
        return businessObject;
    }

    private void fill(BusinessObjectEntity businessObject) {
        if (businessObject == null) {
            return;
        }
        for (BusinessTableRel rel : businessObject.getRelation().list()) {
            rel.setTable(this.businessTableService.getFilledByKey(rel.getTableKey()));
            rel.setBusObj(businessObject);
        }
        this.handleSetParentRel(businessObject.getRelation());
    }

    private void handleSetParentRel(BusinessTableRel rel) {
        for (BusinessTableRel r : rel.getChildren()) {
            r.setParent(rel);
            this.handleSetParentRel(r);
        }
    }

    @Override
    public void saveBusinessObject(BusinessObjectEntity businessObject) {
        if (businessObject.getId() != null && businessObject.getId() > 0L) {
            BusinessObjectEntity uniqueBean = (BusinessObjectEntity)((Object)this.businessObjectMapper.selectById(businessObject.getId()));
            uniqueBean.setName(businessObject.getName());
            uniqueBean.setDescription(businessObject.getDescription());
            uniqueBean.setRelationJson(businessObject.getRelationJson());
            uniqueBean.setGroupId(businessObject.getGroupId());
            uniqueBean.setGroupName(businessObject.getGroupName());
            uniqueBean.setPersistenceType(businessObject.getPersistenceType());
            uniqueBean.setPerTypeConfig(businessObject.getPerTypeConfig());
            uniqueBean.setOverallArrangement(businessObject.getOverallArrangement());
            this.businessObjectMapper.updateById((Object)uniqueBean);
        } else {
            this.businessObjectMapper.insert((Object)businessObject);
        }
    }

    @Override
    public void updateOverallArrangementByCode(String boCode, String overallArrangement) {
        JSONObject json = JSON.parseObject((String)overallArrangement);
        if (json.getJSONArray("groupList").isEmpty()) {
            overallArrangement = null;
        }
        this.businessObjectMapper.updateOverallArrangementByCode(boCode, overallArrangement);
    }

    @Override
    public String getOverallArrangementByCode(String boCode) {
        return this.businessObjectMapper.getOverallArrangementByCode(boCode);
    }

    @Override
    public List<JSONObject> boTreeData(String boKey) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uniqueKey", (Object)boKey);
        BusinessObjectEntity businessObject = (BusinessObjectEntity)((Object)this.businessObjectMapper.selectOne((Wrapper)queryWrapper));
        BusinessTableRel busTableRel = businessObject.getRelation();
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        this.hanldeBusTableRel(busTableRel, 0L, list);
        if (CollectionUtil.isNotEmpty(list)) {
            ((JSONObject)list.get(0)).put("alias", (Object)boKey);
        }
        return list;
    }

    private void hanldeBusTableRel(BusinessTableRel busTableRel, Long parentId, List<JSONObject> list) {
        BusinessTableEntity businessTable = this.businessTableService.getFilledByKey(busTableRel.getTableKey());
        JSONObject root = new JSONObject();
        root.put("id", (Object)businessTable.getId());
        root.put("key", (Object)businessTable.getUniqueKey());
        root.put("name", (Object)(businessTable.getComment() + "(" + BusTableRelType.getByKey(busTableRel.getType()).getDesc() + "#" + businessTable.getName() + ")"));
        root.put("comment", (Object)businessTable.getComment());
        root.put("parentId", (Object)parentId);
        root.put("nodeType", (Object)"table");
        root.put("relationType", (Object)busTableRel.getType());
        list.add(root);
        for (BusinessColumnEntity businessColumn : businessTable.getColumns()) {
            JSONObject columnJson = new JSONObject();
            columnJson.put("id", (Object)businessColumn.getId());
            columnJson.put("key", (Object)businessColumn.getUniqueKey());
            columnJson.put("name", (Object)businessColumn.getComment());
            columnJson.put("tableKey", (Object)businessTable.getUniqueKey());
            columnJson.put("parentId", (Object)businessTable.getId());
            if (1 == businessColumn.getPrimary() || businessColumn.getCtrl() == null || BusColumnCtrlType.HIDDEN.getKey().equals(businessColumn.getCtrl().getType())) {
                columnJson.put("isHidden", (Object)true);
            }
            columnJson.put("nodeType", (Object)"column");
            list.add(columnJson);
        }
        for (BusinessTableRel rel : busTableRel.getChildren()) {
            this.hanldeBusTableRel(rel, businessTable.getId(), list);
        }
    }
}

