/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cust.util;

import cn.hutool.core.collection.CollectionUtil;
import com.ejianc.foundation.cust.bean.BusinessColumnEntity;
import com.ejianc.foundation.cust.bean.BusinessTableEntity;
import com.ejianc.foundation.cust.mapper.BusinessTableMapper;
import com.ejianc.foundation.cust.util.ColumnType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableOperator {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected BusinessTableEntity table;
    private BusinessTableMapper businessTableMapper;

    public TableOperator(BusinessTableMapper businessTableMapper, BusinessTableEntity table) {
        this.businessTableMapper = businessTableMapper;
        this.table = table;
    }

    private String columnToSql(BusinessColumnEntity column) {
        StringBuilder sb = new StringBuilder();
        sb.append("" + column.getName() + "");
        if (ColumnType.CLOB.equalsWithKey(column.getType())) {
            sb.append(" text");
        } else if (ColumnType.DATE.equalsWithKey(column.getType())) {
            sb.append(" datetime");
        } else if (ColumnType.NUMBER.equalsWithKey(column.getType())) {
            sb.append(" decimal(" + column.getColLength() + "," + column.getColDecimal() + ")");
        } else if (ColumnType.VARCHAR.equalsWithKey(column.getType())) {
            sb.append(" varchar(" + column.getColLength() + ")");
        }
        if (1 == column.getRequired() || 1 == column.getPrimary()) {
            sb.append(" NOT NULL");
        } else {
            sb.append(" NULL");
        }
        sb.append(" COMMENT '" + column.getComment() + "'");
        return sb.toString();
    }

    public void createTable() {
        if (this.isTableCreated()) {
            this.logger.debug("\u8868[" + this.table.getName() + "(" + this.table.getComment() + ")]\u5df2\u5b58\u5728\u6570\u636e\u5e93\u4e2d\uff0c\u65e0\u9700\u518d\u6b21\u751f\u6210");
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE " + this.table.getName() + " (\n");
        for (BusinessColumnEntity column : this.table.getColumns()) {
            sql.append(this.columnToSql(column) + ",\n");
        }
        sql.append("PRIMARY KEY (id)\n)");
        sql.append(" ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE utf8_bin ");
        if (StringUtils.isNotBlank((String)this.table.getComment())) {
            sql.append(" COMMENT='" + this.table.getComment() + "'");
        }
        sql.append(";");
        this.businessTableMapper.createBusiTable(sql.toString());
    }

    public void dropTable() {
        if (!this.isTableCreated()) {
            return;
        }
        String sql = "drop table " + this.table.getName() + "";
        this.businessTableMapper.dropBusiTable(sql);
    }

    public boolean isTableCreated() {
        String sql = "select count(1) from information_schema.TABLES t where table_name = " + this.table.getName();
        List<String> resultList = this.businessTableMapper.queryTableExist(sql);
        return resultList != null && resultList.size() > 0;
    }

    public void addColumn(BusinessColumnEntity column) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE " + this.table.getName() + "");
        sql.append(" ADD COLUMN " + this.columnToSql(column) + ";");
        this.businessTableMapper.executeSql(sql.toString());
    }

    public void updateColumn(BusinessColumnEntity column) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE " + this.table.getName() + "");
        sql.append(" MODIFY COLUMN " + this.columnToSql(column) + ";");
        this.businessTableMapper.executeSql(sql.toString());
    }

    public void dropColumn(String columnName) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE " + this.table.getName() + "");
        sql.append(" DROP COLUMN " + columnName + ";");
        this.businessTableMapper.executeSql(sql.toString());
    }

    public BusinessTableEntity getDbTable(Long tableId) {
        return (BusinessTableEntity)((Object)this.businessTableMapper.selectById(tableId));
    }

    public void insertData(Map<String, Object> data) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO " + this.table.getName());
        StringBuilder columnNameSql = new StringBuilder();
        StringBuilder paramNameSql = new StringBuilder();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (columnNameSql.length() > 0) {
                columnNameSql.append(",");
                paramNameSql.append(",");
            }
            columnNameSql.append(entry.getKey());
            paramNameSql.append("'" + entry.getValue() + "'");
        }
        sql.append("(" + columnNameSql + ") VALUES(" + paramNameSql + ")");
        this.businessTableMapper.executeSql(sql.toString());
    }

    public void deleteData(Object id) {
        String sql = "DELETE FROM " + this.table.getName() + " where id = " + id;
        this.businessTableMapper.executeSql(sql);
    }

    public void deleteData(Map<String, Object> param) {
        if (param.isEmpty()) {
            throw new RuntimeException("\u64cd\u4f5c\u5220\u9664\u8868[" + this.table.getComment() + "(" + this.table.getName() + ")]\u65f6\uff0c\u6761\u4ef6\u53c2\u6570\u4e3a\u7a7a(\u4f1a\u5bfc\u81f4\u5168\u8868\u6570\u636e\u6e05\u7a7a)");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM " + this.table.getName() + " where ");
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            sql.append(entry.getKey() + " = '" + entry.getValue() + "' ");
        }
        this.businessTableMapper.executeSql(sql.toString());
    }

    public void updateData(Map<String, Object> data) {
        Object id = data.get("id");
        if (id == null) {
            throw new RuntimeException("\u64cd\u4f5c\u66f4\u65b0\u8868[" + this.table.getComment() + "(" + this.table.getName() + ")]\u65f6\uff0c\u53c2\u6570\u4e2d\u6709\u6ca1\u4e3b\u952e[(id)]");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE " + this.table.getName() + " SET ");
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (entry.getKey().equals("id")) continue;
            sql.append(entry.getKey() + " = '" + entry.getValue() + "'");
        }
        sql.append(" WHERE id = " + id);
        this.businessTableMapper.executeSql(sql.toString());
    }

    public Map<String, Object> selectData(List<String> columnName, Object id) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        List<Map<String, Object>> list = this.selectData(columnName, param);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Map<String, Object> selectData(Object id) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", id);
        List<Map<String, Object>> list = this.selectData(param);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public List<Map<String, Object>> selectData(Map<String, Object> param) {
        return this.selectData(null, param);
    }

    public List<Map<String, Object>> selectData(List<String> columnName, Map<String, Object> param) {
        StringBuilder sql = new StringBuilder();
        if (CollectionUtil.isEmpty(columnName)) {
            sql.append("SELECT * FROM " + this.table.getName());
        } else {
            sql.append("SELECT");
            for (String string : columnName) {
                if (!sql.toString().endsWith("SELECT")) {
                    sql.append(",");
                }
                sql.append(" " + string);
            }
            sql.append(" FROM " + this.table.getName());
        }
        sql.append(" WHERE ");
        for (Map.Entry entry : param.entrySet()) {
            sql.append((String)entry.getKey() + " = '" + entry.getValue() + "'");
        }
        return this.businessTableMapper.executeSelectSql(sql.toString());
    }

    public void syncColumn() {
        if (!this.isTableCreated()) {
            return;
        }
        HashSet<String> dbColumnNames = new HashSet<String>();
        BusinessTableEntity dbTable = this.getDbTable(this.table.getId());
        for (BusinessColumnEntity c : dbTable.getColumns()) {
            dbColumnNames.add(c.getName());
        }
        for (String columnName : dbColumnNames) {
            if (this.table.getColumn(columnName) != null) continue;
            this.dropColumn(columnName);
        }
        for (BusinessColumnEntity column : this.table.getColumns()) {
            boolean exits = false;
            for (String columnName : dbColumnNames) {
                if (!columnName.equalsIgnoreCase(column.getName())) continue;
                exits = true;
                break;
            }
            if (!exits) {
                this.addColumn(column);
                continue;
            }
            if (((Object)((Object)dbTable.getColumn(column.getName()))).equals((Object)column)) continue;
            this.updateColumn(column);
        }
    }
}

