/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.cfs.bean.CustomAppEntity;
import com.ejianc.foundation.cfs.bean.CustomAppGroupEntity;
import com.ejianc.foundation.cfs.bean.CustomColumnEntity;
import com.ejianc.foundation.cfs.bean.CustomListEntity;
import com.ejianc.foundation.cfs.bean.CustomTableEntity;
import com.ejianc.foundation.cfs.service.ICustomAppGroupService;
import com.ejianc.foundation.cfs.service.ICustomAppService;
import com.ejianc.foundation.cfs.service.ICustomColumnService;
import com.ejianc.foundation.cfs.service.ICustomListService;
import com.ejianc.foundation.cfs.service.ICustomTableService;
import com.ejianc.foundation.cfs.vo.CustomAppVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.ReferShowfieldVO;
import com.ejianc.foundation.support.vo.ReferVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.mongodb.template.MongodbCrudTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"refer"})
public class ReferCfsController {
    @Autowired
    private ICustomAppGroupService groupService;
    @Autowired
    private ICustomAppService appService;
    @Autowired
    private ICustomTableService customTableService;
    @Autowired
    private ICustomColumnService customColumnService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private MongodbCrudTemplate mongoTemplate;
    @Autowired
    private ICustomListService customListService;

    @RequestMapping(value={"/referGroupTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> referGroupTree() {
        ArrayList resultMapList = new ArrayList();
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List list = this.groupService.queryList(param, false);
        if (ListUtil.isEmpty((List)list)) {
            return null;
        }
        HashMap<String, Object> map = null;
        for (CustomAppGroupEntity entity : list) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("isLeaf", true);
            map.put("selectable", true);
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getCode());
            map.put("parentId", null);
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/referAppList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CustomAppVO>> referAppList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String relyCondition, String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        Map param = queryParam.getParams();
        if (StringUtils.isNotEmpty((CharSequence)relyCondition)) {
            param.put("appGroupId", new Parameter("eq", (Object)relyCondition.split("=")[1]));
        }
        param.put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.put("appState", new Parameter("eq", (Object)1));
        param.put("publishState", new Parameter("eq", (Object)1));
        queryParam.getFuzzyFields().add("appCode");
        queryParam.getFuzzyFields().add("appName");
        queryParam.setSearchText(searchText);
        queryParam.getOrderMap().put("sequence", "asc");
        IPage page = this.appService.queryPage(queryParam, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CustomAppVO.class));
        for (CustomAppVO record : pageData.getRecords()) {
            record.setChildren(null);
            record.setCode(record.getAppCode());
            record.setName(record.getAppName());
        }
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"/referCfsDataList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<JSONObject>> referCfsDataList(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, @RequestParam(required=false) String searchText) {
        CustomTableEntity mainTableEntity;
        List<CustomColumnEntity> mainCols;
        CommonResponse orgVoResponse;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        if (StringUtils.isEmpty((CharSequence)condition)) {
            return CommonResponse.error((String)"condition\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        JSONObject _con = JSONObject.parseObject((String)condition);
        String pageCode = _con.getString("pageCode");
        CustomAppEntity app = this.appService.queryCustomAppByCode(pageCode);
        Long orgId = InvocationInfoProxy.getOrgId();
        if ((app.getQueryRange() == 0 || app.getQueryRange() == 1 && queryParam.getParams().get("createUser") == null) && (orgVoResponse = this.orgApi.findChildrenByParentId(orgId)).isSuccess()) {
            List orgVos = (List)orgVoResponse.getData();
            StringBuffer orgIdBuffer = new StringBuffer();
            for (OrgVO orgVo : orgVos) {
                orgIdBuffer.append(orgVo.getId()).append(",");
            }
            queryParam.getParams().put("orgId", new Parameter("in", (Object)orgIdBuffer.substring(0, orgIdBuffer.length() - 1)));
        }
        if (ListUtil.isNotEmpty(mainCols = this.customColumnService.queryColumnsByTableId((mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId())).getId()))) {
            for (CustomColumnEntity col : mainCols) {
                if (!col.getType().equals("string") && !col.getType().equals("refer") && !col.getType().equals("select")) continue;
                queryParam.getFuzzyFields().add(col.getProperty());
            }
        }
        queryParam.getOrderMap().put("createTime", "desc");
        IPage page = this.mongoTemplate.queryPage(queryParam, mainTableEntity.getTableName());
        if (ListUtil.isEmpty((List)page.getRecords())) {
            return CommonResponse.success((Object)page);
        }
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("appId", new Parameter("eq", (Object)app.getId()));
        param.getOrderMap().put("sequence", "asc");
        List list = this.customListService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)list)) {
            CustomListEntity nameCol = list.stream().filter(e -> e.getNameCol() != null).filter(CustomListEntity::getNameCol).findFirst().orElse(null);
            CustomListEntity codeCol = list.stream().filter(e -> e.getCodeCol() != null).filter(CustomListEntity::getCodeCol).findFirst().orElse(null);
            for (JSONObject rowData : page.getRecords()) {
                if (nameCol != null) {
                    rowData.put("name", rowData.get((Object)nameCol.getColumnProperty()));
                } else {
                    rowData.put("name", rowData.get((Object)"id"));
                }
                if (codeCol != null) {
                    rowData.put("code", rowData.get((Object)codeCol.getColumnProperty()));
                } else {
                    rowData.put("code", rowData.get((Object)"id"));
                }
                if (!ListUtil.isNotEmpty(mainCols)) continue;
                for (CustomColumnEntity col : mainCols) {
                    if (col.getType().equals("refer") && rowData.getJSONObject(col.getProperty()) != null) {
                        rowData.put(col.getProperty(), (Object)rowData.getJSONObject(col.getProperty()).getString("name"));
                    }
                    if (!col.getType().equals("select") || rowData.getJSONObject(col.getProperty()) == null) continue;
                    String value = rowData.getJSONObject(col.getProperty()).getString("text");
                    if (StringUtils.isEmpty((CharSequence)value)) {
                        value = rowData.getJSONObject(col.getProperty()).getString("label");
                    }
                    rowData.put(col.getProperty(), (Object)value);
                }
            }
        }
        return CommonResponse.success((Object)page);
    }

    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReferVO> findByCode(@RequestParam String refCode) {
        ReferVO vo = new ReferVO();
        CustomAppEntity app = this.appService.queryCustomAppByCode(refCode);
        vo.setCode(app.getAppCode());
        vo.setRefCode(app.getAppCode());
        vo.setName(app.getAppName());
        vo.setRefName(app.getAppName());
        vo.setRefType("grid");
        vo.setEnableBaseUrl(true);
        vo.setQueryMethod("GET");
        vo.setIdField("id");
        vo.setNameField("id");
        vo.setCodeField("id");
        vo.setPageSize("10");
        vo.setDataurl("/ejc-cfs-web/refer/referCfsDataList");
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("appId", new Parameter("eq", (Object)app.getId()));
        param.getOrderMap().put("sequence", "asc");
        List list = this.customListService.queryList(param, false);
        if (ListUtil.isNotEmpty((List)list)) {
            CustomListEntity nameCol = list.stream().filter(e -> e.getNameCol() != null).filter(CustomListEntity::getNameCol).findFirst().orElse(null);
            CustomListEntity codeCol = list.stream().filter(e -> e.getCodeCol() != null).filter(CustomListEntity::getCodeCol).findFirst().orElse(null);
            if (codeCol != null) {
                vo.setCodeField(codeCol.getColumnProperty());
            }
            if (nameCol != null) {
                vo.setNameField(nameCol.getColumnProperty());
            }
            ArrayList<ReferShowfieldVO> vos = new ArrayList<ReferShowfieldVO>();
            for (CustomListEntity customList : list) {
                ReferShowfieldVO referShowfieldVO = new ReferShowfieldVO();
                referShowfieldVO.setId(customList.getId());
                referShowfieldVO.setName(customList.getColumnName());
                referShowfieldVO.setCode(customList.getColumnProperty());
                vos.add(referShowfieldVO);
            }
            vo.setGridheaders(vos);
        }
        return CommonResponse.success((Object)vo);
    }

    @RequestMapping(value={"/queryCfsReferData"}, method={RequestMethod.GET})
    public CommonResponse<JSONArray> queryCfsReferData(@RequestParam String pageCode, @RequestParam String id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", (Object)id));
        queryParam.setPageSize(-1);
        CustomAppEntity app = this.appService.queryCustomAppByCode(pageCode);
        CustomTableEntity mainTableEntity = this.customTableService.queryMainTableByAppId(app.getId());
        IPage page = this.mongoTemplate.queryPage(queryParam, mainTableEntity.getTableName());
        JSONArray result = new JSONArray();
        if (ListUtil.isNotEmpty((List)page.getRecords())) {
            for (JSONObject rowData : page.getRecords()) {
                result.add((Object)rowData);
            }
        }
        return CommonResponse.success((Object)result);
    }
}

