/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cfs.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParsePageMetaUtils {
    private static final Set<String> COMPONENT_TYPE = new HashSet<String>();

    public static Map<String, List<JSONObject>> parse(String pageMeta) {
        JSONArray childrenJson;
        HashMap<String, List<JSONObject>> resultMap = new HashMap<String, List<JSONObject>>();
        JSONObject pageMetaJson = JSON.parseObject((String)pageMeta);
        String uitype = pageMetaJson.getString("uitype");
        if (COMPONENT_TYPE.contains(uitype)) {
            if (resultMap.containsKey(uitype)) {
                ((List)resultMap.get(uitype)).add(pageMetaJson);
            } else {
                ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
                resultList.add(pageMetaJson);
                resultMap.put(uitype, resultList);
            }
        }
        if ((childrenJson = pageMetaJson.getJSONArray("children")) != null && !childrenJson.isEmpty()) {
            ParsePageMetaUtils.loopParse(childrenJson, resultMap);
        }
        return resultMap;
    }

    private static void loopParse(JSONArray children, Map<String, List<JSONObject>> resultMap) {
        for (int i = 0; i < children.size(); ++i) {
            JSONObject jsonObject = children.getJSONObject(i);
            String uitype = jsonObject.getString("uitype");
            if (COMPONENT_TYPE.contains(uitype)) {
                if (resultMap.containsKey(uitype)) {
                    resultMap.get(uitype).add(jsonObject);
                } else {
                    ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
                    resultList.add(jsonObject);
                    resultMap.put(uitype, resultList);
                }
            }
            JSONArray childrenJson = null;
            try {
                childrenJson = jsonObject.getJSONArray("children");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (childrenJson == null || childrenJson.isEmpty()) continue;
            ParsePageMetaUtils.loopParse(childrenJson, resultMap);
        }
    }

    public static void main(String[] args) {
        String text = "{\"uikey\":\"cardPage\",\"uititle\":\"\u6536\u6599\u5165\u5e93\u5361\u7247\",\"uitype\":\"EJCPage\",\"themeClassName\":\"GEJC\",\"dataprops\":{\"project\":{\"id\":\"322683907509321758\",\"displayName\":\"\u7269\u8d44\u7ba1\u7406\",\"projectName\":\"ejc-material-web\"},\"entity\":{\"id\":\"326041962640834592\",\"displayName\":\"\u6536\u6599\u5165\u5e93\",\"entityFullName\":\"com.ejianc.business.material.bean.InstoreEntity\"}},\"billName\":\"\u6536\u6599\u5165\u5e93\",\"billType\":\"BT200611000000015\",\"children\":[{\"uititle\":\"\u9762\u5305\u5c515\",\"uitype\":\"EJCBreadcrumb\",\"nid\":\"nid_1592217698094_4189\",\"children\":[{\"uitype\":\"EJCBreadcrumbItem\",\"uititle\":\"\u6536\u6599\u5165\u5e93\",\"key\":1592217702754,\"uikey\":\"1592217702754\",\"children\":\"\u6536\u6599\u5165\u5e93\",\"nid\":\"nid_1592217702755_4194\",\"href\":\"instore\"},{\"uitype\":\"EJCBreadcrumbItem\",\"uititle\":\"\u8be6\u60c5\",\"key\":1592217707722,\"uikey\":\"1592217707722\",\"children\":\"\u8be6\u60c5\",\"nid\":\"nid_1592217707722_4195\"}]},{\"uititle\":\"\u5de5\u5177\u680f1\",\"uitype\":\"EJCToolbar\",\"nid\":\"nid_1591868482300_6416\",\"children\":[{\"uititle\":\"\u4fdd\u5b58\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1589191191111_126\",\"children\":\"\u4fdd\u5b58\",\"uikey\":\"saveBtn\",\"type\":\"primary\",\"icon\":\"book\",\"ghost\":true}]},{\"uititle\":\"\u57fa\u672c\u4fe1\u606f\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1591868495757_6444\",\"children\":[{\"uititle\":\"\u8868\u53551\",\"uitype\":\"FormWidget\",\"nid\":\"nid_1591868498519_6447\",\"colnumber\":3,\"dataprops\":{\"system\":{\"id\":\"322683907509321758\",\"systemCnName\":\"\u7269\u8d44\u7ba1\u7406\",\"systemName\":\"ejc-material-web\"},\"entity\":{\"id\":\"326041962640834592\",\"entityCnName\":\"\u6536\u6599\u5165\u5e93\",\"entityFullName\":\"326041962640834592\"}},\"children\":[{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"inputrefer\",\"label\":\"\u4f9b\u5e94\u5546\",\"uititle\":\"\u4f9b\u5e94\u5546\",\"uikey\":\"supplierId\",\"nid\":\"nid_1591868579892_6520\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"refinfokey\":\"supplier_tree_grid\",\"refName\":\"\u4f9b\u65b9\",\"refId\":\"321290255763505209\",\"required\":true},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"inputrefer\",\"label\":\"\u5408\u540c\",\"uititle\":\"\u5408\u540c\",\"uikey\":\"contractId\",\"nid\":\"nid_1591868579892_6521\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"required\":true,\"refinfokey\":\"material_contract\",\"refName\":\"\u7269\u8d44\u5408\u540c\u5217\u8868\u53c2\u7167\",\"refId\":\"327395662865104986\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"select\",\"label\":\"\u662f\u5426\u5c5e\u4e8e\u9879\u76ee\",\"uititle\":\"\u662f\u5426\u5c5e\u4e8e\u9879\u76ee\",\"uikey\":\"projectFlag\",\"nid\":\"nid_1591869128536_8244\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"required\":true,\"children\":[{\"uitype\":\"EJCOption\",\"uititle\":\"\u662f\",\"children\":\"\u662f\",\"uikey\":\"1\",\"value\":\"1\",\"key\":\"1\",\"nid\":\"nid_1591964153569_11777\",\"text\":\"\u662f\"},{\"uitype\":\"EJCOption\",\"uititle\":\"\u5426\",\"children\":\"\u5426\",\"uikey\":\"0\",\"value\":\"0\",\"key\":\"0\",\"nid\":\"nid_1591964154538_11803\",\"text\":\"\u5426\"}],\"defaultValue\":\"1\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"inputrefer\",\"label\":\"\u6240\u5c5e\u9879\u76ee\",\"uititle\":\"\u6240\u5c5e\u9879\u76ee\",\"uikey\":\"projectId\",\"nid\":\"nid_1591869128536_8243\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"refinfokey\":\"market-project-refer-list\",\"refName\":\"\u9879\u76ee\u767b\u8bb0\u53c2\u7167\",\"refId\":\"320519315475660894\",\"required\":true},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"inputrefer\",\"label\":\"\u6240\u5c5e\u7ec4\u7ec7\",\"uititle\":\"\u6240\u5c5e\u7ec4\u7ec7\",\"uikey\":\"orgId\",\"nid\":\"nid_1591868579892_6518\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"refinfokey\":\"idm_org_tree\",\"refName\":\"\u7ec4\u7ec7\",\"refId\":\"310428626500755491\",\"required\":true,\"disabled\":true},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"inputrefer\",\"label\":\"\u4ed3\u5e93\",\"uititle\":\"\u4ed3\u5e93\",\"uikey\":\"storeId\",\"nid\":\"nid_1591868579892_6519\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"refinfokey\":\"material-warehouse-grid\",\"refName\":\"\u4ed3\u5e93\",\"refId\":\"326011743083167815\",\"required\":true},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"date\",\"label\":\"\u5165\u5e93\u65e5\u671f\",\"uititle\":\"\u5165\u5e93\u65e5\u671f\",\"uikey\":\"instoreDate\",\"nid\":\"nid_1591868579892_6517\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":15},\"required\":true,\"format\":\"yyyy-MM-dd\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"textarea\",\"label\":\"\u5907\u6ce8\",\"uititle\":\"\u5907\u6ce8\",\"nid\":\"nid_1591964395978_11981\",\"uikey\":\"note\",\"labelCol\":{\"span\":2},\"wrapperCol\":{\"span\":21},\"newline\":true,\"maxLength\":\"500\"},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"\u5165\u5e93\u5355\u53f7\",\"uititle\":\"\u5165\u5e93\u5355\u53f7\",\"uikey\":\"billCode\",\"nid\":\"nid_1591868579892_6522\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"visible\":false,\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"\u6240\u5c5e\u7ec4\u7ec7\u540d\u79f0\",\"uititle\":\"\u6240\u5c5e\u7ec4\u7ec7\u540d\u79f0\",\"uikey\":\"orgName\",\"nid\":\"nid_1591868579892_6523\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"visible\":false,\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"\u4ed3\u5e93\u540d\u79f0\",\"uititle\":\"\u4ed3\u5e93\u540d\u79f0\",\"uikey\":\"storeName\",\"nid\":\"nid_1591868579892_6524\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"visible\":false,\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"\u4f9b\u5e94\u5546\u540d\u79f0\",\"uititle\":\"\u4f9b\u5e94\u5546\u540d\u79f0\",\"uikey\":\"supplierName\",\"nid\":\"nid_1591868579892_6525\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"visible\":false,\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"\u5408\u540c\u540d\u79f0\",\"uititle\":\"\u5408\u540c\u540d\u79f0\",\"uikey\":\"contractName\",\"nid\":\"nid_1591868579892_6526\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"visible\":false,\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"\u4e3b\u952eID\",\"uititle\":\"\u4e3b\u952eID\",\"uikey\":\"id\",\"nid\":\"nid_1591868579892_6527\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"visible\":false,\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"\u6240\u5c5e\u9879\u76ee\u540d\u79f0\",\"uititle\":\"\u6240\u5c5e\u9879\u76ee\u540d\u79f0\",\"uikey\":\"projectName\",\"nid\":\"nid_1591869128536_8242\",\"visible\":false,\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"refAutoGrid\",\"label\":\"jj\",\"uititle\":\"jj\",\"nid\":\"nid_1592193054829_4\",\"uikey\":\"test\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14},\"valueType\":\"object\",\"maxSize\":\"20\",\"propKey\":[],\"refinfokey\":\"material-warehouse-grid\",\"refName\":\"\u4ed3\u5e93\",\"refId\":\"326011743083167815\",\"visible\":false},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"\u662f\u5426\u6709\u5408\u540c\u5165\u5e93\",\"uititle\":\"\u662f\u5426\u6709\u5408\u540c\u5165\u5e93\",\"nid\":\"nid_1592226325602_3668\",\"formLabelCol\":{\"span\":6},\"formWrapperCol\":{\"span\":14},\"uikey\":\"contractType\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14},\"visible\":false},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"\u5165\u5e93\u7c7b\u578b\",\"uititle\":\"\u5165\u5e93\u7c7b\u578b\",\"nid\":\"nid_1592278189469_2825\",\"uikey\":\"instoreType\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14},\"visible\":false},{\"uitype\":\"FormItemWidget\",\"uisubtype\":\"input\",\"label\":\"\u6240\u5c5e\u9879\u76ee\u7f16\u7801\",\"uititle\":\"\u6240\u5c5e\u9879\u76ee\u7f16\u7801\",\"nid\":\"nid_1603281495991_19\",\"uikey\":\"projectCode\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14},\"visible\":false}],\"uikey\":\"baseForm\",\"labelCol\":{\"span\":6},\"wrapperCol\":{\"span\":14}}],\"uikey\":\"\",\"title\":\"\u57fa\u672c\u4fe1\u606f\",\"expandText\":\"\u6536\u8d77\",\"collapseText\":\"\u5c55\u5f00\"},{\"uititle\":\"\u7269\u8d44\u660e\u7ec6\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1591868525762_6454\",\"children\":[{\"uititle\":\"\u5de5\u5177\u680f2\",\"uitype\":\"EJCToolbar\",\"nid\":\"nid_1591876014551_4857\",\"children\":[{\"uititle\":\"\u65b0\u589e\",\"uitype\":\"EJCButton\",\"nid\":\"nid_1591876157798_5112\",\"children\":\"\u65b0\u589e\",\"uikey\":\"addBtn\",\"ghost\":true,\"type\":\"primary\",\"icon\":\"plus\",\"visible\":false},{\"uititle\":\"\u53c2\u7167\u5408\u540c\",\"uitype\":\"EJCReferButton\",\"nid\":\"nid_1591876020589_4861\",\"buttonText\":\"\u53c2\u7167\u5408\u540c\",\"uikey\":\"contractMaterialBtn\",\"type\":\"primary\",\"ghost\":true,\"multiselect\":true,\"refinfokey\":\"material_contract_material_list\",\"refName\":\"\u5408\u540c\u7269\u8d44\u660e\u7ec6\u53c2\u7167\",\"refId\":\"327400432677945347\"}]},{\"uititle\":\"\u7f16\u8f91\u8868\u683c1\",\"uitype\":\"EditTableWidget\",\"nid\":\"nid_1591868529057_6457\",\"dataprops\":{\"system\":{\"id\":\"322683907509321758\",\"systemCnName\":\"\u7269\u8d44\u7ba1\u7406\",\"systemName\":\"ejc-material-web\"},\"entity\":{\"id\":\"326077713621450848\",\"entityCnName\":\"\u6536\u6599\u5165\u5e93-\u7269\u8d44\",\"entityFullName\":\"326077713621450848\"}},\"uikey\":\"instoreMaterialList\",\"rowKey\":\"id\",\"dataSource\":[],\"children\":[{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7269\u8d44\u5206\u7c7b\",\"title\":\"\u7269\u8d44\u5206\u7c7b\",\"uikey\":\"materialCategoryName\",\"key\":\"materialCategoryName\",\"dataIndex\":\"materialCategoryName\",\"nid\":\"nid_1591874317373_6\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7269\u8d44\u540d\u79f0\",\"title\":\"\u7269\u8d44\u540d\u79f0\",\"uikey\":\"materialName\",\"key\":\"materialName\",\"dataIndex\":\"materialName\",\"nid\":\"nid_1591874317373_5\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u89c4\u683c\u578b\u53f7\",\"title\":\"\u89c4\u683c\u578b\u53f7\",\"uikey\":\"materialSpec\",\"key\":\"materialSpec\",\"dataIndex\":\"materialSpec\",\"nid\":\"nid_1591874317373_4\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u8ba1\u91cf\u5355\u4f4d\",\"title\":\"\u8ba1\u91cf\u5355\u4f4d\",\"uikey\":\"materialUnit\",\"key\":\"materialUnit\",\"dataIndex\":\"materialUnit\",\"nid\":\"nid_1591874317373_3\",\"dataprops\":{},\"editable\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"\u5165\u5e93\u6570\u91cf\",\"title\":\"\u5165\u5e93\u6570\u91cf\",\"uikey\":\"instoreNumber\",\"key\":\"instoreNumber\",\"dataIndex\":\"instoreNumber\",\"nid\":\"nid_1591874317373_8\",\"align\":\"left\",\"required\":true,\"dataprops\":{},\"commaVisible\":true,\"decimal\":4,\"symbol\":\" \",\"max\":\"100000000000\",\"showDecimal\":2},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"\u5355\u4ef7\uff08\u5143\uff09\",\"title\":\"\u5355\u4ef7\uff08\u5143\uff09\",\"uikey\":\"unitPrice\",\"key\":\"unitPrice\",\"dataIndex\":\"unitPrice\",\"nid\":\"nid_1591874317373_12\",\"align\":\"left\",\"required\":true,\"dataprops\":{},\"commaVisible\":true,\"decimal\":8,\"symbol\":\" \",\"max\":\"100000000000\",\"showDecimal\":2},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"currency\",\"uititle\":\"\u91d1\u989d\uff08\u5143\uff09\",\"title\":\"\u91d1\u989d\uff08\u5143\uff09\",\"uikey\":\"amount\",\"key\":\"amount\",\"dataIndex\":\"amount\",\"nid\":\"nid_1591874317373_11\",\"align\":\"left\",\"dataprops\":{},\"commaVisible\":true,\"decimal\":8,\"symbol\":\" \",\"editable\":false,\"showDecimal\":2,\"max\":\"1000000000000000\"},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u5907\u6ce8\",\"title\":\"\u5907\u6ce8\",\"uikey\":\"remark\",\"key\":\"remark\",\"dataIndex\":\"remark\",\"nid\":\"nid_1591874317373_13\",\"dataprops\":{},\"maxLength\":\"100\"},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u4e3b\u8868id\",\"title\":\"\u4e3b\u8868id\",\"uikey\":\"instoreId\",\"key\":\"instoreId\",\"dataIndex\":\"instoreId\",\"nid\":\"nid_1591874317373_7\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7269\u8d44id\",\"title\":\"\u7269\u8d44id\",\"uikey\":\"materialId\",\"key\":\"materialId\",\"dataIndex\":\"materialId\",\"nid\":\"nid_1591874317373_9\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u7269\u8d44\u5206\u7c7bid\",\"title\":\"\u7269\u8d44\u5206\u7c7bid\",\"uikey\":\"materialCategoryId\",\"key\":\"materialCategoryId\",\"dataIndex\":\"materialCategoryId\",\"nid\":\"nid_1591874317373_10\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u6765\u6e90\",\"title\":\"\u6765\u6e90\",\"uikey\":\"sourceType\",\"key\":\"sourceType\",\"dataIndex\":\"sourceType\",\"nid\":\"nid_1591874317373_14\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"date\",\"uititle\":\"\u5165\u5e93\u65e5\u671f\",\"title\":\"\u5165\u5e93\u65e5\u671f\",\"uikey\":\"instoreDate\",\"key\":\"instoreDate\",\"dataIndex\":\"instoreDate\",\"nid\":\"nid_1592194593570_2122\",\"isShow\":false,\"dataprops\":{}},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u4ed3\u5e93id\",\"title\":\"\u4ed3\u5e93id\",\"uikey\":\"storeId\",\"key\":\"storeId\",\"dataIndex\":\"storeId\",\"nid\":\"nid_1592194595425_2124\",\"dataprops\":{},\"isShow\":false},{\"uitype\":\"EditItemWidget\",\"uisubtype\":\"input\",\"uititle\":\"\u5165\u5e93\u5e93\u7269\u8d44\u5e93\u5b58\u72b6\u6001\",\"title\":\"\u5165\u5e93\u5e93\u7269\u8d44\u5e93\u5b58\u72b6\u6001\",\"uikey\":\"storeState\",\"key\":\"storeState\",\"dataIndex\":\"storeState\",\"nid\":\"nid_1592195097419_3517\",\"dataprops\":{},\"isShow\":false}],\"showRowNum\":true}],\"uikey\":\"\",\"title\":\"\u7269\u8d44\u660e\u7ec6\",\"expandText\":\"\u6536\u8d77\",\"collapseText\":\"\u5c55\u5f00\"},{\"uititle\":\"\u5355\u636e\u5ba1\u8ba1\",\"uitype\":\"EJCPanel\",\"nid\":\"nid_1592309888000_2\",\"children\":[{\"uititle\":\"\u5355\u636e\u5ba1\u8ba11\",\"uitype\":\"CPAuditInfo\",\"nid\":\"nid_1592309903280_5\",\"uikey\":\"auditInfo\",\"primaryKey\":\"id\",\"billName\":\"\u6536\u6599\u5165\u5e93\",\"billType\":\"BT200611000000015\"}],\"uikey\":\"\",\"title\":\"\u5355\u636e\u5ba1\u8ba1\",\"expand\":false,\"expandText\":\"\u6536\u8d77\",\"collapseText\":\"\u5c55\u5f00\"}],\"nid\":\"nid_1591868670748_7019\"}";
        Map<String, List<JSONObject>> resultMap = ParsePageMetaUtils.parse(text);
        System.out.println(resultMap);
    }

    static {
        COMPONENT_TYPE.add("FormWidget");
        COMPONENT_TYPE.add("EditTableWidget");
    }
}

