/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.cust.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.foundation.cust.bean.FormTemplateEntity;
import com.ejianc.foundation.cust.service.IFormTemplateService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.Utils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/form/formTemplate/"})
public class FormTemplateController {
    @Autowired
    private IFormTemplateService formTemplateService;

    private String generateKey() {
        SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmss");
        return "cust" + Utils.randString((int)3).toLowerCase() + format.format(new Date());
    }

    @RequestMapping(value={"save"})
    public CommonResponse<FormTemplateEntity> save(@RequestBody FormTemplateEntity formTemplateEntity) {
        if (formTemplateEntity.getId() != null && formTemplateEntity.getId() > 0L) {
            this.formTemplateService.updateById((Object)formTemplateEntity);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        formTemplateEntity.setEditable(1);
        formTemplateEntity.setUniqueKey(this.generateKey());
        this.formTemplateService.save((Object)formTemplateEntity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"getObject"})
    public CommonResponse<FormTemplateEntity> getObject(HttpServletRequest request) {
        String id = request.getParameter("id");
        String key = request.getParameter("key");
        FormTemplateEntity formTemplate = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            formTemplate = (FormTemplateEntity)((Object)this.formTemplateService.getById((Serializable)((Object)id)));
        } else if (StringUtils.isNotBlank((CharSequence)key)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"unique_key", (Object)key);
            formTemplate = (FormTemplateEntity)((Object)this.formTemplateService.getOne((Wrapper)queryWrapper));
        }
        return CommonResponse.success(formTemplate);
    }

    @RequestMapping(value={"listJson"})
    public CommonResponse<IPage<FormTemplateEntity>> listJson(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.formTemplateService.queryPage(queryParam, false);
        return CommonResponse.success((Object)pageData);
    }

    @RequestMapping(value={"remove"})
    public CommonResponse<String> remove(HttpServletRequest request) {
        String[] arrIds;
        String ids = request.getParameter("id");
        for (String id : arrIds = ids.split(",")) {
            this.formTemplateService.removeById((Serializable)((Object)id));
        }
        return CommonResponse.success((String)"\u5220\u9664\u8868\u5355\u6a21\u677f\u6210\u529f");
    }

    @RequestMapping(value={"initTemplate"})
    public CommonResponse<String> initTemplate() {
        this.formTemplateService.init();
        return CommonResponse.success((String)"\u521d\u59cb\u5316\u6210\u529f");
    }
}

